/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.map.util;

import com.ryderbelserion.fusion.core.api.enums.FileAction;
import com.ryderbelserion.fusion.core.api.utils.FileUtils;
import com.ryderbelserion.map.Pl3xMapExtras;
import com.ryderbelserion.map.hook.Hook;
import com.ryderbelserion.map.hook.claims.claimchunk.ClaimChunkConfig;
import com.ryderbelserion.map.hook.claims.griefdefender.GriefDefenderConfig;
import com.ryderbelserion.map.hook.claims.griefprevention.GriefPreventionConfig;
import com.ryderbelserion.map.hook.claims.plotsquared.P2Config;
import com.ryderbelserion.map.hook.claims.worldguard.WorldGuardConfig;
import com.ryderbelserion.map.listener.banners.BannerListener;
import com.ryderbelserion.map.listener.banners.BannerWorldListener;
import com.ryderbelserion.map.listener.claims.ClaimListener;
import com.ryderbelserion.map.listener.mobs.MobEntityListener;
import com.ryderbelserion.map.listener.mobs.MobWorldListener;
import com.ryderbelserion.map.listener.signs.SignListener;
import com.ryderbelserion.map.listener.signs.SignWorldListener;
import com.ryderbelserion.map.listener.warps.WarpListener;
import com.ryderbelserion.map.marker.mobs.MobsManager;
import com.ryderbelserion.map.util.ConfigUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.world.World;
import org.bukkit.Server;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class ModuleUtil {
    private static final Pl3xMapExtras plugin = (Pl3xMapExtras)JavaPlugin.getPlugin(Pl3xMapExtras.class);
    private static final Server server = plugin.getServer();
    private static final PluginManager pluginManager = server.getPluginManager();

    public static void toggleAll(boolean isShutdown) {
        ModuleUtil.toggleSigns(isShutdown);
        ModuleUtil.toggleWarps(isShutdown);
        ModuleUtil.toggleBanners(isShutdown);
        ModuleUtil.toggleMobs(isShutdown);
        ModuleUtil.toggleClaims(isShutdown);
    }

    public static void toggleClaims(boolean isShutdown) {
        if (ConfigUtil.isClaimsEnabled() && !isShutdown) {
            pluginManager.registerEvents((Listener)new ClaimListener(), (Plugin)plugin);
            Pl3xMap.api().getWorldRegistry().forEach(ModuleUtil::registerWorld);
            if (pluginManager.isPluginEnabled("WorldGuard")) {
                WorldGuardConfig.reload();
            }
            if (pluginManager.isPluginEnabled("GriefPrevention")) {
                GriefPreventionConfig.reload();
            }
            if (pluginManager.isPluginEnabled("PlotSquared")) {
                P2Config.reload();
            }
            if (pluginManager.isPluginEnabled("GriefDefender")) {
                GriefDefenderConfig.reload();
            }
            if (pluginManager.isPluginEnabled("ClaimChunk")) {
                ClaimChunkConfig.reload();
            }
            return;
        }
        Pl3xMap.api().getWorldRegistry().forEach(ModuleUtil::unloadWorld);
        if (!isShutdown) {
            server.getGlobalRegionScheduler().cancelTasks((Plugin)plugin);
        }
    }

    public static void toggleWarps(boolean isShutdown) {
        if (ConfigUtil.isWarpsEnabled() && !isShutdown) {
            pluginManager.registerEvents((Listener)new WarpListener(), (Plugin)plugin);
            return;
        }
        Pl3xMap.api().getWorldRegistry().forEach(world -> {
            try {
                world.getLayerRegistry().unregister("playerwarps_warps");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    public static void toggleSigns(boolean isShutdown) {
        if (ConfigUtil.isSignsEnabled() && !isShutdown) {
            pluginManager.registerEvents((Listener)new SignWorldListener(), (Plugin)plugin);
            pluginManager.registerEvents((Listener)new SignListener(), (Plugin)plugin);
            return;
        }
        Pl3xMap.api().getWorldRegistry().forEach(world -> {
            try {
                world.getLayerRegistry().unregister("pl3xmap_signs");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    public static void toggleBanners(boolean isShutdown) {
        if (ConfigUtil.isBannersEnabled() && !isShutdown) {
            pluginManager.registerEvents((Listener)new BannerWorldListener(), (Plugin)plugin);
            pluginManager.registerEvents((Listener)new BannerListener(), (Plugin)plugin);
            return;
        }
        Pl3xMap.api().getWorldRegistry().forEach(world -> {
            try {
                world.getLayerRegistry().unregister("pl3xmap_banners");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    public static void toggleMobs(boolean isShutdown) {
        if (ConfigUtil.isMobsEnabled() && !isShutdown) {
            pluginManager.registerEvents((Listener)new MobWorldListener(), (Plugin)plugin);
            pluginManager.registerEvents((Listener)new MobEntityListener(), (Plugin)plugin);
            return;
        }
        Pl3xMap.api().getWorldRegistry().forEach(world -> {
            try {
                world.getLayerRegistry().unregister("pl3xmap_mobs");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        MobsManager manager = plugin.getMobsManager();
        if (manager != null) {
            manager.clearAll();
        }
        if (!isShutdown) {
            server.getGlobalRegionScheduler().cancelTasks((Plugin)plugin);
        }
    }

    public static void registerWorld(@NotNull World world) {
        Hook.hooks().forEach(hook -> hook.registerWorld(world));
    }

    public static void unloadWorld(@NotNull World world) {
        Hook.hooks().forEach(hook -> hook.unloadWorld(world));
    }

    public static void findHooks() {
        Arrays.stream(Hook.Impl.values()).forEach(impl -> {
            if (pluginManager.isPluginEnabled(impl.getPluginName())) {
                plugin.getLogger().info("Hooking into " + impl.getPluginName());
                Hook.add(impl);
            }
        });
    }

    public static void unload() {
        Pl3xMap.api().getWorldRegistry().forEach(world -> {
            try {
                world.getLayerRegistry().unregister("pl3xmap_mobs");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                world.getLayerRegistry().unregister("pl3xmap_banners");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                world.getLayerRegistry().unregister("pl3xmap_signs");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ModuleUtil.unloadWorld(world);
        });
    }

    public static void reload() {
        Hook.clear();
        ModuleUtil.findHooks();
    }

    public static void extract() {
        Path path = plugin.getDataPath();
        ArrayList<FileAction> actions = new ArrayList<FileAction>(){
            {
                this.add(FileAction.EXTRACT_FOLDER);
            }
        };
        if (ConfigUtil.isBannersEnabled()) {
            FileUtils.extract("banners/icons", path, (List<FileAction>)actions);
        }
        if (ConfigUtil.isWarpsEnabled()) {
            FileUtils.extract("warps/icons", path, (List<FileAction>)actions);
        }
        if (ConfigUtil.isSignsEnabled()) {
            FileUtils.extract("signs/icons", path, (List<FileAction>)actions);
        }
        if (ConfigUtil.isMobsEnabled()) {
            FileUtils.extract("mobs/icons", path, (List<FileAction>)actions);
        }
    }
}

