/*
 * Decompiled with CFR 0.152.
 */
package org.foodcraft.block;

import java.util.Collections;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3542;
import net.minecraft.class_3965;
import net.minecraft.class_4174;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_8567;
import org.dfood.util.IntPropertyManager;
import org.foodcraft.block.SimpleFoodBlock;
import org.foodcraft.component.ModFoodComponents;
import org.foodcraft.registry.ModBlocks;

public class BreadBoatBlock
extends SimpleFoodBlock {
    public final class_2758 BITES;
    public final int maxUse;
    public final SoupType soupType;

    public BreadBoatBlock(class_4970.class_2251 settings, int maxUse, SoupType soupType) {
        super(settings);
        this.maxUse = maxUse;
        this.soupType = soupType;
        this.BITES = IntPropertyManager.create((String)"bites", (int)0, (int)maxUse);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)this.BITES, (Comparable)Integer.valueOf(0)));
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 handStack = player.method_5998(hand);
        if (this.soupType == SoupType.EMPTY) {
            for (SoupType potentialSoupType : SoupType.values()) {
                class_2248 fullBoatBlock;
                if (potentialSoupType == SoupType.EMPTY || handStack.method_7909() != potentialSoupType.getSourceItem() || (fullBoatBlock = this.getFullBoatBlock(potentialSoupType)) == null) continue;
                world.method_8501(pos, fullBoatBlock.method_9564());
                if (!player.method_31549().field_7477) {
                    handStack.method_7934(1);
                    class_1799 bowlStack = new class_1799((class_1935)class_1802.field_8428);
                    if (handStack.method_7960()) {
                        player.method_6122(hand, bowlStack);
                    } else if (!player.method_31548().method_7394(bowlStack)) {
                        player.method_7328(bowlStack, false);
                    }
                }
                return class_1269.field_5812;
            }
        } else {
            int currentBites = (Integer)state.method_11654((class_2769)this.BITES);
            if (!player.method_7332(false)) {
                if (!world.field_9236) {
                    class_1799 itemStack = new class_1799((class_1935)this.method_8389());
                    player.method_31548().method_7398(itemStack);
                    world.method_22352(pos, false);
                }
                return class_1269.field_5812;
            }
            return this.tryDrinkSoup((class_1936)world, pos, state, player);
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }

    protected class_1269 tryDrinkSoup(class_1936 world, class_2338 pos, class_2680 state, class_1657 player) {
        int currentBites = (Integer)state.method_11654((class_2769)this.BITES);
        world.method_8396(player, pos, class_3417.field_20613, player.method_5634(), 1.0f, 1.0f);
        player.method_7344().method_7585(this.soupType.getFoodComponent().method_19230() / this.maxUse, this.soupType.getFoodComponent().method_19231() / (float)this.maxUse);
        world.method_33596((class_1297)player, class_5712.field_28735, pos);
        if (currentBites < this.maxUse) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)this.BITES, (Comparable)Integer.valueOf(currentBites + 1)), 3);
        } else {
            world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
        }
        return class_1269.field_5812;
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        int currentBites = (Integer)state.method_11654((class_2769)this.BITES);
        if (!world.field_9236 && currentBites > 0 && this.soupType != SoupType.EMPTY) {
            int remainingBites = this.maxUse - currentBites;
            int hunger = this.soupType.getFoodComponent().method_19230() / this.maxUse * remainingBites;
            float saturation = this.soupType.getFoodComponent().method_19231() / (float)this.maxUse * (float)remainingBites;
            player.method_7344().method_7585(hunger, saturation);
            world.method_33596((class_1297)player, class_5712.field_28735, pos);
        }
        super.method_9576(world, pos, state, player);
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        int bites = (Integer)state.method_11654((class_2769)this.BITES);
        if (bites == 0) {
            return super.method_9560(state, builder);
        }
        return Collections.emptyList();
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{IntPropertyManager.take()});
    }

    private class_2248 getFullBoatBlock(SoupType soupType) {
        return switch (soupType.ordinal()) {
            case 2 -> ModBlocks.MUSHROOM_STEW_HARD_BREAD_BOAT;
            case 1 -> ModBlocks.BEETROOT_SOUP_HARD_BREAD_BOAT;
            default -> null;
        };
    }

    public static enum SoupType implements class_3542
    {
        EMPTY("empty", null, null),
        BEETROOT_SOUP("beetroot_soup", ModFoodComponents.BEETROOT_SOUP_HARD_BREAD_BOAT, class_1802.field_8515),
        MUSHROOM_STEW("mushroom_stew", ModFoodComponents.MUSHROOM_STEW_HARD_BREAD_BOAT, class_1802.field_8208);

        private final String name;
        private final class_4174 foodComponent;
        private final class_1792 sourceItem;

        private SoupType(String name, class_4174 foodComponent, class_1792 sourceItem) {
            this.name = name;
            this.foodComponent = foodComponent;
            this.sourceItem = sourceItem;
        }

        public String method_15434() {
            return this.name;
        }

        public class_4174 getFoodComponent() {
            return this.foodComponent;
        }

        public class_1792 getSourceItem() {
            return this.sourceItem;
        }

        public static SoupType fromString(String name) {
            for (SoupType soupType : SoupType.values()) {
                if (!soupType.name.equals(name)) continue;
                return soupType;
            }
            return EMPTY;
        }

        public boolean hasFoodComponent() {
            return this.foodComponent != null;
        }
    }
}

