/*
 * Decompiled with CFR 0.152.
 */
package org.foodcraft.block;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import org.dfood.block.FoodBlock;
import org.dfood.tag.ModTags;
import org.foodcraft.block.FirewoodBlock;
import org.foodcraft.block.entity.CombustionFirewoodBlockEntity;
import org.foodcraft.registry.ModBlockEntityTypes;
import org.foodcraft.registry.ModItems;
import org.foodcraft.registry.ModSounds;
import org.jetbrains.annotations.Nullable;

public class CombustionFirewoodBlock
extends class_2237 {
    public static final class_2753 HORIZONTAL_FACING = class_2741.field_12481;
    public static final class_2754<CombustionState> COMBUSTION_STATE = class_2754.method_11850((String)"combustion_state", CombustionState.class);

    public CombustionFirewoodBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)this.method_9564().method_11657(COMBUSTION_STATE, (Comparable)((Object)CombustionState.FIRST_IGNITED)));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return FirewoodBlock.SHAPE;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (this.isCompletelyExtinguished(world, pos, state)) {
            if (!world.method_8608()) {
                world.method_8651(pos, false, (class_1297)player);
                class_8567.class_8568 builder = new class_8567.class_8568((class_3218)world).method_51874(class_181.field_24424, (Object)pos.method_46558()).method_51874(class_181.field_1229, (Object)class_1802.field_8162.method_7854()).method_51877(class_181.field_1226, (Object)player);
                List<class_1799> drops = this.method_9560(state, builder);
                for (class_1799 foodItem : drops) {
                    if (player.method_7337() || player.method_7270(foodItem)) continue;
                    player.method_7328(foodItem, false);
                }
            }
            return class_1269.field_5812;
        }
        class_1799 stack = player.method_5998(hand);
        if (stack.method_7909() == ModItems.FIREWOOD) {
            return this.tryAddFirewood(world, pos, player, stack);
        }
        return class_1269.field_5811;
    }

    private boolean isCompletelyExtinguished(class_1937 world, class_2338 pos, class_2680 state) {
        if (world.method_8608()) {
            CombustionState combustionState = (CombustionState)((Object)state.method_11654(COMBUSTION_STATE));
            return combustionState == CombustionState.FIRST_EXTINGUISHED || combustionState == CombustionState.AGAIN_EXTINGUISHED;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof CombustionFirewoodBlockEntity) {
            CombustionFirewoodBlockEntity firewoodEntity = (CombustionFirewoodBlockEntity)blockEntity;
            return firewoodEntity.isCompletelyExtinguished();
        }
        return false;
    }

    private class_1269 tryAddFirewood(class_1937 world, class_2338 pos, class_1657 player, class_1799 stack) {
        if (world.method_8608()) {
            return class_1269.field_5812;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (!(blockEntity instanceof CombustionFirewoodBlockEntity)) {
            return class_1269.field_5814;
        }
        CombustionFirewoodBlockEntity firewoodEntity = (CombustionFirewoodBlockEntity)blockEntity;
        boolean success = firewoodEntity.addFirewood();
        if (!success) {
            return class_1269.field_5814;
        }
        if (!player.method_7337()) {
            stack.method_7934(1);
        }
        world.method_8396(null, pos, class_3417.field_15145, class_3419.field_15245, 1.0f, 1.0f);
        return class_1269.field_5812;
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        CombustionState currentState = (CombustionState)((Object)state.method_11654(COMBUSTION_STATE));
        if (currentState.isBurning()) {
            int i;
            if (random.method_43048(5) == 0) {
                world.method_8486((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, ModSounds.COMBUSTION_FIREWOOD, class_3419.field_15245, 0.3f, 0.3f, true);
            }
            if (random.method_43048(5) == 0) {
                for (i = 0; i < random.method_43048(1) + 1; ++i) {
                    world.method_8406((class_2394)class_2398.field_17431, (double)pos.method_10263() + 0.5 + random.method_43058() / 3.0 * (double)(random.method_43056() ? 1 : -1), (double)pos.method_10264() + random.method_43058() + random.method_43058(), (double)pos.method_10260() + 0.5 + random.method_43058() / 3.0 * (double)(random.method_43056() ? 1 : -1), 0.0, 0.07, 0.0);
                }
            }
            if (random.method_43048(3) == 0) {
                for (i = 0; i < random.method_43048(2) + 1; ++i) {
                    world.method_8406((class_2394)class_2398.field_11239, (double)pos.method_10263() + 0.5 + random.method_43058() / 4.0 * (double)(random.method_43056() ? 1 : -1), (double)pos.method_10264() + 0.4, (double)pos.method_10260() + 0.5 + random.method_43058() / 4.0 * (double)(random.method_43056() ? 1 : -1), (double)(random.method_43057() / 2.0f), 0.04, (double)(random.method_43057() / 2.0f));
                }
            }
            if (random.method_43048(4) == 0) {
                for (i = 0; i < random.method_43048(2) + 1; ++i) {
                    world.method_8406((class_2394)class_2398.field_11240, (double)pos.method_10263() + 0.5 + random.method_43058() / 2.0 * (double)(random.method_43056() ? 1 : -1), (double)pos.method_10264() + 0.2, (double)pos.method_10260() + 0.5 + random.method_43058() / 2.0 * (double)(random.method_43056() ? 1 : -1), 0.0, 0.04, 0.0);
                }
            }
        }
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        CombustionState currentState = (CombustionState)((Object)state.method_11654(COMBUSTION_STATE));
        if (currentState.isBurning() && entity instanceof class_1309 && !class_1890.method_8216((class_1309)((class_1309)entity))) {
            entity.method_5643(world.method_48963().method_48794(), 1.0f);
        }
        super.method_9548(state, world, pos, entity);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        return !state.method_26184((class_4538)world, pos) ? class_2246.field_10124.method_9564() : super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2338 downPos = pos.method_10074();
        class_2680 checkState = world.method_8320(downPos);
        return !checkState.method_26164(ModTags.FOOD_PLACE) && !(checkState.method_26204() instanceof FoodBlock);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{COMBUSTION_STATE, HORIZONTAL_FACING});
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new CombustionFirewoodBlockEntity(pos, state);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return world.field_9236 ? null : CombustionFirewoodBlock.method_31618(type, ModBlockEntityTypes.COMBUSTION_FIREWOOD, CombustionFirewoodBlockEntity::tick);
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        CombustionState combustionState = (CombustionState)((Object)state.method_11654(COMBUSTION_STATE));
        if (!combustionState.isBurning()) {
            return super.method_9560(state, builder);
        }
        return List.of();
    }

    public static enum CombustionState implements class_3542
    {
        FIRST_IGNITED("first_ignited", 0, true, 1.0f),
        FIRST_HALF("first_half", 1, true, 0.5f),
        FIRST_EXTINGUISHED("first_extinguished", 2, false, 0.0f),
        AGAIN_IGNITED("again_ignited", 3, true, 1.0f),
        AGAIN_HALF("again_half", 4, true, 0.5f),
        REIGNITED("reignited", 5, true, 1.0f),
        AGAIN_EXTINGUISHED("again_extinguished", 6, false, 0.0f);

        private final String id;
        private final int index;
        private final boolean burning;
        private final float particleIntensity;

        private CombustionState(String id, int index, boolean burning, float particleIntensity) {
            this.id = id;
            this.index = index;
            this.burning = burning;
            this.particleIntensity = particleIntensity;
        }

        public String method_15434() {
            return this.id;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isBurning() {
            return this.burning;
        }

        public float getParticleIntensity() {
            return this.particleIntensity;
        }

        public static CombustionState byIndex(int index) {
            for (CombustionState state : CombustionState.values()) {
                if (state.getIndex() != index) continue;
                return state;
            }
            return FIRST_IGNITED;
        }
    }
}

