/*
 * Decompiled with CFR 0.152.
 */
package org.foodcraft.block;

import java.util.Optional;
import net.minecraft.class_1258;
import net.minecraft.class_1263;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4732;
import net.minecraft.class_4970;
import org.dfood.tag.ModTags;
import org.foodcraft.block.UpPlaceBlock;
import org.foodcraft.block.entity.DishesBlockEntity;
import org.foodcraft.block.entity.UpPlaceBlockEntity;
import org.jetbrains.annotations.Nullable;

public class DishesBlock
extends UpPlaceBlock {
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2754<DishesType> TYPE = class_2754.method_11850((String)"type", DishesType.class);
    private static final class_265 BASE_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.5, (double)16.0);
    private static final class_4732.class_3923<DishesBlockEntity, Optional<class_1263>> INVENTORY_RETRIEVER = new class_4732.class_3923<DishesBlockEntity, Optional<class_1263>>(){

        public Optional<class_1263> getFromBoth(DishesBlockEntity first, DishesBlockEntity second) {
            return Optional.of(new class_1258((class_1263)first, (class_1263)second));
        }

        public Optional<class_1263> getFrom(DishesBlockEntity single) {
            return Optional.of(single);
        }

        public Optional<class_1263> getFallback() {
            return Optional.empty();
        }
    };

    public DishesBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(TYPE, (Comparable)((Object)DishesType.SINGLE)));
    }

    @Override
    public class_265 getBaseShape(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return BASE_SHAPE;
    }

    @Override
    public boolean canFetched(UpPlaceBlockEntity blockEntity, class_1799 handStack) {
        class_1792 contentItem = blockEntity.getContentItem();
        return handStack.method_7960() || contentItem != null && handStack.method_7909() != contentItem || blockEntity.isFull();
    }

    @Override
    public boolean canPlace(UpPlaceBlockEntity blockEntity, class_1799 handStack) {
        return blockEntity.isValidItem(handStack);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (!state.method_26184((class_4538)world, pos)) {
            return class_2246.field_10124.method_9564();
        }
        if (neighborState.method_27852((class_2248)this) && direction.method_10166().method_10179()) {
            DishesType neighborType = (DishesType)((Object)neighborState.method_11654(TYPE));
            if (state.method_11654(TYPE) == DishesType.SINGLE && neighborType != DishesType.SINGLE && state.method_11654((class_2769)FACING) == neighborState.method_11654((class_2769)FACING) && DishesBlock.getFacing(neighborState) == direction.method_10153()) {
                return (class_2680)state.method_11657(TYPE, (Comparable)((Object)neighborType.getOpposite()));
            }
        } else if (DishesBlock.getFacing(state) == direction) {
            return (class_2680)state.method_11657(TYPE, (Comparable)((Object)DishesType.SINGLE));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public static class_2350 getFacing(class_2680 state) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        return state.method_11654(TYPE) == DishesType.LEFT ? direction.method_10170() : direction.method_10160();
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new DishesBlockEntity(pos, state);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    private class_2350 getNeighborDishesDirection(class_1750 ctx, class_2350 dir) {
        class_2680 blockState = ctx.method_8045().method_8320(ctx.method_8037().method_10093(dir));
        return blockState.method_27852((class_2248)this) && blockState.method_11654(TYPE) == DishesType.SINGLE ? (class_2350)blockState.method_11654((class_2769)FACING) : null;
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2350 neighborDirection;
        DishesType dishesType = DishesType.SINGLE;
        class_2350 direction = ctx.method_8042();
        boolean isSneaking = ctx.method_8046();
        class_2350 side = ctx.method_8038();
        if (side.method_10166().method_10179() && isSneaking && (neighborDirection = this.getNeighborDishesDirection(ctx, side.method_10153())) != null && neighborDirection.method_10166() != side.method_10166()) {
            direction = neighborDirection;
            DishesType dishesType2 = dishesType = neighborDirection.method_10160() == side.method_10153() ? DishesType.RIGHT : DishesType.LEFT;
        }
        if (dishesType == DishesType.SINGLE && !isSneaking) {
            if (direction == this.getNeighborDishesDirection(ctx, direction.method_10170())) {
                dishesType = DishesType.LEFT;
            } else if (direction == this.getNeighborDishesDirection(ctx, direction.method_10160())) {
                dishesType = DishesType.RIGHT;
            }
        }
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)direction)).method_11657(TYPE, (Comparable)((Object)dishesType));
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2338 downPos = pos.method_10074();
        return !world.method_8320(downPos).method_26164(ModTags.FOOD_PLACE);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, TYPE});
    }

    public static enum DishesType implements class_3542
    {
        SINGLE("single"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private DishesType(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public DishesType getOpposite() {
            return switch (this.ordinal()) {
                case 1 -> RIGHT;
                case 2 -> LEFT;
                default -> SINGLE;
            };
        }
    }
}

