/*
 * Decompiled with CFR 0.152.
 */
package org.foodcraft.block;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import org.dfood.block.FoodBlock;
import org.dfood.shape.FoodShapeHandle;
import org.foodcraft.block.CombustionFirewoodBlock;
import org.foodcraft.block.entity.CombustionFirewoodBlockEntity;

public class FirewoodBlock
extends FoodBlock {
    public static final class_2753 HORIZONTAL_FACING = class_2741.field_12481;
    protected static final class_265 SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    protected final class_2248 targetBlock;

    public FirewoodBlock(class_4970.class_2251 settings, int max_food, class_2248 targetBlock) {
        super(settings, max_food, false);
        this.targetBlock = targetBlock;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE_HANDLE.getShape(state, this.NUMBER_OF_FOOD, Shapes.class);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof FirewoodBlock) {
            FirewoodBlock firewoodBlock = (FirewoodBlock)class_22482;
            if (player.method_5998(hand).method_7909() == class_1802.field_8884) {
                boolean bl = firewoodBlock.tryIgnite(state, world, pos, player);
                return bl ? class_1269.field_5812 : class_1269.field_5811;
            }
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }

    public boolean tryIgnite(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        int currentCount = (Integer)state.method_11654((class_2769)this.NUMBER_OF_FOOD);
        if (currentCount != 2 || world.method_8608()) {
            return false;
        }
        if (!FirewoodBlock.hasClearSpaceAbove(world, pos)) {
            world.method_8396(null, pos, class_3417.field_15102, class_3419.field_15245, 0.5f, 1.0f);
            return false;
        }
        world.method_8501(pos, (class_2680)((class_2680)this.targetBlock.method_9564().method_11657((class_2769)HORIZONTAL_FACING, (Comparable)((class_2350)state.method_11654((class_2769)HORIZONTAL_FACING)))).method_11657(CombustionFirewoodBlock.COMBUSTION_STATE, (Comparable)((Object)CombustionFirewoodBlock.CombustionState.FIRST_IGNITED)));
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof CombustionFirewoodBlockEntity) {
            CombustionFirewoodBlockEntity firewoodEntity = (CombustionFirewoodBlockEntity)blockEntity;
            firewoodEntity.setEnergy(CombustionFirewoodBlockEntity.getMaxEnergy());
            firewoodEntity.setFirstCycle(true);
            firewoodEntity.setCycleCount(0);
        }
        world.method_33596((class_1297)player, class_5712.field_28733, pos);
        return true;
    }

    public static boolean hasClearSpaceAbove(class_1937 world, class_2338 pos) {
        for (int i = 1; i <= 6; ++i) {
            class_2338 checkPos = pos.method_10086(i);
            class_2680 state = world.method_8320(checkPos);
            if (state.method_26215()) continue;
            return false;
        }
        return true;
    }

    public boolean canIgnite(class_1937 world, class_2338 pos) {
        return FirewoodBlock.hasClearSpaceAbove(world, pos);
    }

    public static enum Shapes implements FoodShapeHandle.ShapeConvertible
    {
        SHAPE_A(1, class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0)),
        SHAPE_B(2, class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0)),
        SHAPE_C(3, class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0)),
        SHAPE_D(4, class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0)),
        SHAPE_E(5, class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));

        private final class_265 shape;
        private final int id;

        private Shapes(int id, class_265 shape) {
            this.shape = shape;
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public class_265 getShape() {
            return this.shape;
        }

        public static class_265 getShape(int id) {
            for (Shapes s : Shapes.values()) {
                if (s.id != id) continue;
                return s.shape;
            }
            return Shapes.SHAPE_A.shape;
        }
    }
}

