/*
 * Decompiled with CFR 0.152.
 */
package org.foodcraft.block;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_4970;
import net.minecraft.class_8567;
import org.dfood.block.FoodBlock;
import org.foodcraft.block.entity.FlourSackBlockEntity;
import org.foodcraft.item.FlourItem;
import org.foodcraft.item.FlourSackItem;
import org.jetbrains.annotations.Nullable;

public class FlourSackBlock
extends FoodBlock
implements class_2343 {
    public static final class_2758 SHELF_INDEX = class_2758.method_11867((String)"shelf_index", (int)0, (int)1);

    public FlourSackBlock(class_4970.class_2251 settings, int maxFood) {
        super(settings, maxFood);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)this.NUMBER_OF_FOOD, (Comparable)Integer.valueOf(1))).method_11657((class_2769)SHELF_INDEX, (Comparable)Integer.valueOf(0)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{SHELF_INDEX});
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)Objects.requireNonNull(super.method_9605(ctx)).method_11657((class_2769)SHELF_INDEX, (Comparable)Integer.valueOf(0));
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new FlourSackBlockEntity(pos, state);
    }

    protected boolean tryAdd(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1799 handStack, class_2586 blockEntity) {
        if (this.isSackStackingOperation(handStack, blockEntity)) {
            return this.handleSackStacking(state, world, pos, handStack, (FlourSackBlockEntity)blockEntity);
        }
        return false;
    }

    protected boolean tryRemove(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_2586 blockEntity) {
        if (this.isSackRemovalOperation(blockEntity)) {
            return this.handleSackRemoval(state, world, pos, player, (FlourSackBlockEntity)blockEntity);
        }
        return super.tryRemove(state, world, pos, player, blockEntity);
    }

    public boolean isSame(class_1799 stack, class_2586 blockEntity) {
        if (!(blockEntity instanceof FlourSackBlockEntity)) {
            return false;
        }
        FlourSackBlockEntity flourSackEntity = (FlourSackBlockEntity)blockEntity;
        if (stack.method_7909() != this.method_8389()) {
            return false;
        }
        if (stack.method_7909() instanceof FlourSackItem) {
            return this.areSackContentsCompatible(stack, flourSackEntity);
        }
        if (stack.method_7909() instanceof FlourItem) {
            return this.isFlourCompatibleWithSacks(stack, flourSackEntity);
        }
        return false;
    }

    public class_1799 createStack(int count, @Nullable class_2586 blockEntity) {
        if (blockEntity instanceof FlourSackBlockEntity) {
            FlourSackBlockEntity flourSackEntity = (FlourSackBlockEntity)blockEntity;
            return this.createSackItemFromEntity(flourSackEntity);
        }
        return super.createStack(count, blockEntity);
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        FlourSackBlockEntity flourSackEntity;
        class_2371<class_1799> droppedStacks;
        class_2586 blockEntity = (class_2586)builder.method_51873(class_181.field_1228);
        if (blockEntity instanceof FlourSackBlockEntity && !(droppedStacks = FlourSackItem.fromBlockEntity(flourSackEntity = (FlourSackBlockEntity)blockEntity)).isEmpty()) {
            return droppedStacks;
        }
        return super.method_9560(state, builder);
    }

    private boolean isSackStackingOperation(class_1799 handStack, class_2586 blockEntity) {
        return handStack.method_7909() instanceof FlourSackItem && blockEntity instanceof FlourSackBlockEntity;
    }

    private boolean isSackRemovalOperation(class_2586 blockEntity) {
        FlourSackBlockEntity flourSackEntity;
        return blockEntity instanceof FlourSackBlockEntity && (flourSackEntity = (FlourSackBlockEntity)blockEntity).getSackCount() > 1;
    }

    private boolean handleSackStacking(class_2680 state, class_1937 world, class_2338 pos, class_1799 handStack, FlourSackBlockEntity entity) {
        if (entity.canAddSack(handStack) && entity.addSack(handStack)) {
            this.updateBlockState(world, pos, state, entity);
            return true;
        }
        return false;
    }

    private boolean handleSackRemoval(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, FlourSackBlockEntity entity) {
        class_1799 removedSack = entity.removeSack();
        if (!removedSack.method_7960()) {
            this.giveItemToPlayer(player, removedSack);
            this.updateBlockState(world, pos, state, entity);
            return true;
        }
        return false;
    }

    private boolean areSackContentsCompatible(class_1799 stack, FlourSackBlockEntity entity) {
        Optional<class_1799> handContent = FlourSackItem.getFirstBundledStack(stack);
        for (int i = 0; i < entity.getSackCount(); ++i) {
            class_1799 sackContent = entity.getSackContent(i);
            if (this.isContentCompatible(sackContent, handContent)) continue;
            return false;
        }
        return true;
    }

    private boolean isFlourCompatibleWithSacks(class_1799 flourStack, FlourSackBlockEntity entity) {
        for (int i = 0; i < entity.getSackCount(); ++i) {
            class_1799 sackContent = entity.getSackContent(i);
            if (sackContent.method_7960() || class_1799.method_7984((class_1799)sackContent, (class_1799)flourStack)) continue;
            return false;
        }
        return true;
    }

    private boolean isContentCompatible(class_1799 existingContent, Optional<class_1799> newContent) {
        boolean hasExistingContent = !existingContent.method_7960();
        boolean hasNewContent = newContent.isPresent();
        if (hasExistingContent && hasNewContent) {
            return class_1799.method_7984((class_1799)existingContent, (class_1799)newContent.get());
        }
        return false;
    }

    private class_1799 createSackItemFromEntity(FlourSackBlockEntity entity) {
        class_1799 firstContent;
        class_1799 sackItem = new class_1799((class_1935)this.method_8389());
        if (entity.getSackCount() > 0 && !(firstContent = entity.getSackContent(0)).method_7960()) {
            class_2487 nbt = this.createSackNbt(firstContent);
            sackItem.method_7980(nbt);
        }
        return sackItem;
    }

    private class_2487 createSackNbt(class_1799 content) {
        class_2487 nbt = new class_2487();
        class_2499 items = new class_2499();
        class_2487 itemNbt = new class_2487();
        content.method_7953(itemNbt);
        items.add((Object)itemNbt);
        nbt.method_10566("Items", (class_2520)items);
        return nbt;
    }

    private void giveItemToPlayer(class_1657 player, class_1799 stack) {
        if (!player.method_7337() && !player.method_7270(stack)) {
            player.method_7328(stack, false);
        }
    }

    private void updateBlockState(class_1937 world, class_2338 pos, class_2680 state, FlourSackBlockEntity entity) {
        int sackCount = entity.getSackCount();
        if (sackCount <= 0) {
            world.method_22352(pos, false);
        } else {
            class_2680 newState = (class_2680)state.method_11657((class_2769)this.NUMBER_OF_FOOD, (Comparable)Integer.valueOf(sackCount));
            world.method_8652(pos, newState, 3);
        }
    }

    public class_1799 getSackStack(class_1937 world, class_2338 pos, int index) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof FlourSackBlockEntity) {
            FlourSackBlockEntity flourSackEntity = (FlourSackBlockEntity)blockEntity;
            return flourSackEntity.getSackStack(index);
        }
        return class_1799.field_8037;
    }

    public int getFlourColor(class_1937 world, class_2338 pos, int index) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof FlourSackBlockEntity) {
            FlourSackBlockEntity flourSackEntity = (FlourSackBlockEntity)blockEntity;
            return flourSackEntity.getFlourColor(index);
        }
        return 0xFFFFFF;
    }

    public int[] getAllFlourColors(class_1937 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof FlourSackBlockEntity) {
            FlourSackBlockEntity flourSackEntity = (FlourSackBlockEntity)blockEntity;
            return flourSackEntity.getAllFlourColors();
        }
        return new int[0];
    }

    public boolean isValidSackIndex(class_1937 world, class_2338 pos, int index) {
        FlourSackBlockEntity flourSackEntity;
        class_2586 blockEntity = world.method_8321(pos);
        return blockEntity instanceof FlourSackBlockEntity && (flourSackEntity = (FlourSackBlockEntity)blockEntity).isValidSackIndex(index);
    }
}

