/*
 * Decompiled with CFR 0.152.
 */
package org.foodcraft.block;

import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2694;
import net.minecraft.class_2697;
import net.minecraft.class_2700;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import org.foodcraft.block.CombustionFirewoodBlock;
import org.foodcraft.block.FirewoodBlock;
import org.foodcraft.block.UpPlaceBlock;
import org.foodcraft.block.entity.CombustionFirewoodBlockEntity;
import org.foodcraft.block.entity.HeatResistantSlateBlockEntity;
import org.foodcraft.block.entity.UpPlaceBlockEntity;
import org.foodcraft.block.multi.MultiBlockHelper;
import org.foodcraft.item.MoldContentItem;
import org.foodcraft.registry.ModBlockEntityTypes;
import org.foodcraft.registry.ModSounds;
import org.jetbrains.annotations.Nullable;

public class HeatResistantSlateBlock
extends UpPlaceBlock {
    protected static final class_265 BASE_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    public static final class_2700 stove1x1;
    public static final class_2700 stove1x2;
    public static final class_2700 stove2x2;
    public static final class_2700 stove2x3;

    public HeatResistantSlateBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        super.method_9615(state, world, pos, oldState, notify);
        if (!world.field_9236) {
            MultiBlockHelper.onCoreBlockPlaced(world, pos, (class_2248)this);
        }
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_2586 blockEntity;
        if (!state.method_27852(newState.method_26204()) && (blockEntity = world.method_8321(pos)) instanceof HeatResistantSlateBlockEntity) {
            HeatResistantSlateBlockEntity heatResistantSlateBlockEntity = (HeatResistantSlateBlockEntity)blockEntity;
            if (!heatResistantSlateBlockEntity.originalInputStack.method_7960()) {
                class_2371 originalInputList = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
                originalInputList.add((Object)heatResistantSlateBlockEntity.originalInputStack);
                class_1264.method_17349((class_1937)world, (class_2338)pos, (class_2371)originalInputList);
            } else {
                class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)((class_1263)blockEntity));
            }
            class_2371<class_1799> otherStack = heatResistantSlateBlockEntity.getOtherStacks();
            class_1264.method_17349((class_1937)world, (class_2338)pos, otherStack);
            world.method_8455(pos, (class_2248)this);
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 blockEntity = world.method_8321(pos);
        class_1269 result = super.method_9534(state, world, pos, player, hand, hit);
        if (!result.method_23665() && blockEntity instanceof HeatResistantSlateBlockEntity) {
            HeatResistantSlateBlockEntity heatResistantSlateBlockEntity = (HeatResistantSlateBlockEntity)blockEntity;
            for (CombustionFirewoodBlockEntity firewoodEntity : heatResistantSlateBlockEntity.getFirewoodEntities()) {
                class_2680 firewoodState = firewoodEntity.method_11010();
                class_1269 firewoodResult = firewoodState.method_26204().method_9534(firewoodState, world, firewoodEntity.method_11016(), player, hand, hit);
                if (!firewoodResult.method_23665()) continue;
                return firewoodResult;
            }
        }
        return result;
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        HeatResistantSlateBlockEntity heatResistantSlateBlockEntity;
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof HeatResistantSlateBlockEntity && (heatResistantSlateBlockEntity = (HeatResistantSlateBlockEntity)blockEntity).isBaking()) {
            if (random.method_43048(5) == 0) {
                for (int i = 0; i < random.method_43048(1) + 1; ++i) {
                    world.method_8406((class_2394)class_2398.field_11204, (double)pos.method_10263() + 0.5 + random.method_43058() / 3.0 * (double)(random.method_43056() ? 1 : -1), (double)pos.method_10264() + random.method_43058() + random.method_43058(), (double)pos.method_10260() + 0.5 + random.method_43058() / 3.0 * (double)(random.method_43056() ? 1 : -1), 0.0, 0.07, 0.0);
                }
            }
            if (random.method_43048(5) == 0) {
                world.method_8486((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, ModSounds.COOKING_SOUND, class_3419.field_15245, 0.3f, 0.3f, true);
            }
        }
    }

    @Override
    public class_265 getBaseShape(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return BASE_SHAPE;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        HeatResistantSlateBlockEntity blockEntity;
        class_2586 entity = world.method_8321(pos);
        if (entity instanceof HeatResistantSlateBlockEntity && !(blockEntity = (HeatResistantSlateBlockEntity)entity).isOtherEmpty()) {
            return class_259.method_1084((class_265)this.getBaseShape(state, world, pos, context), (class_265)blockEntity.getContentShape(state, world, pos, context));
        }
        return super.method_9530(state, world, pos, context);
    }

    @Override
    public boolean canFetched(UpPlaceBlockEntity blockEntity, class_1799 handStack) {
        HeatResistantSlateBlockEntity heatResistantSlateBlockEntity;
        boolean moldFetched = blockEntity.method_5442() && (!(blockEntity instanceof HeatResistantSlateBlockEntity) || !(heatResistantSlateBlockEntity = (HeatResistantSlateBlockEntity)blockEntity).isOtherEmpty()) && !blockEntity.isValidItem(handStack);
        return !blockEntity.method_5442() || moldFetched;
    }

    @Override
    public boolean canPlace(UpPlaceBlockEntity blockEntity, class_1799 handStack) {
        if (blockEntity instanceof HeatResistantSlateBlockEntity) {
            MoldContentItem moldContentItem;
            HeatResistantSlateBlockEntity slateEntity = (HeatResistantSlateBlockEntity)blockEntity;
            class_1792 class_17922 = handStack.method_7909();
            if (class_17922 instanceof MoldContentItem && (moldContentItem = (MoldContentItem)class_17922).hasContent(handStack)) {
                return true;
            }
            if (HeatResistantSlateBlockEntity.isCanPlaceMold(handStack)) {
                return true;
            }
            return blockEntity.isValidItem(handStack);
        }
        return false;
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 fromPos, boolean notify) {
        super.method_9612(state, world, pos, sourceBlock, fromPos, notify);
        if (!world.field_9236) {
            MultiBlockHelper.onNeighborUpdate(world, pos, (class_2248)this);
        }
    }

    @Nullable
    public class_2700 getStovePattern(int index) {
        switch (index) {
            case 1: {
                return stove1x1;
            }
            case 2: {
                return stove1x2;
            }
            case 3: {
                return stove2x2;
            }
            case 4: {
                return stove2x3;
            }
        }
        return null;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new HeatResistantSlateBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return world.field_9236 ? null : HeatResistantSlateBlock.method_31618(type, ModBlockEntityTypes.HEAT_RESISTANT_SLATE, HeatResistantSlateBlockEntity::tick);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    static {
        Predicate<class_2694> heatResistantSlatePredicate = cachedBlockPosition -> cachedBlockPosition.method_11681().method_26204() instanceof HeatResistantSlateBlock;
        Predicate<class_2694> firewoodPredicate = cachedBlockPosition -> cachedBlockPosition.method_11681().method_26215() || cachedBlockPosition.method_11681().method_26204() instanceof FirewoodBlock || cachedBlockPosition.method_11681().method_26204() instanceof CombustionFirewoodBlock;
        stove1x1 = class_2697.method_11701().method_11702(new String[]{"?#?", "#|#"}).method_11702(new String[]{"#^#", "#~#"}).method_11702(new String[]{"?#?", "?#?"}).method_11700('^', cachedBlockPosition -> cachedBlockPosition.method_11681().method_26215()).method_11700('#', cachedBlockPosition -> !cachedBlockPosition.method_11681().method_26215()).method_11700('|', heatResistantSlatePredicate).method_11700('~', firewoodPredicate).method_11700('?', cachedBlockPosition -> true).method_11704();
        stove1x2 = class_2697.method_11701().method_11702(new String[]{"?#?", "#|#"}).method_11702(new String[]{"?#?", "#|#"}).method_11702(new String[]{"#^#", "#~#"}).method_11702(new String[]{"?#?", "?#?"}).method_11700('^', cachedBlockPosition -> cachedBlockPosition.method_11681().method_26215()).method_11700('#', cachedBlockPosition -> !cachedBlockPosition.method_11681().method_26215()).method_11700('|', heatResistantSlatePredicate).method_11700('~', firewoodPredicate).method_11700('?', cachedBlockPosition -> true).method_11704();
        stove2x2 = class_2697.method_11701().method_11702(new String[]{"?##?", "#||#"}).method_11702(new String[]{"?##?", "#||#"}).method_11702(new String[]{"#^^#", "#~~#"}).method_11702(new String[]{"?##?", "?##?"}).method_11700('^', cachedBlockPosition -> cachedBlockPosition.method_11681().method_26215()).method_11700('#', cachedBlockPosition -> !cachedBlockPosition.method_11681().method_26215()).method_11700('|', heatResistantSlatePredicate).method_11700('~', firewoodPredicate).method_11700('?', cachedBlockPosition -> true).method_11704();
        stove2x3 = class_2697.method_11701().method_11702(new String[]{"?##?", "#||#"}).method_11702(new String[]{"?##?", "#||#"}).method_11702(new String[]{"?##?", "#||#"}).method_11702(new String[]{"#^^#", "#~~#"}).method_11702(new String[]{"?##?", "?##?"}).method_11700('^', cachedBlockPosition -> cachedBlockPosition.method_11681().method_26215()).method_11700('#', cachedBlockPosition -> !cachedBlockPosition.method_11681().method_26215()).method_11700('|', heatResistantSlatePredicate).method_11700('~', firewoodPredicate).method_11700('?', cachedBlockPosition -> true).method_11704();
    }
}

