/*
 * Decompiled with CFR 0.152.
 */
package org.foodcraft.block;

import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.foodcraft.block.entity.UpPlaceBlockEntity;

public abstract class UpPlaceBlock
extends class_2237 {
    public final UpSounds upSounds;

    public UpPlaceBlock(class_4970.class_2251 settings, UpSounds upSounds) {
        super(settings);
        this.upSounds = upSounds;
    }

    public UpPlaceBlock(class_4970.class_2251 settings) {
        this(settings, UpSounds.DEFAULT);
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!state.method_27852(newState.method_26204())) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof class_1263) {
                class_1263 inventory = (class_1263)blockEntity;
                class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)inventory);
                world.method_8455(pos, (class_2248)this);
            }
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        UpPlaceBlockEntity blockEntity;
        class_2586 entity = world.method_8321(pos);
        if (entity instanceof UpPlaceBlockEntity && !(blockEntity = (UpPlaceBlockEntity)entity).method_5442()) {
            return class_259.method_1084((class_265)this.getBaseShape(state, world, pos, context), (class_265)blockEntity.getContentShape(state, world, pos, context));
        }
        return this.getBaseShape(state, world, pos, context);
    }

    public abstract class_265 getBaseShape(class_2680 var1, class_1922 var2, class_2338 var3, class_3726 var4);

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 handStack = player.method_5998(hand);
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof UpPlaceBlockEntity) {
            UpPlaceBlockEntity upPlaceBlockEntity = (UpPlaceBlockEntity)blockEntity;
            if (this.canFetched(upPlaceBlockEntity, handStack)) {
                if (world.field_9236) {
                    return class_1269.field_5812;
                }
                class_1269 fetchResult = upPlaceBlockEntity.tryFetchItem(player);
                if (upPlaceBlockEntity.isAccepted(fetchResult)) {
                    List<class_1799> fetchStack = upPlaceBlockEntity.getFetchStacks(player, hand, (class_239)hit);
                    upPlaceBlockEntity.onFetch(state, world, pos, player, hand, hit, fetchStack);
                    return fetchResult;
                }
            }
            if (this.canPlace(upPlaceBlockEntity, handStack)) {
                if (world.field_9236) {
                    return class_1269.field_5812;
                }
                class_1269 placeResult = upPlaceBlockEntity.tryAddItem(handStack);
                if (upPlaceBlockEntity.isAccepted(placeResult)) {
                    upPlaceBlockEntity.onPlace(state, world, pos, player, hand, hit, handStack);
                    return placeResult;
                }
            }
        }
        return class_1269.field_5814;
    }

    public abstract boolean canFetched(UpPlaceBlockEntity var1, class_1799 var2);

    public abstract boolean canPlace(UpPlaceBlockEntity var1, class_1799 var2);

    public record UpSounds(class_3414 placeSound, class_3414 fetchSound) {
        public static final UpSounds EMPTY = new UpSounds(null, null);
        public static final UpSounds DEFAULT = new UpSounds(class_3417.field_14574, class_3417.field_15026);

        public void playPlaceSound(class_1937 world, class_2338 pos) {
            if (this.placeSound != null && !world.field_9236) {
                world.method_8396(null, pos, this.placeSound, class_3419.field_15245, 1.0f, 1.0f);
            }
        }

        public void playFetchSound(class_1937 world, class_2338 pos) {
            if (this.fetchSound != null && !world.field_9236) {
                world.method_8396(null, pos, this.fetchSound, class_3419.field_15245, 1.0f, 1.0f);
            }
        }

        public static void playSound(class_1937 world, class_2338 pos, class_3414 sound) {
            world.method_8396(null, pos, sound, class_3419.field_15245, 1.0f, 1.0f);
        }

        public boolean isDefault() {
            return this == DEFAULT;
        }
    }
}

