/*
 * Decompiled with CFR 0.152.
 */
package org.foodcraft.block.entity;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import org.foodcraft.block.CombustionFirewoodBlock;
import org.foodcraft.block.FirewoodBlock;
import org.foodcraft.registry.ModBlockEntityTypes;

public class CombustionFirewoodBlockEntity
extends class_2586 {
    protected int energy;
    protected int cycleCount;
    protected boolean isFirstCycle = true;
    protected int heatLevel = 0;
    static final int MAX_ENERGY = 12000;
    static final int HALF_ENERGY = 6000;
    static final int FIREWOOD_ENERGY = 6000;

    public CombustionFirewoodBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypes.COMBUSTION_FIREWOOD, pos, state);
        if (state.method_11654(CombustionFirewoodBlock.COMBUSTION_STATE) == CombustionFirewoodBlock.CombustionState.FIRST_IGNITED) {
            this.energy = 12000;
            this.isFirstCycle = true;
            this.cycleCount = 0;
        }
        this.updateHeatLevel();
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569("Energy", this.energy);
        nbt.method_10569("CycleCount", this.cycleCount);
        nbt.method_10556("IsFirstCycle", this.isFirstCycle);
        nbt.method_10569("HeatLevel", this.heatLevel);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.energy = nbt.method_10550("Energy");
        this.cycleCount = nbt.method_10550("CycleCount");
        this.isFirstCycle = nbt.method_10577("IsFirstCycle");
        this.heatLevel = nbt.method_10550("HeatLevel");
        if (!nbt.method_10545("HeatLevel")) {
            this.updateHeatLevel();
        }
    }

    public void updateHeatLevel() {
        int oldHeatLevel = this.heatLevel;
        this.heatLevel = this.energy <= 0 ? 0 : (this.energy > 6000 ? 2 : 1);
        if (oldHeatLevel != this.heatLevel) {
            this.method_5431();
        }
    }

    public int getHeatLevel() {
        return this.heatLevel;
    }

    public boolean hasHeat() {
        return this.heatLevel > 0;
    }

    public void updateCombustionState() {
        CombustionFirewoodBlock.CombustionState newState;
        CombustionFirewoodBlock.CombustionState currentState;
        block17: {
            block16: {
                if (this.field_11863 == null || this.field_11863.method_8608()) {
                    return;
                }
                newState = currentState = (CombustionFirewoodBlock.CombustionState)((Object)this.method_11010().method_11654(CombustionFirewoodBlock.COMBUSTION_STATE));
                if (this.energy <= 0) break block16;
                switch (currentState) {
                    case FIRST_IGNITED: {
                        if (this.energy <= 6000) {
                            newState = CombustionFirewoodBlock.CombustionState.FIRST_HALF;
                            break;
                        }
                        break block17;
                    }
                    case FIRST_HALF: {
                        break;
                    }
                    case AGAIN_IGNITED: {
                        if (this.energy <= 6000) {
                            newState = CombustionFirewoodBlock.CombustionState.AGAIN_HALF;
                            break;
                        }
                        break block17;
                    }
                    case AGAIN_HALF: {
                        break;
                    }
                    case REIGNITED: {
                        if (this.energy <= 6000) {
                            newState = CombustionFirewoodBlock.CombustionState.FIRST_HALF;
                            this.isFirstCycle = false;
                            ++this.cycleCount;
                            break;
                        }
                        break block17;
                    }
                }
                break block17;
            }
            switch (currentState) {
                case FIRST_HALF: {
                    newState = CombustionFirewoodBlock.CombustionState.FIRST_EXTINGUISHED;
                    break;
                }
                case AGAIN_HALF: {
                    newState = CombustionFirewoodBlock.CombustionState.AGAIN_EXTINGUISHED;
                    break;
                }
            }
        }
        if (currentState != newState) {
            this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657(CombustionFirewoodBlock.COMBUSTION_STATE, (Comparable)((Object)newState)));
        }
        this.updateHeatLevel();
        this.method_5431();
    }

    public boolean extinguish() {
        if (this.field_11863 == null || this.field_11863.method_8608()) {
            return false;
        }
        class_2680 currentState = this.method_11010();
        CombustionFirewoodBlock.CombustionState currentCombustionState = (CombustionFirewoodBlock.CombustionState)((Object)currentState.method_11654(CombustionFirewoodBlock.COMBUSTION_STATE));
        if (!currentCombustionState.isBurning()) {
            return false;
        }
        CombustionFirewoodBlock.CombustionState extinguishedState = switch (currentCombustionState) {
            case CombustionFirewoodBlock.CombustionState.FIRST_IGNITED, CombustionFirewoodBlock.CombustionState.FIRST_HALF -> CombustionFirewoodBlock.CombustionState.FIRST_EXTINGUISHED;
            case CombustionFirewoodBlock.CombustionState.AGAIN_IGNITED, CombustionFirewoodBlock.CombustionState.AGAIN_HALF, CombustionFirewoodBlock.CombustionState.REIGNITED -> CombustionFirewoodBlock.CombustionState.AGAIN_EXTINGUISHED;
            default -> this.isFirstCycle ? CombustionFirewoodBlock.CombustionState.FIRST_EXTINGUISHED : CombustionFirewoodBlock.CombustionState.AGAIN_EXTINGUISHED;
        };
        this.energy = 0;
        this.field_11863.method_8501(this.field_11867, (class_2680)currentState.method_11657(CombustionFirewoodBlock.COMBUSTION_STATE, (Comparable)((Object)extinguishedState)));
        this.field_11863.method_8396(null, this.field_11867, class_3417.field_15102, class_3419.field_15245, 0.5f, 1.0f);
        this.spawnExtinguishParticles(this.field_11863, this.field_11867);
        this.method_5431();
        return true;
    }

    private void spawnExtinguishParticles(class_1937 world, class_2338 pos) {
        if (world.method_8608()) {
            class_5819 random = world.field_9229;
            for (int i = 0; i < 5; ++i) {
                double x = (double)pos.method_10263() + 0.5 + (random.method_43058() - 0.5) * 0.5;
                double y = (double)pos.method_10264() + 0.3 + random.method_43058() * 0.2;
                double z = (double)pos.method_10260() + 0.5 + (random.method_43058() - 0.5) * 0.5;
                world.method_8406((class_2394)class_2398.field_11251, x, y, z, (random.method_43058() - 0.5) * 0.05, 0.05, (random.method_43058() - 0.5) * 0.05);
            }
        }
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, CombustionFirewoodBlockEntity blockEntity) {
        blockEntity.consumeEnergy();
        blockEntity.checkClearSpaceAbove(world, pos, state);
        if (blockEntity.energy <= 0 && ((CombustionFirewoodBlock.CombustionState)((Object)state.method_11654(CombustionFirewoodBlock.COMBUSTION_STATE))).isBurning()) {
            blockEntity.updateCombustionState();
        }
    }

    private void checkClearSpaceAbove(class_1937 world, class_2338 pos, class_2680 state) {
        if (world.method_8608()) {
            return;
        }
        CombustionFirewoodBlock.CombustionState currentState = (CombustionFirewoodBlock.CombustionState)((Object)state.method_11654(CombustionFirewoodBlock.COMBUSTION_STATE));
        if (!currentState.isBurning()) {
            return;
        }
        if (!FirewoodBlock.hasClearSpaceAbove(world, pos)) {
            this.extinguishDueToObstruction(world, pos);
        }
    }

    private void extinguishDueToObstruction(class_1937 world, class_2338 pos) {
        class_2680 currentState = this.method_11010();
        CombustionFirewoodBlock.CombustionState currentCombustionState = (CombustionFirewoodBlock.CombustionState)((Object)currentState.method_11654(CombustionFirewoodBlock.COMBUSTION_STATE));
        CombustionFirewoodBlock.CombustionState extinguishedState = switch (currentCombustionState) {
            case CombustionFirewoodBlock.CombustionState.FIRST_IGNITED, CombustionFirewoodBlock.CombustionState.FIRST_HALF -> CombustionFirewoodBlock.CombustionState.FIRST_EXTINGUISHED;
            case CombustionFirewoodBlock.CombustionState.AGAIN_IGNITED, CombustionFirewoodBlock.CombustionState.AGAIN_HALF, CombustionFirewoodBlock.CombustionState.REIGNITED -> CombustionFirewoodBlock.CombustionState.AGAIN_EXTINGUISHED;
            default -> this.isFirstCycle ? CombustionFirewoodBlock.CombustionState.FIRST_EXTINGUISHED : CombustionFirewoodBlock.CombustionState.AGAIN_EXTINGUISHED;
        };
        this.energy = 0;
        world.method_8501(pos, (class_2680)currentState.method_11657(CombustionFirewoodBlock.COMBUSTION_STATE, (Comparable)((Object)extinguishedState)));
        world.method_8396(null, pos, class_3417.field_15102, class_3419.field_15245, 0.7f, 0.8f);
        this.spawnObstructionExtinguishParticles(world, pos);
        this.method_5431();
    }

    private void spawnObstructionExtinguishParticles(class_1937 world, class_2338 pos) {
        if (world.method_8608()) {
            class_5819 random = world.field_9229;
            for (int i = 0; i < 10; ++i) {
                double x = (double)pos.method_10263() + 0.5 + (random.method_43058() - 0.5) * 0.8;
                double y = (double)pos.method_10264() + 0.5 + random.method_43058() * 0.5;
                double z = (double)pos.method_10260() + 0.5 + (random.method_43058() - 0.5) * 0.8;
                world.method_8406((class_2394)class_2398.field_11251, x, y, z, (random.method_43058() - 0.5) * 0.1, 0.05 + random.method_43058() * 0.1, (random.method_43058() - 0.5) * 0.1);
            }
        }
    }

    public boolean addFirewood() {
        CombustionFirewoodBlock.CombustionState newState;
        if (this.energy >= 12000 || this.isCompletelyExtinguished()) {
            return false;
        }
        CombustionFirewoodBlock.CombustionState currentState = (CombustionFirewoodBlock.CombustionState)((Object)this.method_11010().method_11654(CombustionFirewoodBlock.COMBUSTION_STATE));
        switch (currentState) {
            case FIRST_IGNITED: 
            case FIRST_HALF: 
            case REIGNITED: 
            case FIRST_EXTINGUISHED: 
            case AGAIN_EXTINGUISHED: {
                newState = CombustionFirewoodBlock.CombustionState.AGAIN_IGNITED;
                break;
            }
            case AGAIN_IGNITED: 
            case AGAIN_HALF: {
                newState = CombustionFirewoodBlock.CombustionState.REIGNITED;
                break;
            }
            default: {
                return false;
            }
        }
        this.addEnergy(6000);
        if (this.field_11863 != null) {
            this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657(CombustionFirewoodBlock.COMBUSTION_STATE, (Comparable)((Object)newState)));
        }
        this.method_5431();
        return true;
    }

    public static boolean hasClearSpaceAbove(class_1937 world, class_2338 pos) {
        for (int i = 1; i <= 6; ++i) {
            class_2338 checkPos = pos.method_10086(i);
            class_2680 state = world.method_8320(checkPos);
            if (state.method_26215()) continue;
            return false;
        }
        return true;
    }

    public boolean canIgnite(class_1937 world, class_2338 pos) {
        return CombustionFirewoodBlockEntity.hasClearSpaceAbove(world, pos);
    }

    public boolean canAddFirewood() {
        return this.energy < 12000 && !this.isCompletelyExtinguished();
    }

    public boolean isCombusting() {
        return this.heatLevel > 0;
    }

    public void addEnergy(int energy) {
        this.energy = Math.min(this.energy + energy, 12000);
        this.updateHeatLevel();
        this.updateCombustionState();
    }

    public boolean consumeEnergy() {
        return this.consumeEnergy(1);
    }

    public boolean consumeEnergy(int amount) {
        if (this.energy <= 0 || amount <= 0) {
            return false;
        }
        int oldEnergy = this.energy;
        this.energy = Math.max(0, this.energy - amount);
        if (oldEnergy != this.energy) {
            this.updateHeatLevel();
            this.updateCombustionState();
            return true;
        }
        return false;
    }

    public void setEnergy(int energy) {
        this.energy = Math.min(energy, 12000);
        this.updateHeatLevel();
        this.updateCombustionState();
    }

    public boolean isEnergyDepleted() {
        return this.energy <= 0;
    }

    public int getCurrentEnergy() {
        return this.energy;
    }

    public float getEnergyConsumptionProgress() {
        return 1.0f - (float)this.energy / 12000.0f;
    }

    public int getEnergy() {
        return this.energy;
    }

    public static int getMaxEnergy() {
        return 12000;
    }

    public int getCycleCount() {
        return this.cycleCount;
    }

    public void setCycleCount(int count) {
        this.cycleCount = count;
        this.method_5431();
    }

    public boolean isFirstCycle() {
        return this.isFirstCycle;
    }

    public void setFirstCycle(boolean firstCycle) {
        this.isFirstCycle = firstCycle;
        this.method_5431();
    }

    public float getEnergyRatio() {
        return (float)this.energy / 12000.0f;
    }

    public boolean isCompletelyExtinguished() {
        CombustionFirewoodBlock.CombustionState currentState = (CombustionFirewoodBlock.CombustionState)((Object)this.method_11010().method_11654(CombustionFirewoodBlock.COMBUSTION_STATE));
        return (currentState == CombustionFirewoodBlock.CombustionState.FIRST_EXTINGUISHED || currentState == CombustionFirewoodBlock.CombustionState.AGAIN_EXTINGUISHED) && this.energy <= 0;
    }

    public int getHalfEnergy() {
        return 6000;
    }
}

