/*
 * Decompiled with CFR 0.152.
 */
package org.foodcraft.block.entity;

import java.util.List;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import org.dfood.block.FoodBlock;
import org.dfood.item.DoubleBlockItem;
import org.dfood.shape.FoodShapeHandle;
import org.foodcraft.block.DishesBlock;
import org.foodcraft.block.entity.UpPlaceBlockEntity;
import org.foodcraft.registry.ModBlockEntityTypes;
import org.foodcraft.util.FoodCraftUtils;

public class DishesBlockEntity
extends UpPlaceBlockEntity {
    private static final int INVENTORY_SIZE = 1;
    private static final int MAX_STACK_SIZE = 11;
    private static final double FOOD_OFFSET_Y = 0.1;

    public DishesBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypes.DISHES, pos, state, 1);
    }

    @Override
    public class_265 getContentShape(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2680 itemState = this.getInventoryBlockState();
        class_2248 class_22482 = itemState.method_26204();
        if (class_22482 instanceof FoodBlock) {
            FoodBlock foodBlock = (FoodBlock)class_22482;
            return FoodShapeHandle.getInstance().getShape(itemState, foodBlock.NUMBER_OF_FOOD).method_1096(0.0, 0.1, 0.0);
        }
        return FoodShapeHandle.shapes.ALL.getShape().method_1096(0.0, 0.1, 0.0);
    }

    @Override
    public boolean isValidItem(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        if (stack.method_7909() == class_1802.field_17534) {
            return true;
        }
        class_1792 item = stack.method_7909();
        if (item instanceof DoubleBlockItem) {
            DoubleBlockItem doubleBlockItem = (DoubleBlockItem)item;
            return doubleBlockItem.getSecondBlock() instanceof FoodBlock;
        }
        if (item instanceof class_1747) {
            class_1747 blockItem = (class_1747)item;
            return blockItem.method_7711() instanceof FoodBlock;
        }
        return false;
    }

    public class_2680 getInventoryBlockState() {
        class_1799 stack = (class_1799)this.inventory.get(0);
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)DishesBlock.FACING);
        return FoodCraftUtils.createCountBlockstate(stack, facing);
    }

    @Override
    public class_1269 tryAddItem(class_1799 stack) {
        if (stack.method_7960() || !this.isValidItem(stack)) {
            return class_1269.field_5814;
        }
        class_1792 item = stack.method_7909();
        class_1799 newStack = stack.method_7972();
        newStack.method_7939(1);
        class_1799 currentStack = this.method_5438(0);
        if (currentStack.method_7960()) {
            this.method_5447(0, newStack);
            this.markDirtyAndSync();
            return class_1269.field_5812;
        }
        if (currentStack.method_7909() == item) {
            FoodBlock block = (FoodBlock)this.getInventoryBlockState().method_26204();
            if (currentStack.method_7947() < block.MAX_FOOD) {
                currentStack.method_7933(1);
                this.markDirtyAndSync();
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5814;
    }

    @Override
    public class_1269 tryFetchItem(class_1657 player) {
        if (!this.method_5442()) {
            class_1799 stack = this.method_5434(0, 1);
            this.fetchStacks = List.of(stack.method_7972());
            if (!player.method_7337() && !player.method_7270(stack)) {
                player.method_7328(stack, false);
            }
            this.markDirtyAndSync();
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    public int method_5444() {
        return 11;
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }
}

