/*
 * Decompiled with CFR 0.152.
 */
package org.foodcraft.block.entity;

import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import org.foodcraft.item.FlourItem;
import org.foodcraft.item.FlourSackItem;
import org.foodcraft.registry.ModBlockEntityTypes;

public class FlourSackBlockEntity
extends class_2586 {
    public static final String ITEMS_KEY = "Items";
    private static final String SACK_COUNT_KEY = "SackCount";
    public static final int MAX_SACK_STACK = 2;
    private static final int ITEMS_PER_SACK = 64;
    public static final int DEFAULT_FLOUR_COLOR = 0xFFFFFF;
    private class_2371<class_1799> sackContents = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
    private int sackCount;

    public FlourSackBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypes.FLOUR_SACK, pos, state);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public void markDirtyAndSync() {
        this.method_5431();
        this.sync();
    }

    public void sync() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    public void readItemNbt(class_2487 nbt) {
        if (nbt.method_10573(ITEMS_KEY, 9)) {
            this.loadItemsFromNbt(nbt.method_10554(ITEMS_KEY, 10));
        }
        if (nbt.method_10545(SACK_COUNT_KEY)) {
            this.sackCount = nbt.method_10550(SACK_COUNT_KEY);
        }
    }

    public void writeItemNbt(class_2487 nbt) {
        class_2499 items = this.createItemsNbtList();
        nbt.method_10566(ITEMS_KEY, (class_2520)items);
        nbt.method_10569(SACK_COUNT_KEY, this.sackCount);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.readItemNbt(nbt);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        this.writeItemNbt(nbt);
    }

    public int getSackCount() {
        return this.sackCount;
    }

    public void setSackCount(int count) {
        int oldCount = this.sackCount;
        this.sackCount = Math.min(Math.max(0, count), 2);
        if (oldCount != this.sackCount) {
            this.markDirtyAndSync();
        }
    }

    public boolean canAddSack(class_1799 newSack) {
        if (this.sackCount >= 2) {
            return false;
        }
        Optional<class_1799> newContent = FlourSackItem.getFirstBundledStack(newSack);
        return this.areContentsCompatible(newContent);
    }

    public boolean addSack(class_1799 newSack) {
        if (!this.canAddSack(newSack)) {
            return false;
        }
        Optional<class_1799> newContent = FlourSackItem.getFirstBundledStack(newSack);
        newContent.ifPresent(stack -> this.sackContents.set(this.sackCount, stack));
        ++this.sackCount;
        this.markDirtyAndSync();
        return true;
    }

    public class_1799 removeSack() {
        if (this.sackCount <= 0) {
            return class_1799.field_8037;
        }
        --this.sackCount;
        class_1799 removedContent = (class_1799)this.sackContents.get(this.sackCount);
        this.sackContents.set(this.sackCount, (Object)class_1799.field_8037);
        this.markDirtyAndSync();
        return this.createSackItem(removedContent);
    }

    public class_1799 getSackContent(int index) {
        if (index >= 0 && index < this.sackContents.size()) {
            return (class_1799)this.sackContents.get(index);
        }
        return class_1799.field_8037;
    }

    public void setSackContent(int index, class_1799 stack) {
        if (index >= 0 && index < this.sackContents.size()) {
            class_1799 oldStack = (class_1799)this.sackContents.get(index);
            this.sackContents.set(index, (Object)stack);
            if (!class_1799.method_7973((class_1799)oldStack, (class_1799)stack)) {
                this.markDirtyAndSync();
            }
        }
    }

    public class_1799 getSackStack(int index) {
        if (!this.isValidSackIndex(index)) {
            return class_1799.field_8037;
        }
        class_1799 content = (class_1799)this.sackContents.get(index);
        return this.createSackItem(content);
    }

    public int getFlourColor(int index) {
        if (!this.isValidSackIndex(index)) {
            return 0xFFFFFF;
        }
        class_1799 content = (class_1799)this.sackContents.get(index);
        return this.getFlourColorFromStack(content);
    }

    public int[] getAllFlourColors() {
        int[] colors = new int[this.sackCount];
        for (int i = 0; i < this.sackCount; ++i) {
            colors[i] = this.getFlourColor(i);
        }
        return colors;
    }

    public class_2371<class_1799> getAllContents() {
        return this.sackContents;
    }

    public int getTotalOccupancy() {
        int total = 0;
        for (int i = 0; i < this.sackCount; ++i) {
            class_1799 content = (class_1799)this.sackContents.get(i);
            if (content.method_7960()) continue;
            total += content.method_7947();
        }
        return total;
    }

    public int getMaxCapacity() {
        return 64 * this.sackCount;
    }

    public boolean isValidSackIndex(int index) {
        return index >= 0 && index < this.sackCount;
    }

    public void forceSync() {
        this.markDirtyAndSync();
    }

    private void loadItemsFromNbt(class_2499 items) {
        this.sackContents = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
        for (int i = 0; i < Math.min(items.size(), 2); ++i) {
            class_2487 itemNbt = items.method_10602(i);
            this.sackContents.set(i, (Object)class_1799.method_7915((class_2487)itemNbt));
        }
    }

    private class_2499 createItemsNbtList() {
        class_2499 items = new class_2499();
        for (int i = 0; i < this.sackCount; ++i) {
            class_1799 stack = (class_1799)this.sackContents.get(i);
            if (stack.method_7960()) continue;
            class_2487 itemNbt = new class_2487();
            stack.method_7953(itemNbt);
            items.add((Object)itemNbt);
        }
        return items;
    }

    private boolean areContentsCompatible(Optional<class_1799> newContent) {
        for (int i = 0; i < this.sackCount; ++i) {
            class_1799 existingContent = (class_1799)this.sackContents.get(i);
            if (!newContent.isPresent() || existingContent.method_7960() || class_1799.method_7984((class_1799)newContent.get(), (class_1799)existingContent)) continue;
            return false;
        }
        return true;
    }

    public class_1799 createSackItem(class_1799 content) {
        class_1799 sackItem = new class_1799((class_1935)this.method_11010().method_26204().method_8389());
        if (!content.method_7960()) {
            class_2487 nbt = new class_2487();
            class_2499 items = new class_2499();
            class_2487 itemNbt = new class_2487();
            content.method_7953(itemNbt);
            items.add((Object)itemNbt);
            nbt.method_10566(ITEMS_KEY, (class_2520)items);
            sackItem.method_7980(nbt);
        }
        return sackItem;
    }

    private int getFlourColorFromStack(class_1799 stack) {
        if (stack.method_7960()) {
            return 0xFFFFFF;
        }
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof FlourItem) {
            FlourItem flourItem = (FlourItem)class_17922;
            return flourItem.getColor();
        }
        return 0xFFFFFF;
    }
}

