/*
 * Decompiled with CFR 0.152.
 */
package org.foodcraft.block.entity;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1662;
import net.minecraft.class_1732;
import net.minecraft.class_1737;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.foodcraft.recipe.GrindingRecipe;
import org.foodcraft.registry.ModBlockEntityTypes;
import org.foodcraft.registry.ModRecipeTypes;
import org.foodcraft.util.ModAnimationState;
import org.jetbrains.annotations.Nullable;

public class GrindingStoneBlockEntity
extends class_2586
implements class_1278,
class_1732,
class_1737 {
    protected static final int INPUT_SLOT_INDEX = 0;
    protected static final int OUTPUT_SLOT_INDEX = 1;
    public static final int DEFAULT_GRIND_TIME = 200;
    private static final int MIN_ENERGY_ADD_INTERVAL = 10;
    protected class_2371<class_1799> inventory = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
    private int lastEnergyAddTime = 0;
    int energy;
    static final int MAX_ENERGY = 1000;
    int grindingTime;
    int grindingTimeTotal;
    public final ModAnimationState grindingAnimationState = new ModAnimationState();
    protected int age;
    private final Object2IntOpenHashMap<class_2960> recipesUsed = new Object2IntOpenHashMap();
    private final class_1863.class_7266<class_1263, ? extends GrindingRecipe> matchGetter = class_1863.method_42302(ModRecipeTypes.GRINDING);
    @Nullable
    private class_1860<?> lastRecipe;

    public GrindingStoneBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypes.GRINDING_STONE, pos, state);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.energy = nbt.method_10550("Energy");
        this.grindingTime = nbt.method_10550("GrindingTime");
        this.grindingTimeTotal = nbt.method_10550("GrindingTimeTotal");
        this.age = nbt.method_10550("Age");
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569("Energy", this.energy);
        nbt.method_10569("GrindingTime", this.grindingTime);
        nbt.method_10569("GrindingTimeTotal", this.grindingTimeTotal);
        nbt.method_10569("Age", this.age);
    }

    public int[] method_5494(class_2350 side) {
        return new int[]{0, 1};
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return slot == 0;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot == 1;
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public boolean method_5442() {
        for (class_1799 stack : this.inventory) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        return class_1262.method_5430(this.inventory, (int)slot, (int)amount);
    }

    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this.inventory, (int)slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        if (slot == 0 && !class_1799.method_7973((class_1799)stack, (class_1799)((class_1799)this.inventory.get(slot)))) {
            this.resetGrindingProgress();
        }
        this.inventory.set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
    }

    public int method_5444() {
        return 64;
    }

    public class_1792 getExpectedOutput() {
        GrindingRecipe recipe = this.matchGetter.method_42303((class_1263)this, this.field_11863).orElse(null);
        if (recipe != null) {
            return recipe.method_8110(null).method_7909();
        }
        return class_1799.field_8037.method_7909();
    }

    @Nullable
    public GrindingRecipe getCurrentRecipe() {
        class_1799 inputStack = (class_1799)this.inventory.get(0);
        if (inputStack.method_7960()) {
            return null;
        }
        class_1277 tempInventory = new class_1277(new class_1799[]{inputStack});
        return this.matchGetter.method_42303((class_1263)tempInventory, this.field_11863).orElse(null);
    }

    private boolean isValidGrindingInput(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        class_1277 tempInventory = new class_1277(new class_1799[]{stack});
        return this.matchGetter.method_42303((class_1263)tempInventory, this.field_11863).isPresent();
    }

    public boolean canGrindCurrentInput() {
        GrindingRecipe recipe = this.getCurrentRecipe();
        if (recipe == null) {
            return false;
        }
        class_1799 inputStack = (class_1799)this.inventory.get(0);
        return inputStack.method_7947() >= recipe.getInputCount();
    }

    public AddInputResult addInput(class_1799 stack, class_1657 player) {
        class_1277 tempInventory;
        GrindingRecipe recipe;
        if (!this.isValidGrindingInput(stack)) {
            return AddInputResult.INVALID;
        }
        class_1799 inputSlot = (class_1799)this.inventory.get(0);
        if (!inputSlot.method_7960() && !class_1799.method_7984((class_1799)inputSlot, (class_1799)stack)) {
            this.returnItemToPlayer(inputSlot, player);
            this.method_5447(0, class_1799.field_8037);
            inputSlot = class_1799.field_8037;
        }
        if ((recipe = (GrindingRecipe)this.matchGetter.method_42303((class_1263)(tempInventory = new class_1277(new class_1799[]{stack})), this.field_11863).orElse(null)) == null) {
            return AddInputResult.INVALID;
        }
        int requiredCount = recipe.getInputCount();
        int playerStackCount = stack.method_7947();
        if (inputSlot.method_7960()) {
            int amountToAdd = Math.min(requiredCount, playerStackCount);
            if (amountToAdd < requiredCount) {
                return AddInputResult.NOT_ENOUGH;
            }
            class_1799 newInput = stack.method_7972();
            newInput.method_7939(amountToAdd);
            this.method_5447(0, newInput);
            if (!player.method_7337()) {
                stack.method_7934(amountToAdd);
            }
            return AddInputResult.SUCCESS;
        }
        if (class_1799.method_7984((class_1799)inputSlot, (class_1799)stack)) {
            int neededToComplete;
            int currentCount = inputSlot.method_7947();
            int remainder = currentCount % requiredCount;
            int n = neededToComplete = remainder == 0 ? 0 : requiredCount - remainder;
            if (neededToComplete == 0) {
                int maxAddable = this.method_5444() - currentCount;
                int amountToAdd = Math.min(requiredCount, Math.min(maxAddable, playerStackCount));
                if (amountToAdd > 0) {
                    inputSlot.method_7933(amountToAdd);
                    this.method_5447(0, inputSlot);
                    if (!player.method_7337()) {
                        stack.method_7934(amountToAdd);
                    }
                    return AddInputResult.SUCCESS;
                }
                return AddInputResult.FULL;
            }
            if (playerStackCount >= neededToComplete) {
                inputSlot.method_7933(neededToComplete);
                this.method_5447(0, inputSlot);
                if (!player.method_7337()) {
                    stack.method_7934(neededToComplete);
                }
                return AddInputResult.SUCCESS;
            }
            return AddInputResult.NOT_ENOUGH;
        }
        return AddInputResult.INVALID;
    }

    private void returnItemToPlayer(class_1799 stack, class_1657 player) {
        if (stack.method_7960()) {
            return;
        }
        if (!player.method_31548().method_7394(stack.method_7972())) {
            class_1542 itemEntity = new class_1542(this.field_11863, player.method_23317(), player.method_23318(), player.method_23321(), stack.method_7972());
            this.field_11863.method_8649((class_1297)itemEntity);
        }
        this.method_5447(0, class_1799.field_8037);
    }

    public void returnInputToPlayer(class_1657 player) {
        class_1799 inputStack = (class_1799)this.inventory.get(0);
        if (!inputStack.method_7960()) {
            this.returnItemToPlayer(inputStack, player);
        }
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void method_5448() {
        this.inventory.clear();
    }

    public void method_7683(class_1662 finder) {
        for (class_1799 stack : this.inventory) {
            finder.method_7400(stack);
        }
    }

    public void method_7662(@Nullable class_1860<?> recipe) {
        this.lastRecipe = recipe;
    }

    @Nullable
    public class_1860<?> method_7663() {
        return this.lastRecipe;
    }

    public void resetGrindingProgress() {
        this.grindingTime = 0;
        this.grindingTimeTotal = 0;
        this.method_5431();
    }

    public int calculateRequiredEnergy() {
        int inputCount = ((class_1799)this.inventory.get(0)).method_7947();
        if (inputCount == 0) {
            return 0;
        }
        GrindingRecipe recipe = this.getCurrentRecipe();
        if (recipe == null) {
            return 0;
        }
        int grindingTimeForRecipe = recipe.getGrindingTime();
        int requiredCount = recipe.getInputCount();
        int grindTimes = inputCount / requiredCount;
        if (grindTimes == 0) {
            return 0;
        }
        int remainingEnergyForCurrent = Math.max(0, grindingTimeForRecipe - this.grindingTime);
        int energyForRemainingItems = (grindTimes - 1) * grindingTimeForRecipe;
        return remainingEnergyForCurrent + energyForRemainingItems;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, GrindingStoneBlockEntity blockEntity) {
        class_1799 outputStack;
        ++blockEntity.age;
        if (blockEntity.age == Integer.MAX_VALUE) {
            blockEntity.age = 0;
        }
        if (blockEntity.energy > 0 && blockEntity.canGrind()) {
            GrindingRecipe recipe;
            if (blockEntity.grindingTime == 0 && (recipe = blockEntity.getCurrentRecipe()) != null) {
                blockEntity.grindingTimeTotal = recipe.getGrindingTime();
            }
            --blockEntity.energy;
            ++blockEntity.grindingTime;
            if (blockEntity.grindingTime >= blockEntity.grindingTimeTotal) {
                blockEntity.resetGrindingProgress();
                blockEntity.grindItem();
            }
        }
        if (!world.field_9236 && blockEntity.age % 10 == 0 && !(outputStack = blockEntity.method_5438(1)).method_7960()) {
            blockEntity.ejectOutputItem(world, pos);
        }
        blockEntity.method_5431();
        blockEntity.sync();
    }

    private void ejectOutputItem(class_1937 world, class_2338 pos) {
        class_1799 outputStack = this.method_5438(1);
        if (outputStack.method_7960()) {
            return;
        }
        double x = (double)pos.method_10263() + 0.5;
        double y = (double)pos.method_10264() + 1.0;
        double z = (double)pos.method_10260() + 0.5;
        class_1542 itemEntity = new class_1542(world, x, y, z, outputStack.method_7972());
        itemEntity.method_18800(0.0, 0.3, 0.0);
        itemEntity.method_6982(10);
        world.method_8649((class_1297)itemEntity);
        this.method_5447(1, class_1799.field_8037);
        this.method_5431();
    }

    private boolean canGrind() {
        class_1799 inputStack = (class_1799)this.inventory.get(0);
        if (inputStack.method_7960()) {
            return false;
        }
        GrindingRecipe recipe = this.getCurrentRecipe();
        if (recipe == null) {
            return false;
        }
        if (inputStack.method_7947() < recipe.getInputCount()) {
            return false;
        }
        class_1799 output = recipe.method_8110(null);
        if (output.method_7960()) {
            return false;
        }
        class_1799 outputSlot = (class_1799)this.inventory.get(1);
        if (outputSlot.method_7960()) {
            return true;
        }
        if (!class_1799.method_7984((class_1799)outputSlot, (class_1799)output)) {
            return false;
        }
        int resultCount = outputSlot.method_7947() + output.method_7947();
        return resultCount <= this.method_5444() && resultCount <= outputSlot.method_7914();
    }

    private void grindItem() {
        GrindingRecipe recipe = this.getCurrentRecipe();
        if (recipe != null && this.canGrind()) {
            class_1799 input = (class_1799)this.inventory.get(0);
            class_1799 output = recipe.method_8116((class_1263)this, null);
            class_1799 outputSlot = (class_1799)this.inventory.get(1);
            int requiredCount = recipe.getInputCount();
            if (outputSlot.method_7960()) {
                this.inventory.set(1, (Object)output);
            } else if (class_1799.method_7984((class_1799)outputSlot, (class_1799)output)) {
                outputSlot.method_7933(output.method_7947());
            }
            input.method_7934(requiredCount);
            this.method_7662(recipe);
            this.recipesUsed.addTo((Object)recipe.method_8114(), 1);
        }
    }

    public boolean isGrinding() {
        return this.grindingTime > 0 && this.energy > 0;
    }

    public int getGrindingTimeTotal() {
        return this.grindingTimeTotal;
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getMaxEnergy() {
        return 1000;
    }

    public void setEnergy(int energy) {
        this.energy = Math.min(energy, 1000);
        this.method_5431();
    }

    public boolean tryAddEnergy(int amount) {
        if (this.age - this.lastEnergyAddTime < 10) {
            return false;
        }
        int requiredEnergy = this.calculateRequiredEnergy();
        if (this.getEnergy() >= requiredEnergy) {
            return false;
        }
        int energyToAdd = Math.min(amount, requiredEnergy - this.getEnergy());
        this.addEnergy(energyToAdd);
        this.lastEnergyAddTime = this.age;
        return true;
    }

    public void addEnergy(int energy) {
        this.energy = Math.min(this.energy + energy, 1000);
        this.method_5431();
    }

    public void consumeEnergy(int energy) {
        this.energy = Math.max(0, this.energy - energy);
        this.method_5431();
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public int getAge() {
        return this.age;
    }

    public boolean canPlaySound() {
        return this.energy >= 20;
    }

    public void sync() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    public float getGrindingProgress() {
        if (this.grindingTimeTotal != 0) {
            return (float)this.grindingTime / (float)this.grindingTimeTotal * 100.0f;
        }
        return 0.0f;
    }

    public class_2371<class_1799> getItemsToDrop() {
        class_2371 drops = class_2371.method_10211();
        for (class_1799 stack : this.inventory) {
            if (stack.method_7960()) continue;
            drops.add((Object)stack.method_7972());
        }
        return drops;
    }

    public static enum AddInputResult {
        SUCCESS,
        FULL,
        INVALID,
        NOT_ENOUGH;

    }
}

