/*
 * Decompiled with CFR 0.152.
 */
package org.foodcraft.block.entity;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1662;
import net.minecraft.class_1732;
import net.minecraft.class_1737;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2694;
import net.minecraft.class_2700;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import org.dfood.block.FoodBlock;
import org.dfood.shape.FoodShapeHandle;
import org.foodcraft.FoodCraft;
import org.foodcraft.block.CombustionFirewoodBlock;
import org.foodcraft.block.FirewoodBlock;
import org.foodcraft.block.HeatResistantSlateBlock;
import org.foodcraft.block.MoldBlock;
import org.foodcraft.block.entity.CombustionFirewoodBlockEntity;
import org.foodcraft.block.entity.UpPlaceBlockEntity;
import org.foodcraft.block.multi.ClientMultiBlockReference;
import org.foodcraft.block.multi.MultiBlock;
import org.foodcraft.block.multi.MultiBlockReference;
import org.foodcraft.block.multi.ServerMultiBlockReference;
import org.foodcraft.item.MoldContentItem;
import org.foodcraft.recipe.MoldRecipe;
import org.foodcraft.recipe.StoveRecipe;
import org.foodcraft.registry.ModBlockEntityTypes;
import org.foodcraft.registry.ModRecipeTypes;
import org.foodcraft.util.FoodCraftUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class HeatResistantSlateBlockEntity
extends UpPlaceBlockEntity
implements class_1278,
class_1732,
class_1737 {
    protected static final int MIN_CHECK_INTERVAL = 10;
    protected static final String MULTIBLOCK_REF_KEY = "MultiBlockRef";
    protected static final double INPUT_OFFSET_Y = 0.1;
    protected static final int MIN_BAKING_TIME = 100;
    protected static final Logger LOGGER = FoodCraft.LOGGER;
    protected MultiBlockReference multiBlockRef;
    @Nullable
    protected class_2700.class_2702 currentStoveResult;
    @Nullable
    protected class_2350 resultDirection;
    protected int stoveStructureType = -1;
    protected boolean isValidStove = false;
    protected class_2487 refNbt;
    protected Set<class_2338> firewoodPos = new HashSet<class_2338>();
    protected Set<CombustionFirewoodBlockEntity> firewoodEntities = new HashSet<CombustionFirewoodBlockEntity>();
    protected int bakingTime = 0;
    protected int bakingTimeTotal = 0;
    protected class_2371<class_1799> otherStack = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    public class_1799 originalInputStack = class_1799.field_8037;
    protected final Object2IntOpenHashMap<class_2960> recipesUsed = new Object2IntOpenHashMap();
    protected final class_1863.class_7266<class_1263, ? extends StoveRecipe> matchGetter = class_1863.method_42302(ModRecipeTypes.STOVE);
    @Nullable
    protected class_1860<?> lastRecipe;
    public int age;
    protected int lastCheckTime = 0;

    public HeatResistantSlateBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypes.HEAT_RESISTANT_SLATE, pos, state, 1);
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        if (this.multiBlockRef != null && !this.multiBlockRef.isDisposed()) {
            nbt.method_10566(MULTIBLOCK_REF_KEY, (class_2520)this.multiBlockRef.toNbt());
        }
        nbt.method_10556("IsStoveValid", this.isValidStove);
        nbt.method_10569("StoveStructureType", this.stoveStructureType);
        if (!this.firewoodPos.isEmpty()) {
            class_2499 firewoodList = new class_2499();
            for (class_2338 pos : this.firewoodPos) {
                firewoodList.add((Object)FoodCraftUtils.serializeBlockPos(pos));
            }
            nbt.method_10566("FirewoodPositions", (class_2520)firewoodList);
        }
        if (this.resultDirection != null) {
            nbt.method_10582("resultDirection", this.resultDirection.method_15434());
        }
        this.writeOtherStackNbt(nbt, this.otherStack, true);
        nbt.method_10566("OriginalInputStack", (class_2520)this.originalInputStack.method_7953(new class_2487()));
        nbt.method_10569("BakingTime", this.bakingTime);
        nbt.method_10569("BakingTimeTotal", this.bakingTimeTotal);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10545(MULTIBLOCK_REF_KEY)) {
            this.refNbt = nbt.method_10562(MULTIBLOCK_REF_KEY);
        }
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            ServerMultiBlockReference ref;
            if (this.refNbt != null && (ref = ServerMultiBlockReference.fromNbt((class_4538)this.field_11863, this.refNbt)) != null) {
                this.multiBlockRef = ref;
            }
        } else if (this.refNbt != null) {
            this.multiBlockRef = new ClientMultiBlockReference(this.refNbt);
        }
        this.isValidStove = nbt.method_10577("IsStoveValid");
        this.stoveStructureType = nbt.method_10550("StoveStructureType");
        this.firewoodPos.clear();
        if (nbt.method_10545("FirewoodPositions")) {
            class_2499 firewoodList = nbt.method_10554("FirewoodPositions", 10);
            for (int i = 0; i < firewoodList.size(); ++i) {
                class_2487 posTag = firewoodList.method_10602(i);
                class_2338 pos = FoodCraftUtils.deserializeBlockPos(posTag);
                if (pos == null) continue;
                this.firewoodPos.add(pos);
            }
        }
        if (nbt.method_10545("resultDirection")) {
            this.resultDirection = class_2350.method_10168((String)nbt.method_10558("resultDirection"));
        }
        this.readOtherStackNbt(nbt, this.otherStack);
        if (nbt.method_10545("OriginalInputStack")) {
            this.originalInputStack = class_1799.method_7915((class_2487)nbt.method_10562("OriginalInputStack"));
        }
        this.bakingTime = nbt.method_10550("BakingTime");
        this.bakingTimeTotal = nbt.method_10550("BakingTimeTotal");
    }

    private void writeOtherStackNbt(class_2487 nbt, class_2371<class_1799> stacks, boolean setIfEmpty) {
        class_2499 nbtList = new class_2499();
        for (int i = 0; i < stacks.size(); ++i) {
            class_1799 itemStack = (class_1799)stacks.get(i);
            if (itemStack.method_7960()) continue;
            class_2487 nbtCompound = new class_2487();
            nbtCompound.method_10567("OtherSlot", (byte)i);
            itemStack.method_7953(nbtCompound);
            nbtList.add((Object)nbtCompound);
        }
        if (!nbtList.isEmpty() || setIfEmpty) {
            nbt.method_10566("OtherItems", (class_2520)nbtList);
        }
    }

    private void readOtherStackNbt(class_2487 nbt, class_2371<class_1799> stacks) {
        class_2499 nbtList = nbt.method_10554("OtherItems", 10);
        if (!nbt.method_10573("OtherItems", 9) || nbtList.isEmpty()) {
            stacks.clear();
            return;
        }
        for (int i = 0; i < nbtList.size(); ++i) {
            class_2487 nbtCompound = nbtList.method_10602(i);
            int j = nbtCompound.method_10571("OtherSlot") & 0xFF;
            if (j >= stacks.size()) continue;
            stacks.set(j, (Object)class_1799.method_7915((class_2487)nbtCompound));
        }
    }

    @Override
    public class_265 getContentShape(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_265 itemShape = this.getBlockShape(this.getInventoryBlockState(), world, pos);
        class_265 otherShape = this.getBlockShape(this.getOtherBlockState(), world, pos);
        if (!otherShape.method_1110()) {
            itemShape.method_1096(0.0, 0.1, 0.0);
        }
        return class_259.method_1084((class_265)itemShape, (class_265)otherShape);
    }

    private class_265 getBlockShape(class_2680 blockState, class_1922 world, class_2338 pos) {
        class_265 shape;
        class_2248 block = blockState.method_26204();
        if (block == class_2246.field_10124) {
            return class_259.method_1073();
        }
        if (block instanceof FoodBlock) {
            FoodBlock foodBlock = (FoodBlock)block;
            shape = FoodShapeHandle.getInstance().getShape(blockState, foodBlock.NUMBER_OF_FOOD);
        } else {
            shape = block.method_9564().method_26218(world, pos);
        }
        return shape.method_1096(0.0, 0.1, 0.0);
    }

    @Override
    public boolean isValidItem(class_1799 stack) {
        class_1799 moldStack = (class_1799)this.otherStack.get(0);
        if (!moldStack.method_7960()) {
            return this.tryMoldItemWithMold(stack, moldStack) != class_1799.field_8037;
        }
        return this.isValidGrindingInput(stack);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isCanPlaceMold(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof class_1747)) return false;
        class_1747 blockItem = (class_1747)class_17922;
        if (!((class_17922 = blockItem.method_7711()) instanceof MoldBlock)) return false;
        MoldBlock moldBlock = (MoldBlock)class_17922;
        if (!moldBlock.canPlaceSlate) return false;
        return true;
    }

    @Override
    public class_1269 tryAddItem(class_1799 stack) {
        class_1269 result;
        if (stack.method_7909() instanceof MoldContentItem && ((MoldContentItem)stack.method_7909()).hasContent(stack) && (result = this.handleFilledMoldPlacement(stack)).method_23665()) {
            return result;
        }
        if (HeatResistantSlateBlockEntity.isCanPlaceMold(stack) && this.tryPlaceMold(stack)) {
            return class_1269.field_5812;
        }
        if (stack.method_7960() || !this.isValidItem(stack)) {
            return class_1269.field_5814;
        }
        class_1799 newStack = stack.method_7972();
        newStack.method_7939(1);
        class_1799 moldStack = (class_1799)this.otherStack.get(0);
        if (!moldStack.method_7960()) {
            class_1799 moldedItem = this.tryMoldItemWithMold(newStack, moldStack);
            if (!moldedItem.method_7960()) {
                this.method_5447(0, moldedItem);
                this.originalInputStack = newStack.method_7972();
                this.markDirtyAndSync();
                return class_1269.field_5812;
            }
            return class_1269.field_5814;
        }
        if (this.method_5442() && this.isValidGrindingInput(newStack)) {
            this.method_5447(0, newStack);
            this.markDirtyAndSync();
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    @Override
    public class_1269 tryFetchItem(class_1657 player) {
        class_1799 contentStack = this.method_5438(0);
        if (!(contentStack.method_7960() || this.originalInputStack.method_7960() || this.isOtherEmpty())) {
            return this.fetchMoldedItem(player);
        }
        if (contentStack.method_7960()) {
            boolean result = this.tyeFetchMold(player);
            if (result) {
                if (!this.originalInputStack.method_7960()) {
                    this.method_5447(0, this.originalInputStack.method_7972());
                    this.originalInputStack = class_1799.field_8037;
                }
                return class_1269.field_5812;
            }
            return class_1269.field_5814;
        }
        if (!player.method_7337() && !player.method_7270(contentStack)) {
            player.method_7328(contentStack, false);
        }
        this.fetchStacks = List.of(contentStack.method_7972());
        this.method_5447(0, class_1799.field_8037);
        this.originalInputStack = class_1799.field_8037;
        this.markDirtyAndSync();
        return class_1269.field_5812;
    }

    private class_1269 handleFilledMoldPlacement(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof MoldContentItem)) {
            return class_1269.field_5814;
        }
        MoldContentItem moldContentItem = (MoldContentItem)class_17922;
        if (!this.method_5442() || !this.isOtherEmpty()) {
            return class_1269.field_5814;
        }
        class_1799 contentStack = moldContentItem.getContentStack(stack);
        if (contentStack.method_7960()) {
            return class_1269.field_5814;
        }
        MoldRecipe recipe = this.findMatchingMoldRecipe(contentStack);
        if (recipe == null) {
            return class_1269.field_5814;
        }
        class_1799 moldedOutput = recipe.method_8110(this.field_11863 != null ? this.field_11863.method_30349() : null);
        if (moldedOutput.method_7960()) {
            return class_1269.field_5814;
        }
        this.method_5447(0, moldedOutput.method_7972());
        this.otherStack.set(0, (Object)new class_1799((class_1935)recipe.getBaseMoldItem()));
        this.originalInputStack = contentStack.method_7972();
        this.markDirtyAndSync();
        return class_1269.field_5812;
    }

    private MoldRecipe findMatchingMoldRecipe(class_1799 inputStack) {
        if (this.field_11863 == null) {
            return null;
        }
        class_1277 tempInventory = new class_1277(new class_1799[]{inputStack});
        return this.field_11863.method_8433().method_8132(ModRecipeTypes.MOLD, (class_1263)tempInventory, this.field_11863).orElse(null);
    }

    private class_1799 tryMoldItemWithMold(class_1799 input, class_1799 moldStack) {
        if (this.field_11863 == null) {
            return class_1799.field_8037;
        }
        MoldRecipe recipe = this.findMatchingMoldRecipe(input);
        if (recipe == null) {
            return class_1799.field_8037;
        }
        if (!class_1799.method_7984((class_1799)moldStack, (class_1799)new class_1799((class_1935)recipe.getBaseMoldItem()))) {
            return class_1799.field_8037;
        }
        return recipe.method_8110(this.field_11863.method_30349());
    }

    private class_1269 fetchMoldedItem(class_1657 player) {
        if (!player.method_7270(this.originalInputStack.method_7972())) {
            player.method_7328(this.originalInputStack.method_7972(), false);
        }
        class_1799 moldStack = ((class_1799)this.otherStack.get(0)).method_7972();
        if (!player.method_7337() && !player.method_7270(moldStack)) {
            player.method_7328(moldStack, false);
        }
        this.fetchStacks = List.of(this.originalInputStack.method_7972(), moldStack.method_7972());
        this.method_5447(0, class_1799.field_8037);
        this.otherStack.set(0, (Object)class_1799.field_8037);
        this.originalInputStack = class_1799.field_8037;
        this.markDirtyAndSync();
        return class_1269.field_5812;
    }

    public class_2680 getInventoryBlockState() {
        class_1799 stack = (class_1799)this.inventory.get(0);
        class_2350 facing = class_2350.field_11034;
        if (this.resultDirection != null) {
            facing = this.resultDirection;
        }
        return FoodCraftUtils.createCountBlockstate(stack, facing);
    }

    public class_2680 getOtherBlockState() {
        class_1799 stack = (class_1799)this.otherStack.get(0);
        class_2350 facing = class_2350.field_11034;
        if (this.resultDirection != null) {
            facing = this.resultDirection;
        }
        return FoodCraftUtils.createCountBlockstate(stack, facing);
    }

    public boolean tryPlaceMold(class_1799 stack) {
        class_1799 moldStack;
        if (HeatResistantSlateBlockEntity.isCanPlaceMold(stack) && (moldStack = (class_1799)this.otherStack.get(0)).method_7960()) {
            class_1799 newStack = stack.method_7972();
            newStack.method_7939(1);
            this.otherStack.set(0, (Object)newStack);
            this.markDirtyAndSync();
            return true;
        }
        return false;
    }

    public boolean tyeFetchMold(class_1657 player) {
        for (int i = 0; i < this.otherStack.size(); ++i) {
            class_1799 stack = (class_1799)this.otherStack.get(i);
            if (stack.method_7960()) continue;
            if (!player.method_7337() && !player.method_7270(stack)) {
                player.method_7328(stack, false);
            }
            this.fetchStacks = List.of(stack.method_7972());
            this.otherStack.set(i, (Object)class_1799.field_8037);
            this.markDirtyAndSync();
            return true;
        }
        return false;
    }

    public void setMultiBlockReference(@Nullable MultiBlockReference ref) {
        if (this.field_11863 != null && (this.field_11863.field_9236 || ref instanceof ClientMultiBlockReference)) {
            return;
        }
        if (this.multiBlockRef != null) {
            this.multiBlockRef.dispose();
        }
        this.multiBlockRef = ref;
        this.currentStoveResult = null;
        this.stoveStructureType = -1;
        this.isValidStove = false;
        this.method_5431();
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    @Nullable
    public MultiBlockReference getMultiBlockReference() {
        return this.multiBlockRef;
    }

    public boolean isMasterBlock() {
        return this.multiBlockRef != null && this.multiBlockRef.isMasterBlock();
    }

    public void method_11012() {
        super.method_11012();
        if (this.multiBlockRef != null) {
            this.multiBlockRef.dispose();
            this.multiBlockRef = null;
        }
    }

    public boolean isValidStoveStructure() {
        if (this.multiBlockRef == null || this.multiBlockRef.isDisposed()) {
            return false;
        }
        MultiBlockReference multiBlockReference = this.multiBlockRef;
        if (multiBlockReference instanceof ServerMultiBlockReference) {
            ServerMultiBlockReference multiBlockReference2 = (ServerMultiBlockReference)multiBlockReference;
            MultiBlock.PatternRange range = multiBlockReference2.getMultiBlock().getRange();
            int width = range.getWidth();
            int height = range.getHeight();
            int depth = range.getDepth();
            if (height != 1) {
                return false;
            }
            return width == 1 && depth == 1 || width == 1 && depth == 2 || width == 2 && depth == 1 || width == 2 && depth == 2 || width == 3 && depth == 2 || width == 2 && depth == 3;
        }
        return false;
    }

    public int getStoveStructureType() {
        if (!this.isValidStoveStructure()) {
            return -1;
        }
        MultiBlockReference multiBlockReference = this.multiBlockRef;
        if (multiBlockReference instanceof ServerMultiBlockReference) {
            ServerMultiBlockReference multiBlockReference2 = (ServerMultiBlockReference)multiBlockReference;
            MultiBlock.PatternRange range = multiBlockReference2.getMultiBlock().getRange();
            int width = range.getWidth();
            int depth = range.getDepth();
            if (width == 1 && depth == 1) {
                return 1;
            }
            if (width == 2 && depth == 1) {
                return 2;
            }
            if (width == 1 && depth == 2) {
                return 2;
            }
            if (width == 2 && depth == 2) {
                return 3;
            }
            if (width == 3 && depth == 2) {
                return 4;
            }
            if (width == 2 && depth == 3) {
                return 4;
            }
        }
        return -1;
    }

    @Nullable
    public class_2700 getStovePattern(int index) {
        class_2248 class_22482 = this.method_11010().method_26204();
        if (class_22482 instanceof HeatResistantSlateBlock) {
            HeatResistantSlateBlock heatResistantSlateBlock = (HeatResistantSlateBlock)class_22482;
            return heatResistantSlateBlock.getStovePattern(index);
        }
        return null;
    }

    @Nullable
    public class_2700.class_2702 getCurrentStoveResult() {
        return this.currentStoveResult;
    }

    public int getCurrentStoveStructureType() {
        return this.stoveStructureType;
    }

    public boolean isStoveValid() {
        return this.isValidStove;
    }

    private void onStoveStructureValid(class_1937 world, class_2338 pos, class_2700.class_2702 result, int patternType) {
        this.bindFirewoodFromStructure(world, result, patternType);
        if (this.currentStoveResult != null) {
            this.resultDirection = this.currentStoveResult.method_11719();
        }
    }

    private void onStoveStructureInvalid(class_1937 world, class_2338 pos) {
        this.clearFirewoodBinding();
        if (this.currentStoveResult == null) {
            this.resultDirection = null;
        }
    }

    private class_2700.class_2702 searchAround(class_1937 world, class_2338 searchPos, int patternType, class_2700 pattern) {
        for (int i = 0; i < patternType + 2; ++i) {
            List<class_2338> params = Arrays.asList(searchPos.method_10079(class_2350.field_11034, i), searchPos.method_10079(class_2350.field_11039, i), searchPos.method_10079(class_2350.field_11043, i), searchPos.method_10079(class_2350.field_11035, i));
            for (class_2338 pos : params) {
                class_2700.class_2702 result = pattern.method_11708((class_4538)world, pos);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private void bindFirewoodFromStructure(class_1937 world, class_2700.class_2702 result, int patternType) {
        Set<class_2338> newFirewoodPositions = FoodCraftUtils.findTargetPositionsFromPattern(result, HeatResistantSlateBlockEntity::isFirewoodPositionPredicate);
        if (!newFirewoodPositions.isEmpty()) {
            this.firewoodPos = newFirewoodPositions;
            this.firewoodEntities.clear();
            this.method_5431();
        } else {
            this.clearFirewoodBinding();
            LOGGER.warn("Failed to find firewood positions in pattern type: {}", (Object)patternType);
        }
    }

    private static boolean isFirewoodPositionPredicate(@NotNull class_2694 cachedPos) {
        class_2680 state = cachedPos.method_11681();
        return state.method_26215() || state.method_26204() instanceof FirewoodBlock || state.method_26204() instanceof CombustionFirewoodBlock;
    }

    private boolean areFirewoodPositionsValid(class_1937 world) {
        if (this.firewoodPos.isEmpty()) {
            return false;
        }
        for (class_2338 pos : this.firewoodPos) {
            class_2680 currentState = world.method_8320(pos);
            if (currentState.method_26215() || currentState.method_26204() instanceof FirewoodBlock || currentState.method_26204() instanceof CombustionFirewoodBlock) continue;
            return false;
        }
        return true;
    }

    private boolean isValidFirewoodPosition(@NotNull class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return state.method_26204() instanceof CombustionFirewoodBlock;
    }

    protected boolean areFirewoodValid(class_1937 world) {
        boolean result = false;
        if (!this.firewoodPos.isEmpty()) {
            for (class_2338 pos : this.firewoodPos) {
                class_2680 firewoodState = world.method_8320(pos);
                if (!(firewoodState.method_26204() instanceof CombustionFirewoodBlock)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private void clearFirewoodBinding() {
        this.firewoodPos.clear();
        this.firewoodEntities.clear();
        this.method_5431();
    }

    private void updateFirewood(class_1937 world) {
        if (world.field_9236) {
            return;
        }
        if (this.firewoodPos.isEmpty()) {
            this.firewoodEntities.clear();
            return;
        }
        if (this.firewoodEntities.isEmpty() || this.firewoodEntities.stream().anyMatch(class_2586::method_11015)) {
            this.firewoodEntities.clear();
            for (class_2338 pos : this.firewoodPos) {
                class_2586 be = world.method_8321(pos);
                if (!(be instanceof CombustionFirewoodBlockEntity)) continue;
                CombustionFirewoodBlockEntity combustionBE = (CombustionFirewoodBlockEntity)be;
                this.firewoodEntities.add(combustionBE);
            }
        }
    }

    public Set<class_2338> getFirewoodPositions() {
        return Collections.unmodifiableSet(this.firewoodPos);
    }

    public Set<CombustionFirewoodBlockEntity> getFirewoodEntities() {
        return this.firewoodEntities;
    }

    public int getActiveFirewoodCount() {
        return (int)this.firewoodEntities.stream().filter(Objects::nonNull).filter(CombustionFirewoodBlockEntity::isCombusting).count();
    }

    private void processBaking(class_1937 world) {
        if (this.method_5442()) {
            this.resetBakingProgress();
            return;
        }
        StoveRecipe recipe = this.matchGetter.method_42303((class_1263)this, world).orElse(null);
        if (recipe == null) {
            this.resetBakingProgress();
            return;
        }
        if (recipe.getMold() != null && recipe.isNeedMold() && !class_1799.method_7984((class_1799)((class_1799)this.otherStack.get(0)), (class_1799)recipe.getMold())) {
            return;
        }
        if (this.bakingTimeTotal == 0) {
            this.bakingTimeTotal = Math.max(recipe.getBakingTime(), 100);
        }
        int bakingSpeed = this.getBakingSpeed();
        this.bakingTime += bakingSpeed;
        if (this.bakingTime >= this.bakingTimeTotal) {
            this.completeBaking(world, recipe);
        }
        this.markDirtyAndSync();
    }

    private int getBakingSpeed() {
        if (this.firewoodEntities.isEmpty()) {
            return 0;
        }
        int activeFirewoodCount = 0;
        double totalEffectiveSpeed = 0.0;
        for (CombustionFirewoodBlockEntity firewoodBlock : this.firewoodEntities) {
            if (firewoodBlock == null || !firewoodBlock.isCombusting()) continue;
            double individualSpeed = 10 + (firewoodBlock.getHeatLevel() - 1);
            double effectiveSpeed = individualSpeed / Math.pow(++activeFirewoodCount, 0.7);
            totalEffectiveSpeed += effectiveSpeed;
        }
        if (activeFirewoodCount == 0) {
            return 0;
        }
        int result = (int)Math.round(totalEffectiveSpeed);
        return Math.max(10, result);
    }

    private void completeBaking(class_1937 world, StoveRecipe recipe) {
        class_1799 inputStack = this.method_5438(0);
        class_1799 outputStack = recipe.method_8110(world.method_30349());
        if (inputStack.method_7960() || outputStack.method_7960()) {
            this.resetBakingProgress();
            return;
        }
        this.method_5447(0, recipe.method_8116(this, world.method_30349()));
        this.originalInputStack = class_1799.field_8037;
        this.method_7662(recipe);
        this.recipesUsed.addTo((Object)recipe.method_8114(), 1);
        this.resetBakingProgress();
        world.method_8396(null, this.field_11867, class_3417.field_15006, class_3419.field_15245, 0.5f, 1.0f);
    }

    private void resetBakingProgress() {
        this.bakingTime = 0;
        this.bakingTimeTotal = 0;
        this.method_5431();
    }

    public float getBakingProgress() {
        if (this.bakingTimeTotal > 0) {
            return (float)this.bakingTime / (float)this.bakingTimeTotal;
        }
        return 0.0f;
    }

    public boolean canBake() {
        if (this.method_5442() || !this.hasHeat() || !this.isValidStove) {
            return false;
        }
        StoveRecipe recipe = this.matchGetter.method_42303((class_1263)this, this.field_11863).orElse(null);
        return recipe != null;
    }

    public int getBakingTime() {
        return this.bakingTime;
    }

    public int getBakingTimeTotal() {
        return this.bakingTimeTotal;
    }

    public boolean hasHeat() {
        for (CombustionFirewoodBlockEntity firewood : this.firewoodEntities) {
            if (!firewood.isCombusting()) continue;
            return true;
        }
        return false;
    }

    public boolean isBaking() {
        return this.bakingTime > 0;
    }

    private boolean isValidGrindingInput(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        class_1277 tempInventory = new class_1277(new class_1799[]{stack});
        return this.matchGetter.method_42303((class_1263)tempInventory, this.field_11863).isPresent();
    }

    public class_1799 getExpectedOutput() {
        StoveRecipe recipe = this.matchGetter.method_42303((class_1263)this, this.field_11863).orElse(null);
        if (recipe != null) {
            return recipe.method_8110(this.field_11863 != null ? this.field_11863.method_30349() : null);
        }
        return class_1799.field_8037;
    }

    public void method_7683(class_1662 finder) {
        for (class_1799 stack : this.inventory) {
            finder.method_7400(stack);
        }
    }

    public void method_7662(@Nullable class_1860<?> recipe) {
        this.lastRecipe = recipe;
    }

    @Nullable
    public class_1860<?> method_7663() {
        return this.lastRecipe;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, @NotNull HeatResistantSlateBlockEntity blockEntity) {
        boolean interval;
        ++blockEntity.age;
        if (blockEntity.age == Integer.MAX_VALUE) {
            blockEntity.age = 0;
        }
        boolean bl = interval = blockEntity.age - blockEntity.lastCheckTime < 10;
        if (!interval) {
            blockEntity.checkPattern(world, pos, state);
            blockEntity.lastCheckTime = blockEntity.age;
        }
        blockEntity.updateFirewood(world);
        if (blockEntity.hasHeat() && blockEntity.isValidStove) {
            blockEntity.processBaking(world);
        } else {
            blockEntity.resetBakingProgress();
        }
        blockEntity.method_5431();
    }

    private void checkPattern(class_1937 world, class_2338 pos, class_2680 state) {
        class_2586 class_25862;
        ServerMultiBlockReference ref;
        this.currentStoveResult = null;
        this.stoveStructureType = -1;
        this.isValidStove = false;
        if (world != null && !world.field_9236 && (this.multiBlockRef == null || this.multiBlockRef instanceof ClientMultiBlockReference) && (ref = ServerMultiBlockReference.fromNbt((class_4538)world, this.refNbt)) != null) {
            this.setMultiBlockReference(ref);
        }
        if (this.multiBlockRef == null || this.multiBlockRef.isDisposed()) {
            return;
        }
        if (!this.multiBlockRef.isMasterBlock() && world != null && (class_25862 = world.method_8321(this.multiBlockRef.getMasterWorldPos())) instanceof HeatResistantSlateBlockEntity) {
            HeatResistantSlateBlockEntity masterBlockEntity = (HeatResistantSlateBlockEntity)class_25862;
            this.firewoodPos = new HashSet<class_2338>(masterBlockEntity.firewoodPos);
            this.firewoodEntities = new HashSet<CombustionFirewoodBlockEntity>(masterBlockEntity.firewoodEntities);
            this.currentStoveResult = masterBlockEntity.currentStoveResult;
            this.resultDirection = masterBlockEntity.resultDirection;
            this.stoveStructureType = masterBlockEntity.stoveStructureType;
            this.isValidStove = masterBlockEntity.isValidStove;
            return;
        }
        if (!this.multiBlockRef.checkIntegrity()) {
            return;
        }
        if (!this.isValidStoveStructure()) {
            return;
        }
        int patternType = this.getStoveStructureType();
        if (patternType == -1) {
            return;
        }
        class_2700 pattern = this.getStovePattern(patternType);
        if (pattern == null) {
            return;
        }
        class_2338 searchPos = this.multiBlockRef.getMasterWorldPos();
        pattern.method_11708((class_4538)world, searchPos);
        class_2700.class_2702 result = this.searchAround(world, searchPos, patternType, pattern);
        if (result != null) {
            this.currentStoveResult = result;
            this.stoveStructureType = patternType;
            this.isValidStove = true;
            this.onStoveStructureValid(world, pos, result, patternType);
        } else {
            this.onStoveStructureInvalid(world, pos);
        }
    }

    @Nullable
    public class_2350 getResultDirection() {
        return this.resultDirection;
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public int method_5444() {
        return 16;
    }

    public int[] method_5494(class_2350 side) {
        return new int[]{0};
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return slot == 0;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot == 0;
    }

    public class_2371<class_1799> getOtherStacks() {
        class_2371 result = class_2371.method_10213((int)this.otherStack.size(), (Object)class_1799.field_8037);
        for (int i = 0; i < this.otherStack.size(); ++i) {
            result.set(i, (Object)((class_1799)this.otherStack.get(i)).method_7972());
        }
        return result;
    }

    public boolean isOtherEmpty() {
        for (class_1799 stack : this.otherStack) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }
}

