/*
 * Decompiled with CFR 0.152.
 */
package org.foodcraft.block.entity;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1662;
import net.minecraft.class_1732;
import net.minecraft.class_1737;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import org.foodcraft.block.MoldBlock;
import org.foodcraft.block.entity.UpPlaceBlockEntity;
import org.foodcraft.recipe.MoldRecipe;
import org.foodcraft.registry.ModBlockEntityTypes;
import org.foodcraft.registry.ModRecipeTypes;
import org.foodcraft.util.FoodCraftUtils;
import org.jetbrains.annotations.Nullable;

public class MoldBlockEntity
extends UpPlaceBlockEntity
implements class_1278,
class_1732,
class_1737 {
    protected static final int MAX_STACK_SIZE = 1;
    @Nullable
    protected class_1799 inputStack;
    protected final Object2IntOpenHashMap<class_2960> recipesUsed = new Object2IntOpenHashMap();
    protected final class_1863.class_7266<class_1263, ? extends MoldRecipe> matchGetter = class_1863.method_42302(ModRecipeTypes.MOLD);
    @Nullable
    protected class_1860<?> lastRecipe;

    public MoldBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypes.MOLD, pos, state, 1);
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        if (this.inputStack != null) {
            class_2487 inputNbt = new class_2487();
            this.inputStack.method_7953(inputNbt);
            nbt.method_10566("Input", (class_2520)inputNbt);
        }
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10545("Input")) {
            this.inputStack = class_1799.method_7915((class_2487)nbt.method_10562("Input"));
        }
    }

    @Override
    public class_265 getContentShape(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    }

    private boolean isValidMoldInput(class_1799 stack) {
        class_1792 class_17922;
        if (stack.method_7960()) {
            return false;
        }
        class_1277 tempInventory = new class_1277(new class_1799[]{stack});
        MoldRecipe recipe = this.matchGetter.method_42303((class_1263)tempInventory, this.field_11863).orElse(null);
        if (recipe != null && (class_17922 = recipe.getBaseMoldItem()) instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            return blockItem.method_7711() == this.method_11010().method_26204();
        }
        return false;
    }

    public class_2680 getInventoryBlockState() {
        class_1799 stack = this.method_5438(0);
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)MoldBlock.FACING);
        return FoodCraftUtils.createCountBlockstate(stack, facing);
    }

    @Override
    public boolean isValidItem(class_1799 stack) {
        class_1792 item = (class_1792)class_1792.field_8003.get(this.method_11010().method_26204());
        if (item != null && MoldRecipe.isCanPlace(item, stack)) {
            return true;
        }
        return this.isValidMoldInput(stack);
    }

    @Override
    public void onPlace(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit, class_1799 placeStack) {
        this.tryCraft();
        super.onPlace(state, world, pos, player, hand, hit, placeStack);
    }

    public void tryCraft() {
        MoldRecipe recipe = this.matchGetter.method_42303((class_1263)this, this.field_11863).orElse(null);
        this.inputStack = this.method_5438(0).method_7972();
        if (recipe == null) {
            return;
        }
        this.craftRecipe(recipe);
    }

    @Override
    public class_1269 tryAddItem(class_1799 stack) {
        if (stack.method_7960() || !this.isValidItem(stack)) {
            return class_1269.field_5814;
        }
        class_1799 newStack = stack.method_7972();
        newStack.method_7939(1);
        if (this.method_5442()) {
            this.method_5447(0, newStack);
            this.markDirtyAndSync();
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    @Override
    public class_1269 tryFetchItem(class_1657 player) {
        if (!this.method_5442() && this.inputStack != null) {
            this.method_5434(0, 1);
            this.fetchStacks = List.of(this.inputStack.method_7972());
            if (!player.method_7337() && !player.method_7270(this.inputStack)) {
                player.method_7328(this.inputStack, false);
            }
            this.inputStack = null;
            this.markDirtyAndSync();
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    protected void craftRecipe(MoldRecipe recipe) {
        class_1799 output = recipe.method_8116(this, null);
        this.method_5447(0, output);
        this.method_7662(recipe);
        this.recipesUsed.addTo((Object)recipe.method_8114(), 1);
        this.markDirtyAndSync();
    }

    @Nullable
    public class_1799 getInputStack() {
        if (this.inputStack != null) {
            return this.inputStack.method_7972();
        }
        return null;
    }

    public int[] method_5494(class_2350 side) {
        return new int[]{0};
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return slot == 0;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot == 0;
    }

    public void method_7683(class_1662 finder) {
        for (class_1799 stack : this.inventory) {
            finder.method_7400(stack);
        }
    }

    public void method_7662(@Nullable class_1860<?> recipe) {
        this.lastRecipe = recipe;
    }

    @Nullable
    public class_1860<?> method_7663() {
        return null;
    }

    public int method_5444() {
        return 1;
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }
}

