/*
 * Decompiled with CFR 0.152.
 */
package org.foodcraft.block.entity;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2362;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3726;
import net.minecraft.class_7923;
import org.foodcraft.block.FlourSackBlock;
import org.foodcraft.block.ShelfBlock;
import org.foodcraft.block.entity.UpPlaceBlockEntity;
import org.foodcraft.item.FlourSackItem;
import org.foodcraft.mixin.FlowerPotBlockAccessor;
import org.foodcraft.registry.ModBlockEntityTypes;
import org.foodcraft.registry.ModItems;
import org.foodcraft.util.FoodCraftUtils;

public class ShelfBlockEntity
extends UpPlaceBlockEntity {
    private static final int INVENTORY_SIZE = 2;
    private static final int MAX_STACK_SIZE = 1;
    private static final String CONTENT_DATA_KEY = "ContentData";
    private static final byte CONTENT_TYPE_EMPTY = 0;
    private static final byte CONTENT_TYPE_FLOWER = 1;
    private static final byte CONTENT_TYPE_FLOUR = 2;
    private class_2499 contentData = new class_2499();
    public static final Set<Predicate<class_1799>> CanPlaceItem = new HashSet<Predicate<class_1799>>();

    public ShelfBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypes.SHELF, pos, state, 2);
        for (int i = 0; i < 2; ++i) {
            this.contentData.add((Object)this.createEmptyContentData());
        }
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10545(CONTENT_DATA_KEY)) {
            this.contentData = nbt.method_10554(CONTENT_DATA_KEY, 10);
            while (this.contentData.size() < this.method_5439()) {
                this.contentData.add((Object)this.createEmptyContentData());
            }
        } else {
            this.contentData = new class_2499();
            for (int i = 0; i < this.method_5439(); ++i) {
                this.contentData.add((Object)this.createEmptyContentData());
            }
        }
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10566(CONTENT_DATA_KEY, (class_2520)this.contentData);
    }

    @Override
    public class_265 getContentShape(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 direction = (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12481);
        class_265 resultShape = class_259.method_1073();
        for (int i = 0; i < this.method_5439(); ++i) {
            double zOffset;
            double xOffset;
            class_2680 itemState;
            if (this.method_5438(i).method_7960() || (itemState = this.getInventoryBlockState(i)).method_26215()) continue;
            class_265 itemShape = itemState.method_26172(world, pos, context);
            double offset = -0.25;
            double offsetSign = i == 0 ? -offset : offset;
            double offsetSign_x = i == 0 ? offset : -offset;
            itemShape = this.scaleShape(itemState, itemShape);
            switch (direction) {
                case field_11035: {
                    xOffset = offsetSign;
                    double d = -offset;
                    break;
                }
                case field_11043: {
                    xOffset = offsetSign_x;
                    double d = offset;
                    break;
                }
                case field_11039: {
                    xOffset = offset;
                    double d = offsetSign;
                    break;
                }
                case field_11034: {
                    xOffset = -offset;
                    double d = offsetSign_x;
                    break;
                }
                default: {
                    xOffset = 0.0;
                    double d = zOffset = 0.0;
                }
            }
            if (itemShape == null || itemShape.method_1110()) continue;
            resultShape = class_259.method_1084((class_265)resultShape, (class_265)itemShape.method_1096(xOffset, 0.0, zOffset));
        }
        return resultShape;
    }

    protected class_265 scaleShape(class_2680 itemState, class_265 itemShape) {
        if (itemState.method_26204() instanceof FlourSackBlock) {
            return FoodCraftUtils.scale(itemShape, 0.7).method_1096(0.0, 0.25, 0.0);
        }
        return itemShape.method_1096(0.0, 0.3125, 0.0);
    }

    public class_2680 getInventoryBlockState(int index) {
        class_1747 blockItem;
        Object contentToPotted;
        class_2248 pottedBlock;
        class_2248 flowerBlock;
        class_1799 stack = (class_1799)this.inventory.get(index);
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)ShelfBlock.FACING);
        if (this.isFlowerPot(stack) && this.hasFlower(index) && (flowerBlock = this.getFlowerBlock(index)) != null && (pottedBlock = (class_2248)(contentToPotted = FlowerPotBlockAccessor.getContentToPotted()).get(flowerBlock)) != null) {
            return pottedBlock.method_9564();
        }
        contentToPotted = stack.method_7909();
        if (contentToPotted instanceof class_1747 && (blockItem = (class_1747)contentToPotted).method_7711() instanceof FlourSackBlock) {
            class_2680 flourSackState = blockItem.method_7711().method_9564();
            if (flourSackState.method_28498((class_2769)FlourSackBlock.SHELF_INDEX)) {
                flourSackState = (class_2680)flourSackState.method_11657((class_2769)FlourSackBlock.SHELF_INDEX, (Comparable)Integer.valueOf(index));
            }
            return flourSackState;
        }
        return FoodCraftUtils.createCountBlockstate(stack, facing);
    }

    @Override
    public boolean isValidItem(class_1799 stack) {
        for (Predicate<class_1799> canItem : CanPlaceItem) {
            class_1747 blockItem;
            if (!canItem.test(stack)) continue;
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof class_1747 && (blockItem = (class_1747)class_17922).method_7711() instanceof FlourSackBlock) {
                return FlourSackItem.getFirstBundledStack(stack).isPresent();
            }
            return true;
        }
        return this.canInsertFlower(stack);
    }

    public boolean canInsertFlower(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof class_1747)) {
            return false;
        }
        class_1747 blockItem = (class_1747)class_17922;
        class_2248 block = blockItem.method_7711();
        Map<class_2248, class_2248> contentToPotted = FlowerPotBlockAccessor.getContentToPotted();
        return contentToPotted.containsKey(block);
    }

    @Override
    public class_1269 tryAddItem(class_1799 stack) {
        if (stack.method_7960() || !this.isValidItem(stack)) {
            return class_1269.field_5814;
        }
        if (this.canInsertFlower(stack)) {
            return this.tryInsertFlower(stack);
        }
        class_1799 newStack = stack.method_7972();
        newStack.method_7939(1);
        int emptySlot = this.foundSlot();
        if (emptySlot != -1) {
            class_1747 blockItem;
            this.method_5447(emptySlot, newStack);
            class_1792 class_17922 = newStack.method_7909();
            if (class_17922 instanceof class_1747 && (blockItem = (class_1747)class_17922).method_7711() instanceof FlourSackBlock) {
                this.saveFlourContent(emptySlot, newStack);
            } else if (this.isFlowerPot(newStack)) {
                this.initFlowerPotData(emptySlot);
            }
            this.markDirtyAndSync();
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    private class_1269 tryInsertFlower(class_1799 flowerStack) {
        class_1792 class_17922 = flowerStack.method_7909();
        if (!(class_17922 instanceof class_1747)) {
            return class_1269.field_5814;
        }
        class_1747 blockItem = (class_1747)class_17922;
        class_2248 flowerBlock = blockItem.method_7711();
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 slotStack = this.method_5438(i);
            if (!this.isFlowerPot(slotStack) || this.hasFlower(i)) continue;
            this.setFlowerData(i, flowerBlock);
            this.markDirtyAndSync();
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    public int foundSlot() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            if (!this.method_5438(i).method_7960()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public class_1269 tryFetchItem(class_1657 player) {
        for (int i = this.method_5439() - 1; i >= 0; --i) {
            class_1747 blockItem;
            class_1799 stack = this.method_5438(i);
            if (stack.method_7960()) continue;
            if (this.isFlowerPot(stack) && this.hasFlower(i)) {
                return this.tryFetchFlower(player, i);
            }
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof class_1747 && (blockItem = (class_1747)class_17922).method_7711() instanceof FlourSackBlock) {
                stack = this.restoreFlourContent(i, stack);
            }
            class_1799 extractedStack = stack.method_7972();
            extractedStack.method_7939(1);
            this.fetchStacks = List.of(extractedStack.method_7972());
            if (!player.method_7337() && !player.method_7270(extractedStack)) {
                player.method_7328(extractedStack, false);
            }
            stack.method_7934(1);
            if (stack.method_7960()) {
                this.method_5447(i, class_1799.field_8037);
                this.clearContentData(i);
            }
            this.markDirtyAndSync();
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    public class_2371<class_1799> getDroppedStacks() {
        class_2371 drops = class_2371.method_10211();
        for (int i = 0; i < this.method_5439(); ++i) {
            class_2248 flowerBlock;
            class_1747 blockItem;
            class_1799 stack = this.method_5438(i);
            if (stack.method_7960()) continue;
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof class_1747 && (blockItem = (class_1747)class_17922).method_7711() instanceof FlourSackBlock) {
                stack = this.restoreFlourContent(i, stack);
            }
            if (this.isFlowerPot(stack) && this.hasFlower(i) && (flowerBlock = this.getFlowerBlock(i)) != null) {
                drops.add((Object)new class_1799((class_1935)flowerBlock));
            }
            drops.add((Object)stack);
        }
        return drops;
    }

    private class_1269 tryFetchFlower(class_1657 player, int slot) {
        class_2248 flowerBlock = this.getFlowerBlock(slot);
        if (flowerBlock == null) {
            return class_1269.field_5814;
        }
        class_1799 flowerStack = new class_1799((class_1935)flowerBlock);
        this.fetchStacks = List.of(flowerStack.method_7972());
        if (!player.method_7337() && !player.method_7270(flowerStack)) {
            player.method_7328(flowerStack, false);
        }
        this.clearFlowerData(slot);
        this.markDirtyAndSync();
        return class_1269.field_5812;
    }

    public int method_5444() {
        return 1;
    }

    public class_2487 method_16887() {
        class_2487 nbt = this.method_38244();
        nbt.method_10566(CONTENT_DATA_KEY, (class_2520)this.contentData);
        return nbt;
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2499 getContentData() {
        return this.contentData.method_10612();
    }

    private boolean isFlowerPot(class_1799 stack) {
        class_1747 blockItem;
        class_1792 class_17922 = stack.method_7909();
        return class_17922 instanceof class_1747 && (blockItem = (class_1747)class_17922).method_7711() instanceof class_2362;
    }

    private boolean hasFlower(int slot) {
        if (slot < 0 || slot >= this.method_5439()) {
            return false;
        }
        class_2487 content = this.contentData.method_10602(slot);
        return content.method_10571("Type") == 1;
    }

    private class_2248 getFlowerBlock(int slot) {
        if (slot < 0 || slot >= this.contentData.size()) {
            return null;
        }
        class_2487 content = this.contentData.method_10602(slot);
        if (content.method_10571("Type") == 1 && content.method_10545("flower")) {
            String flowerId = content.method_10558("flower");
            return (class_2248)class_7923.field_41175.method_10223(new class_2960(flowerId));
        }
        return null;
    }

    private void setFlowerData(int slot, class_2248 flowerBlock) {
        if (slot < 0 || slot >= this.contentData.size()) {
            return;
        }
        class_2487 content = new class_2487();
        content.method_10567("Type", (byte)1);
        String flowerId = class_7923.field_41175.method_10221((Object)flowerBlock).toString();
        content.method_10582("flower", flowerId);
        this.contentData.method_10606(slot, (class_2520)content);
    }

    private void initFlowerPotData(int slot) {
        if (slot < 0 || slot >= this.contentData.size()) {
            return;
        }
        this.contentData.method_10606(slot, (class_2520)this.createEmptyContentData());
    }

    private void clearContentData(int slot) {
        if (slot < 0 || slot >= this.contentData.size()) {
            return;
        }
        this.contentData.method_10606(slot, (class_2520)this.createEmptyContentData());
    }

    private void clearFlowerData(int slot) {
        this.clearContentData(slot);
    }

    private void saveFlourContent(int slot, class_1799 flourSack) {
        if (slot < 0 || slot >= this.contentData.size()) {
            return;
        }
        Optional<class_1799> flourContent = FlourSackItem.getFirstBundledStack(flourSack);
        if (flourContent.isPresent()) {
            class_2487 content = new class_2487();
            content.method_10567("Type", (byte)2);
            class_2487 flourNbt = new class_2487();
            flourContent.get().method_7953(flourNbt);
            content.method_10566("flour", (class_2520)flourNbt);
            this.contentData.method_10606(slot, (class_2520)content);
        }
    }

    private class_1799 restoreFlourContent(int slot, class_1799 flourSack) {
        if (slot < 0 || slot >= this.contentData.size()) {
            return flourSack;
        }
        class_2487 content = this.contentData.method_10602(slot);
        if (content.method_10571("Type") == 2 && content.method_10545("flour")) {
            class_2487 flourNbt = content.method_10562("flour");
            class_1799 flourStack = class_1799.method_7915((class_2487)flourNbt);
            class_1799 resultSack = new class_1799((class_1935)flourSack.method_7909());
            class_2487 nbt = new class_2487();
            class_2499 items = new class_2499();
            class_2487 itemNbt = new class_2487();
            flourStack.method_7953(itemNbt);
            items.add((Object)itemNbt);
            nbt.method_10566("Items", (class_2520)items);
            resultSack.method_7980(nbt);
            this.clearContentData(slot);
            return resultSack;
        }
        return flourSack;
    }

    private class_2487 createEmptyContentData() {
        class_2487 content = new class_2487();
        content.method_10567("Type", (byte)0);
        return content;
    }

    public boolean hasEmptyFlowerPot() {
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 stack = this.method_5438(i);
            if (!this.isFlowerPot(stack) || this.hasFlower(i)) continue;
            return true;
        }
        return false;
    }

    public boolean hasFloweredPot() {
        for (int i = 0; i < this.method_5439(); ++i) {
            if (!this.isFlowerPot(this.method_5438(i)) || !this.hasFlower(i)) continue;
            return true;
        }
        return false;
    }

    static {
        CanPlaceItem.add(stack -> {
            class_1747 blockItem;
            class_1792 patt0$temp = stack.method_7909();
            return patt0$temp instanceof class_1747 && (blockItem = (class_1747)patt0$temp).method_7711() instanceof FlourSackBlock;
        });
        CanPlaceItem.add(stack -> {
            class_1747 blockItem;
            class_1792 patt0$temp = stack.method_7909();
            return patt0$temp instanceof class_1747 && (blockItem = (class_1747)patt0$temp).method_7711() instanceof class_2362;
        });
        CanPlaceItem.add(stack -> stack.method_7909() == ModItems.SALT_SHAKER);
    }
}

