/*
 * Decompiled with CFR 0.152.
 */
package org.foodcraft.block.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import org.dfood.item.DoubleBlockItem;
import org.foodcraft.block.UpPlaceBlock;

public abstract class UpPlaceBlockEntity
extends class_2586
implements class_1263 {
    protected class_2371<class_1799> inventory;
    protected List<class_1799> fetchStacks;

    public UpPlaceBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, int inventorySize) {
        super(type, pos, state);
        this.inventory = class_2371.method_10213((int)inventorySize, (Object)class_1799.field_8037);
        this.fetchStacks = new CopyOnWriteArrayList<class_1799>();
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.inventory);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public boolean method_5442() {
        for (class_1799 stack : this.inventory) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        this.validateSlotIndex(slot);
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        this.validateSlotIndex(slot);
        return class_1262.method_5430(this.inventory, (int)slot, (int)amount);
    }

    public class_1799 method_5441(int slot) {
        this.validateSlotIndex(slot);
        return class_1262.method_5428(this.inventory, (int)slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.validateSlotIndex(slot);
        this.inventory.set(slot, (Object)stack);
        this.limitStackSizeIfNeeded(stack);
    }

    public void method_5448() {
        this.inventory.clear();
    }

    protected void limitStackSizeIfNeeded(class_1799 stack) {
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
    }

    public void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.method_5439()) {
            throw new IllegalArgumentException("Slot " + slot + " not in valid range - [0," + this.method_5439() + ")");
        }
    }

    public abstract class_265 getContentShape(class_2680 var1, class_1922 var2, class_2338 var3, class_3726 var4);

    public abstract boolean isValidItem(class_1799 var1);

    public abstract class_1269 tryAddItem(class_1799 var1);

    public abstract class_1269 tryFetchItem(class_1657 var1);

    public void onFetch(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit, List<class_1799> fetchStacks) {
        class_2248 class_22482 = this.method_11010().method_26204();
        if (class_22482 instanceof UpPlaceBlock) {
            UpPlaceBlock upPlaceBlock = (UpPlaceBlock)class_22482;
            if (upPlaceBlock.upSounds.isDefault()) {
                UpPlaceBlock.UpSounds.playSound(world, pos, this.getSoundForItem(fetchStacks.get(0), false));
            } else {
                upPlaceBlock.upSounds.playFetchSound(world, pos);
            }
        }
    }

    public void onPlace(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit, class_1799 placeStack) {
        class_2248 class_22482 = this.method_11010().method_26204();
        if (class_22482 instanceof UpPlaceBlock) {
            UpPlaceBlock upPlaceBlock = (UpPlaceBlock)class_22482;
            if (upPlaceBlock.upSounds.isDefault()) {
                UpPlaceBlock.UpSounds.playSound(world, pos, this.getSoundForItem(placeStack, true));
            } else {
                upPlaceBlock.upSounds.playPlaceSound(world, pos);
            }
        }
        if (!player.method_7337()) {
            placeStack.method_7934(1);
        }
    }

    public List<class_1799> getFetchStacks(class_1657 fetchPlayer, class_1268 hand, class_239 hit) {
        if (this.fetchStacks.isEmpty()) {
            return Collections.emptyList();
        }
        System.out.println(this.fetchStacks);
        ArrayList<class_1799> result = new ArrayList<class_1799>(this.fetchStacks);
        this.fetchStacks = new CopyOnWriteArrayList<class_1799>();
        return result;
    }

    private class_3414 getSoundForItem(class_1799 itemStack, boolean isPlaceSound) {
        class_2498 soundGroup = this.getSoundGroupFromItem(itemStack);
        if (soundGroup != null) {
            return isPlaceSound ? soundGroup.method_10598() : soundGroup.method_10595();
        }
        UpPlaceBlock.UpSounds defaultSounds = UpPlaceBlock.UpSounds.DEFAULT;
        return isPlaceSound ? defaultSounds.placeSound() : defaultSounds.fetchSound();
    }

    private class_2498 getSoundGroupFromItem(class_1799 itemStack) {
        class_1792 item = itemStack.method_7909();
        if (item instanceof class_1747) {
            class_1747 blockItem = (class_1747)item;
            return blockItem.method_7711().method_9573(blockItem.method_7711().method_9564());
        }
        if (item instanceof DoubleBlockItem) {
            DoubleBlockItem doubleBlockItem = (DoubleBlockItem)item;
            return doubleBlockItem.getSecondBlock().method_9573(doubleBlockItem.getSecondBlock().method_9564());
        }
        return null;
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public class_1792 getContentItem() {
        class_1799 contentStack = this.method_5438(0);
        return contentStack.method_7960() ? null : contentStack.method_7909();
    }

    public boolean isFull() {
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 stack = this.method_5438(i);
            if (!stack.method_7960() && stack.method_7947() >= this.method_5444()) continue;
            return false;
        }
        return true;
    }

    public boolean isAccepted(class_1269 result) {
        return result.method_23665();
    }

    public void markDirtyAndSync() {
        this.method_5431();
        this.sync();
    }

    public void sync() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }
}

