/*
 * Decompiled with CFR 0.152.
 */
package org.foodcraft.block.multi;

import java.util.Objects;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.foodcraft.FoodCraft;
import org.foodcraft.block.multi.MultiBlockReference;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ClientMultiBlockReference
implements MultiBlockReference {
    private static final Logger LOGGER = FoodCraft.LOGGER;
    private static final String MASTER_POS_KEY = "MasterPos";
    private static final String RELATIVE_POS_KEY = "RelativePos";
    private static final String BASE_BLOCK_KEY = "BaseBlock";
    private final class_2338 masterWorldPos;
    private final class_2338 relativePos;
    private final class_2248 baseBlock;
    private final class_2338 worldPos;
    private final int volume;

    private ClientMultiBlockReference(@NotNull class_2338 masterWorldPos, @NotNull class_2338 relativePos, @NotNull class_2248 baseBlock, int volume) {
        this.masterWorldPos = Objects.requireNonNull(masterWorldPos, "Master world position cannot be null");
        this.relativePos = Objects.requireNonNull(relativePos, "Relative position cannot be null");
        this.baseBlock = Objects.requireNonNull(baseBlock, "Base block cannot be null");
        this.volume = volume;
        this.worldPos = new class_2338(masterWorldPos.method_10263() + relativePos.method_10263(), masterWorldPos.method_10264() + relativePos.method_10264(), masterWorldPos.method_10260() + relativePos.method_10260());
    }

    public ClientMultiBlockReference(@NotNull class_2487 nbt) {
        this.masterWorldPos = class_2512.method_10691((class_2487)nbt.method_10562(MASTER_POS_KEY));
        this.relativePos = class_2512.method_10691((class_2487)nbt.method_10562(RELATIVE_POS_KEY));
        String blockId = nbt.method_10558(BASE_BLOCK_KEY);
        this.baseBlock = (class_2248)class_7923.field_41175.method_10223(new class_2960(blockId));
        this.volume = nbt.method_10545("Volume") ? nbt.method_10550("Volume") : 1;
        this.worldPos = new class_2338(this.masterWorldPos.method_10263() + this.relativePos.method_10263(), this.masterWorldPos.method_10264() + this.relativePos.method_10264(), this.masterWorldPos.method_10260() + this.relativePos.method_10260());
        LOGGER.debug("Created ClientMultiBlockReference: master={}, relative={}, block={}", new Object[]{this.masterWorldPos, this.relativePos, this.baseBlock});
    }

    @Override
    @NotNull
    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10566(MASTER_POS_KEY, (class_2520)class_2512.method_10692((class_2338)this.masterWorldPos));
        nbt.method_10566(RELATIVE_POS_KEY, (class_2520)class_2512.method_10692((class_2338)this.relativePos));
        nbt.method_10582(BASE_BLOCK_KEY, this.baseBlock.method_40142().method_40237().method_29177().toString());
        nbt.method_10569("Volume", this.volume);
        LOGGER.debug("Serialized ClientMultiBlockReference: master={}, relative={}, block={}", new Object[]{this.masterWorldPos, this.relativePos, this.baseBlock});
        return nbt;
    }

    @Override
    public boolean matchesBlock(class_2248 block) {
        return this.baseBlock == block;
    }

    @Override
    public boolean matchesBlockState(class_2680 blockState) {
        return this.matchesBlock(blockState.method_26204());
    }

    @Override
    public boolean matchesBlockEntity(class_2586 blockEntity) {
        if (blockEntity == null) {
            return false;
        }
        return this.matchesBlockState(blockEntity.method_11010());
    }

    @Override
    public boolean isMasterBlock() {
        return this.relativePos.method_10263() == 0 && this.relativePos.method_10264() == 0 && this.relativePos.method_10260() == 0;
    }

    @Override
    public class_2338 getMasterWorldPos() {
        return this.masterWorldPos;
    }

    @Override
    public class_2338 getWorldPos() {
        return this.worldPos;
    }

    @Override
    public class_2338 getRelativePos() {
        return this.relativePos;
    }

    @Override
    public class_2248 getBaseBlock() {
        return this.baseBlock;
    }

    @Override
    public int getVolume() {
        return this.volume;
    }

    @Override
    public boolean containsWorldPos(class_2338 worldPos) {
        int width = 1;
        int height = 1;
        int depth = 1;
        if (this.isMasterBlock() && this.volume > 1) {
            int side = (int)Math.cbrt(this.volume);
            height = depth = Math.max(1, side);
            width = depth;
        }
        class_2338 endPos = new class_2338(this.masterWorldPos.method_10263() + width - 1, this.masterWorldPos.method_10264() + height - 1, this.masterWorldPos.method_10260() + depth - 1);
        return worldPos.method_10263() >= this.masterWorldPos.method_10263() && worldPos.method_10263() <= endPos.method_10263() && worldPos.method_10264() >= this.masterWorldPos.method_10264() && worldPos.method_10264() <= endPos.method_10264() && worldPos.method_10260() >= this.masterWorldPos.method_10260() && worldPos.method_10260() <= endPos.method_10260();
    }

    @Override
    public boolean checkIntegrity() {
        return true;
    }

    @Override
    public boolean isDisposed() {
        return false;
    }

    @Override
    public void dispose() {
        LOGGER.debug("ClientMultiBlockReference disposed at relative position {}", (Object)this.relativePos);
    }

    @Override
    public int getRelativeX() {
        return this.relativePos.method_10263();
    }

    @Override
    public int getRelativeY() {
        return this.relativePos.method_10264();
    }

    @Override
    public int getRelativeZ() {
        return this.relativePos.method_10260();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClientMultiBlockReference that = (ClientMultiBlockReference)obj;
        return Objects.equals(this.masterWorldPos, that.masterWorldPos) && Objects.equals(this.relativePos, that.relativePos) && Objects.equals(this.baseBlock, that.baseBlock);
    }

    public int hashCode() {
        return Objects.hash(this.masterWorldPos, this.relativePos, this.baseBlock);
    }

    public String toString() {
        return String.format("ClientMultiBlockReference{masterPos=%s, relativePos=%s, worldPos=%s, isMaster=%b}", this.masterWorldPos, this.relativePos, this.worldPos, this.isMasterBlock());
    }
}

