/*
 * Decompiled with CFR 0.152.
 */
package org.foodcraft.block.multi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_4538;
import org.foodcraft.FoodCraft;
import org.foodcraft.block.multi.MultiBlockManager;
import org.foodcraft.block.multi.MultiBlockReference;
import org.foodcraft.block.multi.ServerMultiBlockReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class MultiBlock
implements AutoCloseable {
    private static final Logger LOGGER = FoodCraft.LOGGER;
    public static final int MAX_SIZE = 10;
    protected final class_4538 world;
    protected final class_2248 baseBlock;
    protected final PatternRange range;
    protected final class_2338 masterPos;
    protected boolean disposed = false;

    protected MultiBlock(class_4538 world, class_2248 baseBlock, PatternRange range) {
        this.world = Objects.requireNonNull(world, "World cannot be null");
        this.baseBlock = Objects.requireNonNull(baseBlock, "Base block cannot be null");
        this.range = Objects.requireNonNull(range, "Range cannot be null");
        this.masterPos = range.getStart();
        if (range.getWidth() > 10 || range.getHeight() > 10 || range.getDepth() > 10) {
            throw new IllegalArgumentException(String.format("MultiBlock size %dx%dx%d exceeds maximum allowed size %dx%dx%d", range.getWidth(), range.getHeight(), range.getDepth(), 10, 10, 10));
        }
        if (!MultiBlockManager.registerMultiBlock(this)) {
            MultiBlock existing = MultiBlockManager.findMultiBlock(world, this.masterPos);
            String errorMsg = existing != null ? String.format("Failed to register MultiBlock at position %s. Position already occupied by MultiBlock with base block %s", this.masterPos, existing.getBaseBlock()) : String.format("Failed to register MultiBlock at position %s for unknown reason", this.masterPos);
            throw new IllegalStateException(errorMsg);
        }
        LOGGER.debug("Created new MultiBlock at {} with base block {} and size {}x{}x{}", new Object[]{this.masterPos, baseBlock, range.getWidth(), range.getHeight(), range.getDepth()});
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<MultiBlock> checkAndSplitIntegrity() {
        if (this.disposed) {
            LOGGER.warn("Attempted to check integrity of disposed MultiBlock at {}", (Object)this.masterPos);
            return Collections.emptyList();
        }
        List<class_2338> validBlocks = this.findValidBlocks();
        if (validBlocks.size() == this.getVolume()) {
            LOGGER.debug("MultiBlock at {} is intact, no need to split", (Object)this.masterPos);
            return Collections.emptyList();
        }
        LOGGER.info("MultiBlock at {} is incomplete. Valid blocks: {}/{}. Splitting...", new Object[]{this.masterPos, validBlocks.size(), this.getVolume()});
        this.dispose();
        List<MultiBlock> newMultiBlocks = this.splitMultiBlock(validBlocks);
        LOGGER.info("Split MultiBlock at {} into {} new MultiBlocks", (Object)this.masterPos, (Object)newMultiBlocks.size());
        return newMultiBlocks;
    }

    private List<class_2338> findValidBlocks() {
        ArrayList<class_2338> validBlocks = new ArrayList<class_2338>();
        class_2338 start = this.range.getStart();
        class_2338 end = this.getEndPos();
        for (int x = start.method_10263(); x <= end.method_10263(); ++x) {
            for (int y = start.method_10264(); y <= end.method_10264(); ++y) {
                for (int z = start.method_10260(); z <= end.method_10260(); ++z) {
                    class_2338 pos = new class_2338(x, y, z);
                    class_2248 block = this.world.method_8320(pos).method_26204();
                    if (block != this.baseBlock) continue;
                    validBlocks.add(pos);
                }
            }
        }
        return validBlocks;
    }

    private List<MultiBlock> splitMultiBlock(List<class_2338> validBlocks) {
        if (validBlocks.isEmpty()) {
            return Collections.emptyList();
        }
        List<MultiBlock> result = this.splitMultiBlockOptimized(validBlocks);
        if (result.isEmpty()) {
            LOGGER.warn("Optimized decomposition failed, falling back to original algorithm");
            return this.splitMultiBlockFallback(validBlocks);
        }
        return result;
    }

    private List<MultiBlock> splitMultiBlockFallback(List<class_2338> validBlocks) {
        List<List<class_2338>> connectedComponents = this.findConnectedComponents(validBlocks);
        ArrayList<MultiBlock> result = new ArrayList<MultiBlock>();
        for (List<class_2338> component : connectedComponents) {
            MultiBlock newMultiBlock;
            if (component.isEmpty() || (newMultiBlock = this.createMultiBlockFromComponent(component)) == null) continue;
            result.add(newMultiBlock);
        }
        return result;
    }

    private List<List<class_2338>> findConnectedComponents(List<class_2338> validBlocks) {
        HashSet<class_2338> visited = new HashSet<class_2338>();
        ArrayList<List<class_2338>> components = new ArrayList<List<class_2338>>();
        HashSet<class_2338> validSet = new HashSet<class_2338>(validBlocks);
        int[][] directions = new int[][]{{1, 0, 0}, {-1, 0, 0}, {0, 1, 0}, {0, -1, 0}, {0, 0, 1}, {0, 0, -1}};
        for (class_2338 block : validBlocks) {
            if (visited.contains(block)) continue;
            ArrayList<class_2338> component = new ArrayList<class_2338>();
            LinkedList<class_2338> queue = new LinkedList<class_2338>();
            queue.add(block);
            visited.add(block);
            component.add(block);
            while (!queue.isEmpty()) {
                class_2338 current = (class_2338)queue.poll();
                for (int[] dir : directions) {
                    class_2338 neighbor = new class_2338(current.method_10263() + dir[0], current.method_10264() + dir[1], current.method_10260() + dir[2]);
                    if (!validSet.contains(neighbor) || visited.contains(neighbor)) continue;
                    visited.add(neighbor);
                    component.add(neighbor);
                    queue.add(neighbor);
                }
            }
            components.add(component);
        }
        return components;
    }

    private MultiBlock createMultiBlockFromComponent(List<class_2338> component) {
        if (component.isEmpty()) {
            return null;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (class_2338 pos : component) {
            minX = Math.min(minX, pos.method_10263());
            minY = Math.min(minY, pos.method_10264());
            minZ = Math.min(minZ, pos.method_10260());
            maxX = Math.max(maxX, pos.method_10263());
            maxY = Math.max(maxY, pos.method_10264());
            maxZ = Math.max(maxZ, pos.method_10260());
        }
        if (!this.isRectangularRegionValid(component, minX, minY, minZ, maxX, maxY, maxZ)) {
            return this.createMinimalMultiBlock(component);
        }
        class_2338 newStart = new class_2338(minX, minY, minZ);
        int width = maxX - minX + 1;
        int height = maxY - minY + 1;
        int depth = maxZ - minZ + 1;
        try {
            return MultiBlock.builder().world(this.world).baseBlock(this.baseBlock).range(newStart, width, height, depth).build();
        }
        catch (Exception e) {
            LOGGER.error("Failed to create MultiBlock from component: {}", (Object)e.getMessage());
            return this.createMinimalMultiBlock(component);
        }
    }

    private boolean isRectangularRegionValid(List<class_2338> component, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        HashSet<class_2338> componentSet = new HashSet<class_2338>(component);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2338 pos = new class_2338(x, y, z);
                    if (componentSet.contains(pos)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private MultiBlock createMinimalMultiBlock(List<class_2338> component) {
        if (component.isEmpty()) {
            return null;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (class_2338 pos : component) {
            minX = Math.min(minX, pos.method_10263());
            minY = Math.min(minY, pos.method_10264());
            minZ = Math.min(minZ, pos.method_10260());
            maxX = Math.max(maxX, pos.method_10263());
            maxY = Math.max(maxY, pos.method_10264());
            maxZ = Math.max(maxZ, pos.method_10260());
        }
        class_2338 newStart = new class_2338(minX, minY, minZ);
        int width = maxX - minX + 1;
        int height = maxY - minY + 1;
        int depth = maxZ - minZ + 1;
        try {
            MultiBlock multiBlock = MultiBlock.builder().world(this.world).baseBlock(this.baseBlock).range(newStart, width, height, depth).build();
            LOGGER.warn("Created non-solid MultiBlock at {} with size {}x{}x{} containing {} blocks", new Object[]{newStart, width, height, depth, component.size()});
            return multiBlock;
        }
        catch (Exception e) {
            LOGGER.error("Failed to create minimal MultiBlock: {}", (Object)e.getMessage());
            return null;
        }
    }

    private List<MultiBlock> splitMultiBlockOptimized(List<class_2338> validBlocks) {
        if (validBlocks.isEmpty()) {
            return Collections.emptyList();
        }
        LOGGER.debug("Starting optimized cube decomposition for {} valid blocks", (Object)validBlocks.size());
        List<CubeDecomposition> decomposedCubes = this.decomposeIntoSolidCubes(validBlocks);
        ArrayList<MultiBlock> result = new ArrayList<MultiBlock>();
        for (CubeDecomposition cube : decomposedCubes) {
            MultiBlock newMultiBlock;
            if (!cube.isValid() || (newMultiBlock = this.createMultiBlockFromCube(cube)) == null) continue;
            result.add(newMultiBlock);
            LOGGER.debug("Created optimized MultiBlock: {} with size {}x{}x{}", new Object[]{cube.start, cube.width, cube.height, cube.depth});
        }
        LOGGER.info("Optimized decomposition created {} MultiBlocks from {} blocks", (Object)result.size(), (Object)validBlocks.size());
        return result;
    }

    private List<CubeDecomposition> decomposeIntoSolidCubes(List<class_2338> blocks) {
        if (blocks.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<class_2338> blockSet = new HashSet<class_2338>(blocks);
        class_2338 min = this.findMinBounds(blocks);
        class_2338 max = this.findMaxBounds(blocks);
        HashSet<class_2338> covered = new HashSet<class_2338>();
        ArrayList<CubeDecomposition> cubes = new ArrayList<CubeDecomposition>();
        PriorityQueue<CubeCandidate> candidateQueue = new PriorityQueue<CubeCandidate>((a, b) -> Integer.compare(b.volume, a.volume));
        this.generateCubeCandidates(blockSet, min, max, candidateQueue);
        while (!candidateQueue.isEmpty() && covered.size() < blocks.size()) {
            CubeCandidate candidate = candidateQueue.poll();
            if (!this.isCubeAvailable(blockSet, covered, candidate)) continue;
            CubeDecomposition cube = new CubeDecomposition(candidate.start, candidate.size, candidate.size, candidate.size);
            cubes.add(cube);
            this.markCubeAsCovered(covered, candidate);
            LOGGER.trace("Selected cube: {} size {} (volume: {})", new Object[]{candidate.start, candidate.size, candidate.volume});
        }
        this.coverRemainingBlocks(blocks, covered, cubes);
        return cubes;
    }

    private void generateCubeCandidates(Set<class_2338> blockSet, class_2338 min, class_2338 max, PriorityQueue<CubeCandidate> queue) {
        int maxPossibleSize;
        for (int size = maxPossibleSize = Math.min(max.method_10263() - min.method_10263() + 1, Math.min(max.method_10264() - min.method_10264() + 1, max.method_10260() - min.method_10260() + 1)); size >= 1; --size) {
            for (int x = min.method_10263(); x <= max.method_10263() - size + 1; ++x) {
                for (int y = min.method_10264(); y <= max.method_10264() - size + 1; ++y) {
                    for (int z = min.method_10260(); z <= max.method_10260() - size + 1; ++z) {
                        class_2338 start = new class_2338(x, y, z);
                        if (!this.isSolidCube(blockSet, start, size)) continue;
                        queue.offer(new CubeCandidate(start, size));
                    }
                }
            }
        }
    }

    private boolean isSolidCube(Set<class_2338> blockSet, class_2338 start, int size) {
        for (int dx = 0; dx < size; ++dx) {
            for (int dy = 0; dy < size; ++dy) {
                for (int dz = 0; dz < size; ++dz) {
                    class_2338 pos = new class_2338(start.method_10263() + dx, start.method_10264() + dy, start.method_10260() + dz);
                    if (blockSet.contains(pos)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isCubeAvailable(Set<class_2338> blockSet, Set<class_2338> covered, CubeCandidate candidate) {
        for (int dx = 0; dx < candidate.size; ++dx) {
            for (int dy = 0; dy < candidate.size; ++dy) {
                for (int dz = 0; dz < candidate.size; ++dz) {
                    class_2338 pos = new class_2338(candidate.start.method_10263() + dx, candidate.start.method_10264() + dy, candidate.start.method_10260() + dz);
                    if (!covered.contains(pos)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void markCubeAsCovered(Set<class_2338> covered, CubeCandidate candidate) {
        for (int dx = 0; dx < candidate.size; ++dx) {
            for (int dy = 0; dy < candidate.size; ++dy) {
                for (int dz = 0; dz < candidate.size; ++dz) {
                    class_2338 pos = new class_2338(candidate.start.method_10263() + dx, candidate.start.method_10264() + dy, candidate.start.method_10260() + dz);
                    covered.add(pos);
                }
            }
        }
    }

    private void coverRemainingBlocks(List<class_2338> blocks, Set<class_2338> covered, List<CubeDecomposition> cubes) {
        for (class_2338 block : blocks) {
            if (covered.contains(block)) continue;
            cubes.add(new CubeDecomposition(block, 1, 1, 1));
            covered.add(block);
            LOGGER.trace("Added 1x1x1 cube for remaining block: {}", (Object)block);
        }
    }

    private MultiBlock createMultiBlockFromCube(CubeDecomposition cube) {
        try {
            return MultiBlock.builder().world(this.world).baseBlock(this.baseBlock).range(cube.start, cube.width, cube.height, cube.depth).build();
        }
        catch (Exception e) {
            LOGGER.error("Failed to create MultiBlock from cube {}: {}", (Object)cube.start, (Object)e.getMessage());
            return null;
        }
    }

    private class_2338 findMinBounds(List<class_2338> blocks) {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        for (class_2338 pos : blocks) {
            minX = Math.min(minX, pos.method_10263());
            minY = Math.min(minY, pos.method_10264());
            minZ = Math.min(minZ, pos.method_10260());
        }
        return new class_2338(minX, minY, minZ);
    }

    private class_2338 findMaxBounds(List<class_2338> blocks) {
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (class_2338 pos : blocks) {
            maxX = Math.max(maxX, pos.method_10263());
            maxY = Math.max(maxY, pos.method_10264());
            maxZ = Math.max(maxZ, pos.method_10260());
        }
        return new class_2338(maxX, maxY, maxZ);
    }

    public List<MultiBlock> splitAlongPlane(char axis, int splitPosition) {
        if (this.disposed) {
            LOGGER.warn("Attempted to split disposed MultiBlock at {}", (Object)this.masterPos);
            return Collections.emptyList();
        }
        if (splitPosition <= 0 || splitPosition >= this.getAxisSize(axis)) {
            LOGGER.error("Invalid split position {} for axis {}", (Object)splitPosition, (Object)Character.valueOf(axis));
            return Collections.emptyList();
        }
        try {
            MultiBlock secondPart;
            MultiBlock firstPart;
            class_2338 start = this.range.getStart();
            int width = this.range.getWidth();
            int height = this.range.getHeight();
            int depth = this.range.getDepth();
            switch (axis) {
                case 'x': {
                    firstPart = this.createSubMultiBlock(start, splitPosition, height, depth);
                    class_2338 secondStart = new class_2338(start.method_10263() + splitPosition, start.method_10264(), start.method_10260());
                    secondPart = this.createSubMultiBlock(secondStart, width - splitPosition, height, depth);
                    break;
                }
                case 'y': {
                    firstPart = this.createSubMultiBlock(start, width, splitPosition, depth);
                    class_2338 secondStartY = new class_2338(start.method_10263(), start.method_10264() + splitPosition, start.method_10260());
                    secondPart = this.createSubMultiBlock(secondStartY, width, height - splitPosition, depth);
                    break;
                }
                case 'z': {
                    firstPart = this.createSubMultiBlock(start, width, height, splitPosition);
                    class_2338 secondStartZ = new class_2338(start.method_10263(), start.method_10264(), start.method_10260() + splitPosition);
                    secondPart = this.createSubMultiBlock(secondStartZ, width, height, depth - splitPosition);
                    break;
                }
                default: {
                    LOGGER.error("Invalid axis: {}", (Object)Character.valueOf(axis));
                    return Collections.emptyList();
                }
            }
            if (firstPart != null && secondPart != null) {
                this.dispose();
                LOGGER.info("Split MultiBlock at {} along {} axis at position {}", new Object[]{this.masterPos, Character.valueOf(axis), splitPosition});
                return Arrays.asList(firstPart, secondPart);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error splitting MultiBlock: {}", (Object)e.getMessage());
        }
        return Collections.emptyList();
    }

    private int getAxisSize(char axis) {
        return switch (axis) {
            case 'x' -> this.range.getWidth();
            case 'y' -> this.range.getHeight();
            case 'z' -> this.range.getDepth();
            default -> 0;
        };
    }

    private MultiBlock createSubMultiBlock(class_2338 start, int width, int height, int depth) {
        if (width <= 0 || height <= 0 || depth <= 0) {
            return null;
        }
        try {
            return MultiBlock.builder().world(this.world).baseBlock(this.baseBlock).range(start, width, height, depth).build();
        }
        catch (Exception e) {
            LOGGER.error("Failed to create sub MultiBlock: {}", (Object)e.getMessage());
            return null;
        }
    }

    public boolean checkIntegrity() {
        if (this.disposed) {
            LOGGER.warn("Attempted to check integrity of disposed MultiBlock at {}", (Object)this.masterPos);
            return false;
        }
        class_2338 start = this.range.getStart();
        class_2338 end = this.getEndPos();
        LOGGER.debug("Checking integrity of MultiBlock at {} to {}", (Object)start, (Object)end);
        int invalidCount = 0;
        for (int x = start.method_10263(); x <= end.method_10263(); ++x) {
            for (int y = start.method_10264(); y <= end.method_10264(); ++y) {
                for (int z = start.method_10260(); z <= end.method_10260(); ++z) {
                    class_2338 pos = new class_2338(x, y, z);
                    class_2248 block = this.world.method_8320(pos).method_26204();
                    if (block == this.baseBlock) continue;
                    ++invalidCount;
                    if (!LOGGER.isTraceEnabled()) continue;
                    LOGGER.trace("Found invalid block at {}: expected {}, found {}", new Object[]{pos, this.baseBlock, block});
                }
            }
        }
        if (invalidCount > 0) {
            LOGGER.warn("MultiBlock at {} has {} invalid blocks out of {}", new Object[]{this.masterPos, invalidCount, this.getVolume()});
            return false;
        }
        LOGGER.debug("MultiBlock at {} integrity check passed", (Object)this.masterPos);
        return true;
    }

    public class_2338 getWorldPos(int relativeX, int relativeY, int relativeZ) {
        if (this.disposed) {
            throw new IllegalStateException("MultiBlock at " + String.valueOf(this.masterPos) + " has been disposed");
        }
        if (relativeX < 0 || relativeX >= this.range.getWidth() || relativeY < 0 || relativeY >= this.range.getHeight() || relativeZ < 0 || relativeZ >= this.range.getDepth()) {
            String errorMsg = String.format("Relative coordinates (%d, %d, %d) out of range. Valid range: [0-%d, 0-%d, 0-%d]", relativeX, relativeY, relativeZ, this.range.getWidth() - 1, this.range.getHeight() - 1, this.range.getDepth() - 1);
            LOGGER.error(errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        return new class_2338(this.range.getStart().method_10263() + relativeX, this.range.getStart().method_10264() + relativeY, this.range.getStart().method_10260() + relativeZ);
    }

    public class_2338 getWorldPos(class_2338 relativePos) {
        return this.getWorldPos(relativePos.method_10263(), relativePos.method_10264(), relativePos.method_10260());
    }

    public MultiBlock combineWith(@NotNull MultiBlock other) {
        if (this.disposed) {
            throw new IllegalStateException("This MultiBlock at " + String.valueOf(this.masterPos) + " has been disposed");
        }
        if (other.disposed) {
            throw new IllegalStateException("Other MultiBlock at " + String.valueOf(other.masterPos) + " has been disposed");
        }
        LOGGER.debug("Attempting to combine MultiBlock at {} with MultiBlock at {}", (Object)this.masterPos, (Object)other.masterPos);
        return MultiBlock.combine(this, other);
    }

    public static MultiBlock combine(@NotNull MultiBlock first, @NotNull MultiBlock second) {
        MultiBlock combined;
        if (first.disposed || second.disposed) {
            throw new IllegalStateException("Cannot combine disposed MultiBlocks");
        }
        if (first.world != second.world) {
            String errorMsg = "MultiBlocks must be in the same world";
            LOGGER.error(errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        if (first.baseBlock != second.baseBlock) {
            String errorMsg = "MultiBlocks must have the same base block: " + String.valueOf(first.baseBlock) + " vs " + String.valueOf(second.baseBlock);
            LOGGER.error(errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        PatternRange firstRange = first.range;
        PatternRange secondRange = second.range;
        class_2338 newStart = new class_2338(Math.min(firstRange.getStart().method_10263(), secondRange.getStart().method_10263()), Math.min(firstRange.getStart().method_10264(), secondRange.getStart().method_10264()), Math.min(firstRange.getStart().method_10260(), secondRange.getStart().method_10260()));
        class_2338 firstEnd = first.getEndPos();
        class_2338 secondEnd = second.getEndPos();
        class_2338 newEnd = new class_2338(Math.max(firstEnd.method_10263(), secondEnd.method_10263()), Math.max(firstEnd.method_10264(), secondEnd.method_10264()), Math.max(firstEnd.method_10260(), secondEnd.method_10260()));
        int newWidth = newEnd.method_10263() - newStart.method_10263() + 1;
        int newHeight = newEnd.method_10264() - newStart.method_10264() + 1;
        int newDepth = newEnd.method_10260() - newStart.method_10260() + 1;
        if (newWidth > 10 || newHeight > 10 || newDepth > 10) {
            String errorMsg = String.format("Combined MultiBlock size %dx%dx%d would exceed maximum allowed size %dx%dx%d", newWidth, newHeight, newDepth, 10, 10, 10);
            LOGGER.error(errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        MergeDirection direction = MultiBlock.findMergeDirection(firstRange, secondRange);
        if (direction == null) {
            String debugMsg = String.format("MultiBlocks are not adjacent or overlapping in a valid way. First: %s, Second: %s", firstRange, secondRange);
            LOGGER.debug(debugMsg);
            return null;
        }
        LOGGER.debug("Merging MultiBlocks in direction: {}", (Object)direction);
        PatternRange newRange = new PatternRange(newStart, newWidth, newHeight, newDepth);
        first.dispose();
        second.dispose();
        try {
            combined = new MultiBlock(first.world, first.baseBlock, newRange);
            LOGGER.info("Successfully combined MultiBlocks at {} and {} into new MultiBlock at {}", new Object[]{first.masterPos, second.masterPos, combined.masterPos});
        }
        catch (Exception e) {
            LOGGER.error("Failed to create combined MultiBlock: {}", (Object)e.getMessage());
            return null;
        }
        return combined;
    }

    @Override
    public void close() {
        this.dispose();
    }

    public void dispose() {
        if (!this.disposed) {
            LOGGER.debug("Disposing MultiBlock at {}", (Object)this.masterPos);
            MultiBlockManager.unregisterMultiBlock(this);
            this.disposed = true;
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public class_2338 getEndPos() {
        if (this.disposed) {
            throw new IllegalStateException("MultiBlock at " + String.valueOf(this.masterPos) + " has been disposed");
        }
        return this.range.getEnd();
    }

    public int getVolume() {
        return this.disposed ? 0 : this.range.getVolume();
    }

    public class_4538 getWorld() {
        if (this.disposed) {
            throw new IllegalStateException("MultiBlock at " + String.valueOf(this.masterPos) + " has been disposed");
        }
        return this.world;
    }

    public class_2248 getBaseBlock() {
        if (this.disposed) {
            throw new IllegalStateException("MultiBlock at " + String.valueOf(this.masterPos) + " has been disposed");
        }
        return this.baseBlock;
    }

    public PatternRange getRange() {
        if (this.disposed) {
            throw new IllegalStateException("MultiBlock at " + String.valueOf(this.masterPos) + " has been disposed");
        }
        return this.range;
    }

    public class_2338 getMasterPos() {
        return this.masterPos;
    }

    public MultiBlockReference createReference(class_2338 relativePos) {
        return ServerMultiBlockReference.fromRelativePos(this, relativePos);
    }

    public MultiBlockReference createReference(int relativeX, int relativeY, int relativeZ) {
        return this.createReference(new class_2338(relativeX, relativeY, relativeZ));
    }

    @Nullable
    public MultiBlockReference createReferenceFromWorldPos(class_2338 worldPos) {
        return ServerMultiBlockReference.fromWorldPos(this, worldPos);
    }

    public boolean containsWorldPos(class_2338 worldPos) {
        return this.getRange().contains(worldPos);
    }

    @Nullable
    public class_2338 getRelativePosFromWorld(class_2338 worldPos) {
        if (!this.containsWorldPos(worldPos)) {
            return null;
        }
        return new class_2338(worldPos.method_10263() - this.getMasterPos().method_10263(), worldPos.method_10264() - this.getMasterPos().method_10264(), worldPos.method_10260() - this.getMasterPos().method_10260());
    }

    private static MergeDirection findMergeDirection(PatternRange first, PatternRange second) {
        class_2338 firstEnd = first.getEnd();
        class_2338 secondEnd = second.getEnd();
        if (first.getStart().method_10264() == second.getStart().method_10264() && firstEnd.method_10264() == secondEnd.method_10264() && first.getStart().method_10260() == second.getStart().method_10260() && firstEnd.method_10260() == secondEnd.method_10260()) {
            if (firstEnd.method_10263() + 1 == second.getStart().method_10263()) {
                return MergeDirection.EAST_WEST;
            }
            if (secondEnd.method_10263() + 1 == first.getStart().method_10263()) {
                return MergeDirection.WEST_EAST;
            }
            if (first.getStart().method_10263() <= secondEnd.method_10263() && firstEnd.method_10263() >= second.getStart().method_10263()) {
                return MergeDirection.OVERLAP_X;
            }
        }
        if (first.getStart().method_10263() == second.getStart().method_10263() && firstEnd.method_10263() == secondEnd.method_10263() && first.getStart().method_10260() == second.getStart().method_10260() && firstEnd.method_10260() == secondEnd.method_10260()) {
            if (firstEnd.method_10264() + 1 == second.getStart().method_10264()) {
                return MergeDirection.UP_DOWN;
            }
            if (secondEnd.method_10264() + 1 == first.getStart().method_10264()) {
                return MergeDirection.DOWN_UP;
            }
            if (first.getStart().method_10264() <= secondEnd.method_10264() && firstEnd.method_10264() >= second.getStart().method_10264()) {
                return MergeDirection.OVERLAP_Y;
            }
        }
        if (first.getStart().method_10263() == second.getStart().method_10263() && firstEnd.method_10263() == secondEnd.method_10263() && first.getStart().method_10264() == second.getStart().method_10264() && firstEnd.method_10264() == secondEnd.method_10264()) {
            if (firstEnd.method_10260() + 1 == second.getStart().method_10260()) {
                return MergeDirection.SOUTH_NORTH;
            }
            if (secondEnd.method_10260() + 1 == first.getStart().method_10260()) {
                return MergeDirection.NORTH_SOUTH;
            }
            if (first.getStart().method_10260() <= secondEnd.method_10260() && firstEnd.method_10260() >= second.getStart().method_10260()) {
                return MergeDirection.OVERLAP_Z;
            }
        }
        return null;
    }

    public static final class PatternRange {
        private final class_2338 start;
        private final int width;
        private final int height;
        private final int depth;
        private final class_2338 end;
        private final int volume;

        public PatternRange(class_2338 start, int width, int height, int depth) {
            if (width <= 0 || height <= 0 || depth <= 0) {
                throw new IllegalArgumentException("Dimensions must be positive: width=" + width + ", height=" + height + ", depth=" + depth);
            }
            this.start = start;
            this.width = width;
            this.height = height;
            this.depth = depth;
            this.end = new class_2338(start.method_10263() + width - 1, start.method_10264() + height - 1, start.method_10260() + depth - 1);
            this.volume = width * height * depth;
        }

        public PatternRange(class_2338 start, int width, int height) {
            this(start, width, height, 1);
        }

        public PatternRange(class_2338 start) {
            this(start, 1, 1);
        }

        public boolean isSquare() {
            return this.width == this.height;
        }

        public boolean isCubes() {
            return this.isSquare() && this.width == this.depth;
        }

        public boolean contains(class_2338 worldPos) {
            return worldPos.method_10263() >= this.start.method_10263() && worldPos.method_10263() <= this.end.method_10263() && worldPos.method_10264() >= this.start.method_10264() && worldPos.method_10264() <= this.end.method_10264() && worldPos.method_10260() >= this.start.method_10260() && worldPos.method_10260() <= this.end.method_10260();
        }

        public class_2338 getStart() {
            return this.start;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getDepth() {
            return this.depth;
        }

        public class_2338 getEnd() {
            return this.end;
        }

        public int getVolume() {
            return this.volume;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PatternRange that = (PatternRange)obj;
            return this.width == that.width && this.height == that.height && this.depth == that.depth && Objects.equals(this.start, that.start);
        }

        public int hashCode() {
            return Objects.hash(this.start, this.width, this.height, this.depth);
        }

        public String toString() {
            return String.format("PatternRange{start=%s, width=%d, height=%d, depth=%d}", this.start, this.width, this.height, this.depth);
        }
    }

    public static class Builder {
        private class_4538 world;
        private class_2248 baseBlock;
        private PatternRange range;

        public Builder world(class_4538 world) {
            this.world = world;
            return this;
        }

        public Builder baseBlock(class_2248 baseBlock) {
            this.baseBlock = baseBlock;
            return this;
        }

        public Builder range(PatternRange range) {
            this.range = range;
            return this;
        }

        public Builder range(class_2338 start, int width, int height, int depth) {
            if (width > 10 || height > 10 || depth > 10) {
                throw new IllegalArgumentException(String.format("Requested size %dx%dx%d exceeds maximum allowed size %dx%dx%d", width, height, depth, 10, 10, 10));
            }
            this.range = new PatternRange(start, width, height, depth);
            return this;
        }

        public MultiBlock build() {
            return new MultiBlock(this.world, this.baseBlock, this.range);
        }
    }

    private static class CubeDecomposition {
        public final class_2338 start;
        public final int width;
        public final int height;
        public final int depth;
        public final int volume;

        public CubeDecomposition(class_2338 start, int width, int height, int depth) {
            this.start = start;
            this.width = width;
            this.height = height;
            this.depth = depth;
            this.volume = width * height * depth;
        }

        public boolean isValid() {
            return this.width > 0 && this.height > 0 && this.depth > 0;
        }
    }

    private static class CubeCandidate {
        public final class_2338 start;
        public final int size;
        public final int volume;

        public CubeCandidate(class_2338 start, int size) {
            this.start = start;
            this.size = size;
            this.volume = size * size * size;
        }
    }

    private static enum MergeDirection {
        EAST_WEST,
        WEST_EAST,
        UP_DOWN,
        DOWN_UP,
        SOUTH_NORTH,
        NORTH_SOUTH,
        OVERLAP_X,
        OVERLAP_Y,
        OVERLAP_Z;

    }
}

