/*
 * Decompiled with CFR 0.152.
 */
package org.foodcraft.block.multi;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_4538;
import org.foodcraft.FoodCraft;
import org.foodcraft.block.entity.HeatResistantSlateBlockEntity;
import org.foodcraft.block.multi.MultiBlock;
import org.foodcraft.block.multi.MultiBlockManager;
import org.foodcraft.block.multi.ServerMultiBlockReference;
import org.slf4j.Logger;

public class MultiBlockHelper {
    private static final Logger LOGGER = FoodCraft.LOGGER;

    public static void onCoreBlockPlaced(class_1937 world, class_2338 pos, class_2248 coreBlock) {
        LOGGER.debug("Core block placed at {}", (Object)pos);
        MultiBlock existing = MultiBlockManager.findMultiBlock((class_4538)world, pos);
        if (existing != null && !existing.isDisposed()) {
            LOGGER.debug("Found existing MultiBlock at {}, checking integrity", (Object)pos);
            List<MultiBlock> newBlocks = existing.checkAndSplitIntegrity();
            MultiBlockHelper.updateBlockEntityReferences(world, newBlocks);
            LOGGER.info("After integrity check, created {} new MultiBlocks", (Object)newBlocks.size());
            return;
        }
        MultiBlock newMultiBlock = MultiBlockHelper.createSingleBlockMultiBlock(world, pos, coreBlock);
        if (newMultiBlock == null) {
            LOGGER.error("Failed to create single block MultiBlock at {}", (Object)pos);
            return;
        }
        MultiBlockHelper.updateBlockEntityReference(world, pos, newMultiBlock);
        MultiBlockHelper.performMultiRoundMerging(newMultiBlock);
    }

    public static void onCoreBlockBroken(class_1937 world, class_2338 pos, class_2248 coreBlock) {
        LOGGER.debug("Core block broken at {}", (Object)pos);
        MultiBlock multiBlock = MultiBlockManager.findMultiBlock((class_4538)world, pos);
        if (multiBlock == null || multiBlock.isDisposed()) {
            LOGGER.debug("No MultiBlock found at {}", (Object)pos);
            return;
        }
        LOGGER.info("Breaking block at {} in MultiBlock {}, checking integrity", (Object)pos, (Object)multiBlock.getMasterPos());
        List<MultiBlock> newBlocks = multiBlock.checkAndSplitIntegrity();
        MultiBlockHelper.updateBlockEntityReferences(world, newBlocks);
        LOGGER.info("After breaking, created {} new MultiBlocks", (Object)newBlocks.size());
        for (MultiBlock newBlock : newBlocks) {
            MultiBlockHelper.performMultiRoundMerging(newBlock);
        }
    }

    public static void onNeighborUpdate(class_1937 world, class_2338 pos, class_2248 coreBlock) {
        LOGGER.debug("Neighbor update for core block at {}", (Object)pos);
        MultiBlock multiBlock = MultiBlockManager.findMultiBlock((class_4538)world, pos);
        if (multiBlock == null || multiBlock.isDisposed()) {
            LOGGER.debug("No MultiBlock found at {} during neighbor update", (Object)pos);
            return;
        }
        if (!multiBlock.checkIntegrity()) {
            LOGGER.info("MultiBlock at {} lost integrity due to neighbor update, splitting...", (Object)multiBlock.getMasterPos());
            List<MultiBlock> newBlocks = multiBlock.checkAndSplitIntegrity();
            MultiBlockHelper.updateBlockEntityReferences(world, newBlocks);
            for (MultiBlock newBlock : newBlocks) {
                MultiBlockHelper.performMultiRoundMerging(newBlock);
            }
        }
    }

    public static void performMultiRoundMerging(MultiBlock initialBlock) {
        boolean mergedInThisRound;
        if (initialBlock.isDisposed()) {
            return;
        }
        MultiBlock current = initialBlock;
        int roundCount = 0;
        int MAX_ROUNDS = 10;
        do {
            mergedInThisRound = false;
            List<MultiBlock> neighbors = MultiBlockHelper.findAdjacentMultiBlocks(current);
            LOGGER.debug("Round {}: Found {} adjacent MultiBlocks to merge with", (Object)(++roundCount), (Object)neighbors.size());
            for (MultiBlock neighbor : neighbors) {
                if (neighbor.isDisposed() || neighbor == current) continue;
                try {
                    LOGGER.debug("Attempting to merge MultiBlock at {} with neighbor at {}", (Object)current.getMasterPos(), (Object)neighbor.getMasterPos());
                    MultiBlock merged = MultiBlock.combine(current, neighbor);
                    if (merged != null) {
                        MultiBlockHelper.updateBlockEntityReferences((class_1937)merged.getWorld(), List.of(merged));
                        current = merged;
                        mergedInThisRound = true;
                        LOGGER.info("Successfully merged MultiBlocks into new MultiBlock at {}", (Object)merged.getMasterPos());
                        break;
                    }
                    LOGGER.debug("Merge operation returned null, merge failed");
                }
                catch (IllegalArgumentException e) {
                    LOGGER.debug("Cannot merge MultiBlocks: {}", (Object)e.getMessage());
                }
                catch (Exception e) {
                    LOGGER.error("Unexpected error during merge: {}", (Object)e.getMessage());
                    break;
                }
            }
            if (roundCount < 10) continue;
            LOGGER.warn("Reached maximum merge rounds for MultiBlock at {}", (Object)current.getMasterPos());
            break;
        } while (mergedInThisRound);
        LOGGER.debug("Completed merging after {} rounds for MultiBlock at {}", (Object)roundCount, (Object)current.getMasterPos());
    }

    public static void updateBlockEntityReferences(class_1937 world, List<MultiBlock> multiBlocks) {
        for (MultiBlock multiBlock : multiBlocks) {
            if (multiBlock.isDisposed()) continue;
            MultiBlockHelper.updateBlockEntityReferencesForMultiBlock(world, multiBlock);
        }
    }

    public static void updateBlockEntityReferencesForMultiBlock(class_1937 world, MultiBlock multiBlock) {
        MultiBlock.PatternRange range = multiBlock.getRange();
        class_2338 start = range.getStart();
        class_2338 end = multiBlock.getEndPos();
        for (int x = start.method_10263(); x <= end.method_10263(); ++x) {
            for (int y = start.method_10264(); y <= end.method_10264(); ++y) {
                for (int z = start.method_10260(); z <= end.method_10260(); ++z) {
                    class_2338 pos = new class_2338(x, y, z);
                    MultiBlockHelper.updateBlockEntityReference(world, pos, multiBlock);
                }
            }
        }
        LOGGER.debug("Updated all block entity references for MultiBlock at {}", (Object)multiBlock.getMasterPos());
    }

    public static void updateBlockEntityReference(class_1937 world, class_2338 pos, MultiBlock multiBlock) {
        if (world.field_9236) {
            return;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof HeatResistantSlateBlockEntity) {
            HeatResistantSlateBlockEntity slateEntity = (HeatResistantSlateBlockEntity)blockEntity;
            ServerMultiBlockReference newRef = ServerMultiBlockReference.fromWorldPos(multiBlock, pos);
            if (newRef != null) {
                slateEntity.setMultiBlockReference(newRef);
                LOGGER.debug("Updated MultiBlock reference for block entity at {}", (Object)pos);
            } else {
                LOGGER.warn("Failed to create MultiBlockReference for block entity at {}", (Object)pos);
            }
        }
    }

    private static MultiBlock createSingleBlockMultiBlock(class_1937 world, class_2338 pos, class_2248 coreBlock) {
        try {
            return MultiBlock.builder().world((class_4538)world).baseBlock(coreBlock).range(pos, 1, 1, 1).build();
        }
        catch (Exception e) {
            LOGGER.error("Failed to create single block MultiBlock at {}: {}", (Object)pos, (Object)e.getMessage());
            return null;
        }
    }

    private static List<MultiBlock> findAdjacentMultiBlocks(MultiBlock multiBlock) {
        ArrayList<MultiBlock> neighbors = new ArrayList<MultiBlock>();
        class_1937 world = (class_1937)multiBlock.getWorld();
        MultiBlock.PatternRange range = multiBlock.getRange();
        class_2338 start = range.getStart();
        class_2338 end = range.getEnd();
        class_2338 westFaceStart = start.method_10067();
        class_2338 westFaceEnd = new class_2338(start.method_10263() - 1, end.method_10264(), end.method_10260());
        MultiBlockHelper.checkDirection(neighbors, world, multiBlock, westFaceStart, westFaceEnd);
        class_2338 eastFaceStart = end.method_10078();
        class_2338 eastFaceEnd = new class_2338(end.method_10263() + 1, end.method_10264(), end.method_10260());
        MultiBlockHelper.checkDirection(neighbors, world, multiBlock, eastFaceStart, eastFaceEnd);
        class_2338 downFaceStart = start.method_10074();
        class_2338 downFaceEnd = new class_2338(end.method_10263(), start.method_10264() - 1, end.method_10260());
        MultiBlockHelper.checkDirection(neighbors, world, multiBlock, downFaceStart, downFaceEnd);
        class_2338 upFaceStart = end.method_10084();
        class_2338 upFaceEnd = new class_2338(end.method_10263(), end.method_10264() + 1, end.method_10260());
        MultiBlockHelper.checkDirection(neighbors, world, multiBlock, upFaceStart, upFaceEnd);
        class_2338 northFaceStart = start.method_10095();
        class_2338 northFaceEnd = new class_2338(end.method_10263(), end.method_10264(), start.method_10260() - 1);
        MultiBlockHelper.checkDirection(neighbors, world, multiBlock, northFaceStart, northFaceEnd);
        class_2338 southFaceStart = end.method_10072();
        class_2338 southFaceEnd = new class_2338(end.method_10263(), end.method_10264(), end.method_10260() + 1);
        MultiBlockHelper.checkDirection(neighbors, world, multiBlock, southFaceStart, southFaceEnd);
        return neighbors;
    }

    private static void checkDirection(List<MultiBlock> neighbors, class_1937 world, MultiBlock multiBlock, class_2338 faceStart, class_2338 faceEnd) {
        for (int x = faceStart.method_10263(); x <= faceEnd.method_10263(); ++x) {
            for (int y = faceStart.method_10264(); y <= faceEnd.method_10264(); ++y) {
                for (int z = faceStart.method_10260(); z <= faceEnd.method_10260(); ++z) {
                    class_2338 checkPos = new class_2338(x, y, z);
                    MultiBlock neighbor = MultiBlockManager.findMultiBlock((class_4538)world, checkPos);
                    if (neighbor == null || neighbor.isDisposed() || neighbor.getBaseBlock() != multiBlock.getBaseBlock() || neighbors.contains(neighbor)) continue;
                    neighbors.add(neighbor);
                }
            }
        }
    }

    public static void forceUpdateReferencesInArea(class_1937 world, class_2338 center, int radius) {
        LOGGER.info("Forcing update of MultiBlock references in area around {}", (Object)center);
        ArrayList<class_2338> coreBlocks = new ArrayList<class_2338>();
        for (int x = center.method_10263() - radius; x <= center.method_10263() + radius; ++x) {
            for (int y = center.method_10264() - radius; y <= center.method_10264() + radius; ++y) {
                for (int z = center.method_10260() - radius; z <= center.method_10260() + radius; ++z) {
                    class_2338 pos = new class_2338(x, y, z);
                    class_2586 blockEntity = world.method_8321(pos);
                    if (!(blockEntity instanceof HeatResistantSlateBlockEntity)) continue;
                    coreBlocks.add(pos);
                }
            }
        }
        LOGGER.debug("Found {} core blocks in area", (Object)coreBlocks.size());
        for (class_2338 pos : coreBlocks) {
            MultiBlock multiBlock = MultiBlockManager.findMultiBlock((class_4538)world, pos);
            if (multiBlock != null && !multiBlock.isDisposed()) {
                MultiBlockHelper.updateBlockEntityReference(world, pos, multiBlock);
                continue;
            }
            class_2586 blockEntity = world.method_8321(pos);
            if (!(blockEntity instanceof HeatResistantSlateBlockEntity)) continue;
            ((HeatResistantSlateBlockEntity)blockEntity).setMultiBlockReference(null);
            LOGGER.debug("Cleared MultiBlock reference at {}", (Object)pos);
        }
        LOGGER.info("Completed forced update of MultiBlock references");
    }
}

