/*
 * Decompiled with CFR 0.152.
 */
package org.foodcraft.block.multi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.foodcraft.FoodCraft;
import org.foodcraft.block.multi.MultiBlock;
import org.foodcraft.block.multi.MultiBlockPersistentState;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class MultiBlockManager {
    private static final Logger LOGGER = FoodCraft.LOGGER;
    private static final Map<class_4538, Map<class_2338, MultiBlock>> multiBlockRegistry = new WeakHashMap<class_4538, Map<class_2338, MultiBlock>>();
    private static final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean registerMultiBlock(MultiBlock multiBlock) {
        if (multiBlock == null) {
            LOGGER.error("Attempted to register null MultiBlock");
            return false;
        }
        class_4538 class_45382 = multiBlock.getWorld();
        if (class_45382 instanceof class_1937) {
            class_1937 world = (class_1937)class_45382;
            if (world.field_9236) {
                LOGGER.error("Attempted to register MultiBlock on client world at {}", (Object)multiBlock.getMasterPos());
                multiBlock.dispose();
                return false;
            }
        }
        if (multiBlock.isDisposed()) {
            LOGGER.error("Attempted to register disposed MultiBlock at {}", (Object)multiBlock.getMasterPos());
            return false;
        }
        class_4538 worldView = multiBlock.getWorld();
        class_2338 masterPos = multiBlock.getMasterPos();
        Object object = lock;
        synchronized (object) {
            Map worldMap = multiBlockRegistry.computeIfAbsent(worldView, k -> new ConcurrentHashMap());
            if (worldMap.containsKey(masterPos)) {
                MultiBlock existing = (MultiBlock)worldMap.get(masterPos);
                if (!existing.isDisposed()) {
                    LOGGER.warn("Position {} in world {} is already occupied by MultiBlock with base block {}", new Object[]{masterPos, worldView, existing.getBaseBlock()});
                    return false;
                }
                worldMap.remove(masterPos);
                LOGGER.debug("Cleaned up disposed MultiBlock at {}", (Object)masterPos);
            }
            worldMap.put(masterPos, multiBlock);
            LOGGER.debug("Registered MultiBlock at {} in world", (Object)masterPos);
            if (worldView instanceof class_3218) {
                class_3218 serverWorld = (class_3218)worldView;
                MultiBlockPersistentState persistentState = MultiBlockPersistentState.getOrCreate(serverWorld);
                persistentState.addMultiBlock((class_1937)serverWorld, multiBlock);
                LOGGER.debug("Persisted MultiBlock at {} to world storage", (Object)masterPos);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unregisterMultiBlock(MultiBlock multiBlock) {
        if (multiBlock == null) {
            LOGGER.warn("Attempted to unregister null MultiBlock");
            return false;
        }
        class_4538 worldView = multiBlock.getWorld();
        class_2338 masterPos = multiBlock.getMasterPos();
        Object object = lock;
        synchronized (object) {
            Map<class_2338, MultiBlock> worldMap = multiBlockRegistry.get(worldView);
            if (worldMap == null) {
                LOGGER.debug("No MultiBlocks registered for world");
                return false;
            }
            MultiBlock registered = worldMap.get(masterPos);
            if (registered == multiBlock) {
                worldMap.remove(masterPos);
                LOGGER.debug("Unregistered MultiBlock at {} from world", (Object)masterPos);
                if (worldView instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)worldView;
                    MultiBlockPersistentState persistentState = MultiBlockPersistentState.getOrCreate(serverWorld);
                    persistentState.removeMultiBlock((class_1937)serverWorld, masterPos);
                    LOGGER.debug("Removed MultiBlock at {} from persistent storage", (Object)masterPos);
                }
                if (worldMap.isEmpty()) {
                    multiBlockRegistry.remove(worldView);
                    LOGGER.debug("Removed empty world mapping");
                }
                return true;
            }
            LOGGER.warn("MultiBlock at {} was not the registered instance", (Object)masterPos);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadWorldMultiBlocks(class_3218 world) {
        Object object = lock;
        synchronized (object) {
            MultiBlockPersistentState persistentState = MultiBlockPersistentState.getOrCreate(world);
            Collection<MultiBlockPersistentState.MultiBlockData> multiBlockDataList = persistentState.getMultiBlocksForWorld((class_1937)world);
            LOGGER.info("Loading {} MultiBlocks for world {}", (Object)multiBlockDataList.size(), (Object)world.method_27983().method_29177());
            int loadedCount = 0;
            for (MultiBlockPersistentState.MultiBlockData data : multiBlockDataList) {
                try {
                    MultiBlock multiBlock = MultiBlockManager.rebuildMultiBlockFromData(world, data);
                    if (multiBlock == null) continue;
                    Map worldMap = multiBlockRegistry.computeIfAbsent((class_4538)world, k -> new ConcurrentHashMap());
                    worldMap.put(data.masterPos(), multiBlock);
                    ++loadedCount;
                    LOGGER.debug("Reloaded MultiBlock at {}", (Object)data.masterPos());
                }
                catch (Exception e) {
                    LOGGER.error("Failed to reload MultiBlock at {}: {}", (Object)data.masterPos(), (Object)e.getMessage());
                }
            }
            LOGGER.info("Successfully reloaded {}/{} MultiBlocks for world {}", new Object[]{loadedCount, multiBlockDataList.size(), world.method_27983().method_29177()});
        }
    }

    private static MultiBlock rebuildMultiBlockFromData(class_3218 world, MultiBlockPersistentState.MultiBlockData data) {
        try {
            class_2960 blockId = new class_2960(data.baseBlockId());
            class_2248 baseBlock = (class_2248)class_7923.field_41175.method_10223(blockId);
            MultiBlock.PatternRange range = new MultiBlock.PatternRange(data.start(), data.width(), data.height(), data.depth());
            return MultiBlock.builder().world((class_4538)world).baseBlock(baseBlock).range(range).build();
        }
        catch (Exception e) {
            LOGGER.error("Failed to rebuild MultiBlock from data: {}", (Object)e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onServerStopping(MinecraftServer server) {
        Object object = lock;
        synchronized (object) {
            LOGGER.info("Server stopping, clearing MultiBlock registry");
            multiBlockRegistry.clear();
        }
    }

    public static void backupMultiBlockData(MinecraftServer server) {
        for (class_3218 world : server.method_3738()) {
            MultiBlockPersistentState persistentState = MultiBlockPersistentState.getOrCreate(world);
            persistentState.saveToFile(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static MultiBlock findMultiBlock(class_4538 world, class_2338 pos) {
        Object object = lock;
        synchronized (object) {
            Map<class_2338, MultiBlock> worldMap = multiBlockRegistry.get(world);
            if (worldMap == null) {
                return null;
            }
            MultiBlock exactMatch = worldMap.get(pos);
            if (exactMatch != null && !exactMatch.isDisposed()) {
                return exactMatch;
            }
            for (MultiBlock multiBlock : worldMap.values()) {
                if (multiBlock.isDisposed() || !multiBlock.getRange().contains(pos)) continue;
                LOGGER.debug("Found MultiBlock at {} containing position {}", (Object)multiBlock.getMasterPos(), (Object)pos);
                return multiBlock;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRegistered(MultiBlock multiBlock) {
        if (multiBlock == null || multiBlock.isDisposed()) {
            return false;
        }
        Object object = lock;
        synchronized (object) {
            Map<class_2338, MultiBlock> worldMap = multiBlockRegistry.get(multiBlock.getWorld());
            if (worldMap == null) {
                return false;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
            MultiBlock registered = worldMap.get(multiBlock.getMasterPos());
            return registered == multiBlock && !registered.isDisposed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPositionOccupied(class_4538 world, class_2338 pos) {
        Object object = lock;
        synchronized (object) {
            Map<class_2338, MultiBlock> worldMap = multiBlockRegistry.get(world);
            if (worldMap == null) {
                return false;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
            MultiBlock multiBlock = worldMap.get(pos);
            return multiBlock != null && !multiBlock.isDisposed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<MultiBlock> getMultiBlocksInWorld(class_4538 world) {
        Object object = lock;
        synchronized (object) {
            Map<class_2338, MultiBlock> worldMap = multiBlockRegistry.get(world);
            if (worldMap == null) {
                return Collections.emptyList();
            }
            ArrayList<MultiBlock> validBlocks = new ArrayList<MultiBlock>();
            for (MultiBlock multiBlock : worldMap.values()) {
                if (multiBlock.isDisposed()) continue;
                validBlocks.add(multiBlock);
            }
            return Collections.unmodifiableCollection(validBlocks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<class_4538, Integer> getRegistryStats() {
        Object object = lock;
        synchronized (object) {
            HashMap<class_4538, Integer> stats = new HashMap<class_4538, Integer>();
            for (Map.Entry<class_4538, Map<class_2338, MultiBlock>> entry : multiBlockRegistry.entrySet()) {
                int count = (int)entry.getValue().values().stream().filter(mb -> !mb.isDisposed()).count();
                if (count <= 0) continue;
                stats.put(entry.getKey(), count);
            }
            return stats;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int clearWorld(class_4538 world) {
        Object object = lock;
        synchronized (object) {
            Map<class_2338, MultiBlock> worldMap = multiBlockRegistry.remove(world);
            if (worldMap != null) {
                for (MultiBlock multiBlock : worldMap.values()) {
                    try {
                        multiBlock.dispose();
                    }
                    catch (Exception e) {
                        LOGGER.error("Error disposing MultiBlock at {}", (Object)multiBlock.getMasterPos(), (Object)e);
                    }
                }
                int count = worldMap.size();
                LOGGER.info("Cleared {} MultiBlocks from world", (Object)count);
                return count;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAll() {
        Object object = lock;
        synchronized (object) {
            int totalCount = 0;
            for (Map<class_2338, MultiBlock> worldMap : multiBlockRegistry.values()) {
                for (MultiBlock multiBlock : worldMap.values()) {
                    try {
                        multiBlock.dispose();
                    }
                    catch (Exception e) {
                        LOGGER.error("Error disposing MultiBlock at {}", (Object)multiBlock.getMasterPos(), (Object)e);
                    }
                }
                totalCount += worldMap.size();
            }
            multiBlockRegistry.clear();
            LOGGER.info("Cleared all {} MultiBlocks from registry", (Object)totalCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performCleanup() {
        Object object = lock;
        synchronized (object) {
            Iterator<Map.Entry<class_4538, Map<class_2338, MultiBlock>>> worldIterator = multiBlockRegistry.entrySet().iterator();
            int removedCount = 0;
            while (worldIterator.hasNext()) {
                Map.Entry<class_4538, Map<class_2338, MultiBlock>> worldEntry = worldIterator.next();
                Map<class_2338, MultiBlock> worldMap = worldEntry.getValue();
                Iterator<Map.Entry<class_2338, MultiBlock>> blockIterator = worldMap.entrySet().iterator();
                while (blockIterator.hasNext()) {
                    Map.Entry<class_2338, MultiBlock> blockEntry = blockIterator.next();
                    MultiBlock multiBlock = blockEntry.getValue();
                    if (!multiBlock.isDisposed()) continue;
                    blockIterator.remove();
                    ++removedCount;
                    LOGGER.debug("Cleaned up disposed MultiBlock at {}", (Object)blockEntry.getKey());
                }
                if (!worldMap.isEmpty()) continue;
                worldIterator.remove();
                LOGGER.debug("Removed empty world mapping");
            }
            if (removedCount > 0) {
                LOGGER.info("Cleanup removed {} disposed MultiBlocks", (Object)removedCount);
            }
        }
    }

    public static void withMultiBlock(class_4538 world, class_2248 baseBlock, MultiBlock.PatternRange range, Consumer<MultiBlock> action) {
        try (MultiBlock multiBlock = MultiBlock.builder().world(world).baseBlock(baseBlock).range(range).build();){
            action.accept(multiBlock);
        }
        catch (Exception e) {
            LOGGER.error("Error in withMultiBlock", (Throwable)e);
        }
    }
}

