/*
 * Decompiled with CFR 0.152.
 */
package org.foodcraft.block.multi;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.foodcraft.FoodCraft;
import org.foodcraft.block.multi.MultiBlock;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class MultiBlockPersistentState
extends class_18 {
    private static final Logger LOGGER = FoodCraft.LOGGER;
    private static final String PERSISTENT_ID = "multiblocks";
    private final Map<class_2960, Map<class_2338, MultiBlockData>> worldData = new ConcurrentHashMap<class_2960, Map<class_2338, MultiBlockData>>();

    public void addMultiBlock(@NotNull class_1937 world, @NotNull MultiBlock multiBlock) {
        class_2960 worldId = world.method_27983().method_29177();
        Map worldMap = this.worldData.computeIfAbsent(worldId, k -> new ConcurrentHashMap());
        MultiBlockData data = new MultiBlockData(multiBlock.getMasterPos(), multiBlock.getBaseBlock().method_40142().method_40237().method_29177().toString(), multiBlock.getRange().getStart(), multiBlock.getRange().getWidth(), multiBlock.getRange().getHeight(), multiBlock.getRange().getDepth());
        worldMap.put(multiBlock.getMasterPos(), data);
        this.method_80();
        LOGGER.debug("Added MultiBlock data to persistent storage: {}", (Object)multiBlock.getMasterPos());
    }

    public void removeMultiBlock(@NotNull class_1937 world, class_2338 masterPos) {
        class_2960 worldId = world.method_27983().method_29177();
        Map<class_2338, MultiBlockData> worldMap = this.worldData.get(worldId);
        if (worldMap != null) {
            worldMap.remove(masterPos);
            this.method_80();
            LOGGER.debug("Removed MultiBlock data from persistent storage: {}", (Object)masterPos);
        }
    }

    public Collection<MultiBlockData> getMultiBlocksForWorld(@NotNull class_1937 world) {
        class_2960 worldId = world.method_27983().method_29177();
        Map<class_2338, MultiBlockData> worldMap = this.worldData.get(worldId);
        return worldMap != null ? worldMap.values() : Collections.emptyList();
    }

    public void clearWorldData(@NotNull class_1937 world) {
        class_2960 worldId = world.method_27983().method_29177();
        this.worldData.remove(worldId);
        this.method_80();
        LOGGER.info("Cleared all MultiBlock data for world: {}", (Object)worldId);
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2499 worldsList = new class_2499();
        for (Map.Entry<class_2960, Map<class_2338, MultiBlockData>> worldEntry : this.worldData.entrySet()) {
            class_2487 worldNbt = new class_2487();
            worldNbt.method_10582("worldId", worldEntry.getKey().toString());
            class_2499 multiBlocksList = new class_2499();
            for (MultiBlockData data : worldEntry.getValue().values()) {
                multiBlocksList.add((Object)data.toNbt());
            }
            worldNbt.method_10566("multiBlocks", (class_2520)multiBlocksList);
            worldsList.add((Object)worldNbt);
        }
        nbt.method_10566("worlds", (class_2520)worldsList);
        LOGGER.info("Saved {} worlds with MultiBlock data to persistent storage", (Object)this.worldData.size());
        return nbt;
    }

    @NotNull
    public static MultiBlockPersistentState fromNbt(class_2487 nbt) {
        MultiBlockPersistentState state = new MultiBlockPersistentState();
        class_2499 worldsList = nbt.method_10554("worlds", 10);
        for (class_2520 worldElement : worldsList) {
            class_2487 worldNbt = (class_2487)worldElement;
            class_2960 worldId = new class_2960(worldNbt.method_10558("worldId"));
            ConcurrentHashMap<class_2338, MultiBlockData> worldMap = new ConcurrentHashMap<class_2338, MultiBlockData>();
            class_2499 multiBlocksList = worldNbt.method_10554("multiBlocks", 10);
            for (class_2520 blockElement : multiBlocksList) {
                class_2487 blockNbt = (class_2487)blockElement;
                try {
                    MultiBlockData data = MultiBlockData.fromNbt(blockNbt);
                    worldMap.put(data.masterPos, data);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load MultiBlock data from NBT: {}", (Object)e.getMessage());
                }
            }
            state.worldData.put(worldId, worldMap);
        }
        LOGGER.info("Loaded {} worlds with MultiBlock data from persistent storage", (Object)state.worldData.size());
        return state;
    }

    public static MultiBlockPersistentState getOrCreate(class_3218 world) {
        class_26 persistentStateManager = world.method_17983();
        return (MultiBlockPersistentState)persistentStateManager.method_17924(MultiBlockPersistentState::fromNbt, MultiBlockPersistentState::new, PERSISTENT_ID);
    }

    public void saveToFile(MinecraftServer server) {
        try {
            File worldDir = server.method_27050(class_5218.field_24188).toFile();
            File backupFile = new File(worldDir, "multiblocks_backup.dat");
            class_2487 nbt = this.method_75(new class_2487());
            class_2507.method_10630((class_2487)nbt, (File)backupFile);
            LOGGER.info("MultiBlock data backed up to: {}", (Object)backupFile.getAbsolutePath());
        }
        catch (IOException e) {
            LOGGER.error("Failed to backup MultiBlock data: {}", (Object)e.getMessage());
        }
    }

    public record MultiBlockData(class_2338 masterPos, String baseBlockId, class_2338 start, int width, int height, int depth) {
        @NotNull
        public class_2487 toNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_10566("masterPos", (class_2520)class_2512.method_10692((class_2338)this.masterPos));
            nbt.method_10582("baseBlockId", this.baseBlockId);
            nbt.method_10566("start", (class_2520)class_2512.method_10692((class_2338)this.start));
            nbt.method_10569("width", this.width);
            nbt.method_10569("height", this.height);
            nbt.method_10569("depth", this.depth);
            return nbt;
        }

        @NotNull
        public static MultiBlockData fromNbt(@NotNull class_2487 nbt) {
            class_2338 masterPos = class_2512.method_10691((class_2487)nbt.method_10562("masterPos"));
            String baseBlockId = nbt.method_10558("baseBlockId");
            class_2338 start = class_2512.method_10691((class_2487)nbt.method_10562("start"));
            int width = nbt.method_10550("width");
            int height = nbt.method_10550("height");
            int depth = nbt.method_10550("depth");
            return new MultiBlockData(masterPos, baseBlockId, start, width, height, depth);
        }
    }
}

