/*
 * Decompiled with CFR 0.152.
 */
package org.foodcraft.block.multi;

import java.util.Objects;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4538;
import net.minecraft.class_7923;
import org.foodcraft.FoodCraft;
import org.foodcraft.block.multi.MultiBlock;
import org.foodcraft.block.multi.MultiBlockManager;
import org.foodcraft.block.multi.MultiBlockReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ServerMultiBlockReference
implements MultiBlockReference {
    private static final Logger LOGGER = FoodCraft.LOGGER;
    private static final String MASTER_POS_KEY = "MasterPos";
    private static final String RELATIVE_POS_KEY = "RelativePos";
    private static final String BASE_BLOCK_KEY = "BaseBlock";
    private final MultiBlock multiBlock;
    private final class_2338 relativePos;
    private final class_2338 worldPos;

    public ServerMultiBlockReference(@NotNull MultiBlock multiBlock, @NotNull class_2338 relativePos) {
        this.multiBlock = Objects.requireNonNull(multiBlock, "MultiBlock cannot be null");
        this.relativePos = Objects.requireNonNull(relativePos, "Relative position cannot be null");
        this.worldPos = multiBlock.getWorldPos(relativePos);
        this.validateRelativePosition();
    }

    private void validateRelativePosition() {
        if (this.relativePos.method_10263() < 0 || this.relativePos.method_10263() >= this.multiBlock.getRange().getWidth() || this.relativePos.method_10264() < 0 || this.relativePos.method_10264() >= this.multiBlock.getRange().getHeight() || this.relativePos.method_10260() < 0 || this.relativePos.method_10260() >= this.multiBlock.getRange().getDepth()) {
            throw new IllegalArgumentException("Relative position " + String.valueOf(this.relativePos) + " is out of MultiBlock range " + String.valueOf(this.multiBlock.getRange()));
        }
    }

    @Nullable
    public static ServerMultiBlockReference fromWorldPos(MultiBlock multiBlock, class_2338 worldPos) {
        if (multiBlock == null || multiBlock.isDisposed()) {
            return null;
        }
        if (!multiBlock.getRange().contains(worldPos)) {
            LOGGER.warn("World position {} is not within MultiBlock range {}", (Object)worldPos, (Object)multiBlock.getRange());
            return null;
        }
        class_2338 masterPos = multiBlock.getMasterPos();
        class_2338 relativePos = new class_2338(worldPos.method_10263() - masterPos.method_10263(), worldPos.method_10264() - masterPos.method_10264(), worldPos.method_10260() - masterPos.method_10260());
        return new ServerMultiBlockReference(multiBlock, relativePos);
    }

    @Nullable
    public static MultiBlockReference fromWorldPos(class_4538 world, class_2338 worldPos) {
        MultiBlock multiBlock = MultiBlockManager.findMultiBlock(world, worldPos);
        if (multiBlock == null || multiBlock.isDisposed()) {
            return null;
        }
        class_2338 masterPos = multiBlock.getMasterPos();
        class_2338 relativePos = new class_2338(worldPos.method_10263() - masterPos.method_10263(), worldPos.method_10264() - masterPos.method_10264(), worldPos.method_10260() - masterPos.method_10260());
        try {
            return new ServerMultiBlockReference(multiBlock, relativePos);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("World position {} is not within MultiBlock range", (Object)worldPos);
            return null;
        }
    }

    public static MultiBlockReference fromRelativePos(MultiBlock multiBlock, class_2338 relativePos) {
        return new ServerMultiBlockReference(multiBlock, relativePos);
    }

    @Nullable
    public static ServerMultiBlockReference fromNbt(@NotNull class_4538 world, @NotNull class_2487 nbt) {
        try {
            class_2338 masterPos = class_2512.method_10691((class_2487)nbt.method_10562(MASTER_POS_KEY));
            class_2338 relativePos = class_2512.method_10691((class_2487)nbt.method_10562(RELATIVE_POS_KEY));
            String blockId = nbt.method_10558(BASE_BLOCK_KEY);
            class_2248 baseBlock = (class_2248)class_7923.field_41175.method_10223(new class_2960(blockId));
            MultiBlock multiBlock = MultiBlockManager.findMultiBlock(world, masterPos);
            if (multiBlock == null || multiBlock.isDisposed()) {
                LOGGER.warn("MultiBlock at {} not found or disposed during deserialization", (Object)masterPos);
                return null;
            }
            if (multiBlock.getBaseBlock() != baseBlock) {
                LOGGER.warn("Base block mismatch during deserialization. Expected: {}, Found: {}", (Object)baseBlock, (Object)multiBlock.getBaseBlock());
                return null;
            }
            ServerMultiBlockReference ref = new ServerMultiBlockReference(multiBlock, relativePos);
            LOGGER.debug("Deserialized MultiBlockReference: master={}, relative={}, block={}", new Object[]{masterPos, relativePos, baseBlock});
            return ref;
        }
        catch (Exception e) {
            LOGGER.error("Failed to deserialize MultiBlockReference from NBT: {}", (Object)e.getMessage());
            return null;
        }
    }

    @Override
    @NotNull
    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10566(MASTER_POS_KEY, (class_2520)class_2512.method_10692((class_2338)this.multiBlock.getMasterPos()));
        nbt.method_10566(RELATIVE_POS_KEY, (class_2520)class_2512.method_10692((class_2338)this.relativePos));
        nbt.method_10582(BASE_BLOCK_KEY, this.multiBlock.getBaseBlock().method_40142().method_40237().method_29177().toString());
        LOGGER.debug("Serialized ServerMultiBlockReference: master={}, relative={}, block={}", new Object[]{this.multiBlock.getMasterPos(), this.relativePos, this.multiBlock.getBaseBlock()});
        return nbt;
    }

    @Override
    public boolean matchesBlock(class_2248 block) {
        if (this.multiBlock.isDisposed()) {
            LOGGER.warn("Attempted to check block match with disposed MultiBlock");
            return false;
        }
        return this.multiBlock.getBaseBlock() == block;
    }

    @Override
    public boolean matchesBlockState(class_2680 blockState) {
        return this.matchesBlock(blockState.method_26204());
    }

    @Override
    public boolean matchesBlockEntity(class_2586 blockEntity) {
        if (blockEntity == null) {
            return false;
        }
        return this.matchesBlockState(blockEntity.method_11010());
    }

    @Override
    public boolean isMasterBlock() {
        return this.relativePos.method_10263() == 0 && this.relativePos.method_10264() == 0 && this.relativePos.method_10260() == 0;
    }

    @Override
    public class_2338 getMasterWorldPos() {
        return this.multiBlock.getMasterPos();
    }

    @Override
    public class_2338 getWorldPos() {
        return this.worldPos;
    }

    @Override
    public class_2338 getRelativePos() {
        return this.relativePos;
    }

    @Override
    public class_2248 getBaseBlock() {
        return this.multiBlock.getBaseBlock();
    }

    @Override
    public int getVolume() {
        return this.multiBlock.getVolume();
    }

    @Override
    public boolean containsWorldPos(class_2338 worldPos) {
        return this.multiBlock.getRange().contains(worldPos);
    }

    @Override
    public boolean checkIntegrity() {
        if (this.multiBlock.isDisposed()) {
            LOGGER.warn("Attempted to check integrity of disposed MultiBlock");
            return false;
        }
        return this.multiBlock.checkIntegrity();
    }

    @Override
    public boolean isDisposed() {
        return this.multiBlock.isDisposed();
    }

    @Override
    public void dispose() {
        LOGGER.debug("Disposed ServerMultiBlockReference at relative position {}", (Object)this.relativePos);
    }

    @Override
    public int getRelativeX() {
        return this.relativePos.method_10263();
    }

    @Override
    public int getRelativeY() {
        return this.relativePos.method_10264();
    }

    @Override
    public int getRelativeZ() {
        return this.relativePos.method_10260();
    }

    public MultiBlock getMultiBlock() {
        return this.multiBlock;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ServerMultiBlockReference that = (ServerMultiBlockReference)obj;
        return Objects.equals(this.multiBlock, that.multiBlock) && Objects.equals(this.relativePos, that.relativePos);
    }

    public int hashCode() {
        return Objects.hash(this.multiBlock, this.relativePos);
    }

    public String toString() {
        return String.format("ServerMultiBlockReference{multiBlock=%s, relativePos=%s, worldPos=%s, isMaster=%b}", this.multiBlock.getMasterPos(), this.relativePos, this.worldPos, this.isMasterBlock());
    }
}

