/*
 * Decompiled with CFR 0.152.
 */
package org.foodcraft.client.mixin;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_324;
import org.foodcraft.block.FlourSackBlock;
import org.foodcraft.block.entity.FlourSackBlockEntity;
import org.foodcraft.block.entity.ShelfBlockEntity;
import org.foodcraft.item.FlourItem;
import org.foodcraft.registry.ModBlocks;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_324.class})
public class BlockColorsMixin {
    @Inject(method={"create"}, at={@At(value="RETURN")})
    private static void registerFlourSackColor(CallbackInfoReturnable<class_324> cir) {
        class_324 blockColors = (class_324)cir.getReturnValue();
        blockColors.method_1690(BlockColorsMixin::getFlourSackColor, new class_2248[]{ModBlocks.FLOUR_SACK});
    }

    @Unique
    private static int getFlourSackColor(class_2680 state, @Nullable class_1920 world, @Nullable class_2338 pos, int tintIndex) {
        if (world == null || pos == null) {
            return -1;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof ShelfBlockEntity) {
            ShelfBlockEntity shelfBlockEntity = (ShelfBlockEntity)blockEntity;
            return BlockColorsMixin.getShelfFlourSackColor(shelfBlockEntity, state, tintIndex);
        }
        if (blockEntity instanceof FlourSackBlockEntity) {
            FlourSackBlockEntity flourSackBlockEntity = (FlourSackBlockEntity)blockEntity;
            return BlockColorsMixin.getDirectFlourSackColor(flourSackBlockEntity, tintIndex);
        }
        return -1;
    }

    @Unique
    private static int getShelfFlourSackColor(ShelfBlockEntity shelfBlockEntity, class_2680 state, int tintIndex) {
        class_1747 blockItem;
        class_1792 class_17922;
        int shelfIndex = 0;
        if (state.method_28498((class_2769)FlourSackBlock.SHELF_INDEX)) {
            shelfIndex = (Integer)state.method_11654((class_2769)FlourSackBlock.SHELF_INDEX);
        }
        if (shelfIndex < 0 || shelfIndex >= shelfBlockEntity.method_5439()) {
            return -1;
        }
        class_1799 shelfStack = shelfBlockEntity.method_5438(shelfIndex);
        if (shelfStack.method_7960() || !((class_17922 = shelfStack.method_7909()) instanceof class_1747) || !((blockItem = (class_1747)class_17922).method_7711() instanceof FlourSackBlock)) {
            return -1;
        }
        return BlockColorsMixin.getFlourColorFromShelf(shelfBlockEntity, shelfIndex, tintIndex);
    }

    @Unique
    private static int getDirectFlourSackColor(FlourSackBlockEntity flourSackBlockEntity, int tintIndex) {
        int sackCount = flourSackBlockEntity.getSackCount();
        if (tintIndex >= 0 && tintIndex < sackCount) {
            return flourSackBlockEntity.getFlourColor(tintIndex);
        }
        return -1;
    }

    @Unique
    private static int getFlourColorFromShelf(ShelfBlockEntity shelfBlockEntity, int shelfIndex, int tintIndex) {
        try {
            class_1792 class_17922;
            class_2487 flourNbt;
            class_1799 flourStack;
            class_2499 contentData = BlockColorsMixin.getContentDataFromShelf(shelfBlockEntity);
            if (contentData == null || shelfIndex >= contentData.size()) {
                return 0xFFFFFF;
            }
            class_2487 content = contentData.method_10602(shelfIndex);
            if (content.method_10571("Type") == 2 && content.method_10545("flour") && !(flourStack = class_1799.method_7915((class_2487)(flourNbt = content.method_10562("flour")))).method_7960() && (class_17922 = flourStack.method_7909()) instanceof FlourItem) {
                FlourItem flourItem = (FlourItem)class_17922;
                return flourItem.getColor();
            }
            return 0xFFFFFF;
        }
        catch (Exception e) {
            return 0xFFFFFF;
        }
    }

    @Unique
    private static class_2499 getContentDataFromShelf(ShelfBlockEntity shelfBlockEntity) {
        return shelfBlockEntity.getContentData();
    }
}

