/*
 * Decompiled with CFR 0.152.
 */
package org.foodcraft.client.render.blockentity;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import org.foodcraft.block.multi.MultiBlockReference;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public abstract class MultiBlockDebugRenderer<T extends class_2586>
implements class_827<T> {
    protected final class_327 textRenderer;

    public MultiBlockDebugRenderer(class_5614.class_5615 ctx) {
        this.textRenderer = ctx.method_32143();
    }

    protected abstract MultiBlockReference getReference(T var1);

    protected abstract boolean isDebug(T var1);

    protected abstract void otherDebugRender(T var1, MultiBlockReference var2, float var3, class_4587 var4, class_4597 var5, int var6, int var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method_3569(T entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        if (!this.isDebug(entity)) {
            return;
        }
        MultiBlockReference multiBlockRef = this.getReference(entity);
        if (multiBlockRef == null || multiBlockRef.isDisposed()) {
            return;
        }
        class_2338 masterPos = multiBlockRef.getMasterWorldPos();
        class_2338 relativePos = multiBlockRef.getRelativePos();
        class_2338 currentPos = entity.method_11016();
        String masterText = String.format("Master: %d,%d,%d", masterPos.method_10263(), masterPos.method_10264(), masterPos.method_10260());
        String relativeText = String.format("Relative: %d,%d,%d", relativePos.method_10263(), relativePos.method_10264(), relativePos.method_10260());
        String currentText = String.format("Current: %d,%d,%d", currentPos.method_10263(), currentPos.method_10264(), currentPos.method_10260());
        boolean isMaster = multiBlockRef.isMasterBlock();
        String masterStatus = isMaster ? "MASTER" : "SLAVE";
        boolean isIntact = multiBlockRef.checkIntegrity();
        String integrityStatus = isIntact ? "INTACT" : "BROKEN";
        matrices.method_22903();
        try {
            matrices.method_22904(0.5, 1.2, 0.5);
            float scale = 0.02f;
            matrices.method_22905(scale, -scale, scale);
            int white = -1;
            int green = -16711936;
            int red = -65536;
            int yellow = -256;
            int blue = -16742145;
            int masterWidth = this.textRenderer.method_1727(masterText);
            int relativeWidth = this.textRenderer.method_1727(relativeText);
            int currentWidth = this.textRenderer.method_1727(currentText);
            int statusWidth = this.textRenderer.method_1727(masterStatus);
            int integrityWidth = this.textRenderer.method_1727(integrityStatus);
            int maxWidth = Math.max(Math.max(masterWidth, relativeWidth), Math.max(currentWidth, Math.max(statusWidth, integrityWidth)));
            Matrix4f positionMatrix = matrices.method_23760().method_23761();
            this.textRenderer.method_27521(masterText, (float)(-masterWidth) / 2.0f, -40.0f, blue, false, positionMatrix, vertexConsumers, class_327.class_6415.field_33995, 0, light);
            this.textRenderer.method_27521(relativeText, (float)(-relativeWidth) / 2.0f, -30.0f, yellow, false, positionMatrix, vertexConsumers, class_327.class_6415.field_33995, 1, light);
            this.textRenderer.method_27521(currentText, (float)(-currentWidth) / 2.0f, -20.0f, white, false, positionMatrix, vertexConsumers, class_327.class_6415.field_33995, 0, light);
            int masterColor = isMaster ? green : white;
            this.textRenderer.method_27521(masterStatus, (float)(-statusWidth) / 2.0f, -10.0f, masterColor, false, positionMatrix, vertexConsumers, class_327.class_6415.field_33995, 0, light);
            int integrityColor = isIntact ? green : red;
            this.textRenderer.method_27521(integrityStatus, (float)(-integrityWidth) / 2.0f, 0.0f, integrityColor, false, positionMatrix, vertexConsumers, class_327.class_6415.field_33995, 0, light);
            this.otherDebugRender(entity, multiBlockRef, tickDelta, matrices, vertexConsumers, light, overlay);
        }
        finally {
            matrices.method_22909();
        }
    }
}

