/*
 * Decompiled with CFR 0.152.
 */
package org.foodcraft.client.render.gui.tooltip;

import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5684;
import org.foodcraft.item.FlourSackItem;

@Environment(value=EnvType.CLIENT)
public class FlourSackTooltipComponent
implements class_5684 {
    private static final class_2960 TEXTURE = new class_2960("foodcraft", "textures/gui/bundle.png");
    private static final int SLOT_SIZE = 18;
    private static final int BORDER_SIZE = 1;
    private static final int TOTAL_SIZE = 20;
    private final Optional<class_1799> content;
    private final int occupancy;
    private final int maxStorage;

    public FlourSackTooltipComponent(FlourSackItem.FlourSackTooltipData data) {
        this.content = data.content();
        this.occupancy = data.occupancy();
        this.maxStorage = data.maxStorage();
    }

    public int method_32661() {
        return 20;
    }

    public int method_32664(class_327 textRenderer) {
        return 20;
    }

    public void method_32666(class_327 textRenderer, int x, int y, class_332 context) {
        boolean isFull = this.occupancy >= this.maxStorage;
        this.drawSlot(x, y, isFull, context);
        if (this.content.isPresent()) {
            class_1799 itemStack = this.content.get();
            int itemX = x + 1 + 1;
            int itemY = y + 1 + 1;
            context.method_51428(itemStack, itemX, itemY, 0);
            context.method_51431(textRenderer, itemStack, itemX, itemY);
        }
    }

    private void drawSlot(int x, int y, boolean isBlocked, class_332 context) {
        this.drawBorder(x, y, context);
        Sprite sprite = isBlocked ? Sprite.BLOCKED_SLOT : Sprite.SLOT;
        context.method_25291(TEXTURE, x + 1, y + 1, 0, (float)sprite.u, (float)sprite.v, sprite.width, sprite.height, 128, 128);
    }

    private void drawBorder(int x, int y, class_332 context) {
        int i;
        this.draw(context, x, y, Sprite.BORDER_CORNER_TOP_LEFT);
        this.draw(context, x + 18 + 1, y, Sprite.BORDER_CORNER_TOP_RIGHT);
        this.draw(context, x, y + 18 + 1, Sprite.BORDER_CORNER_BOTTOM_LEFT);
        this.draw(context, x + 18 + 1, y + 18 + 1, Sprite.BORDER_CORNER_BOTTOM_RIGHT);
        for (i = 0; i < 18; ++i) {
            this.draw(context, x + 1 + i, y, Sprite.BORDER_HORIZONTAL_TOP);
            this.draw(context, x + 1 + i, y + 18 + 1, Sprite.BORDER_HORIZONTAL_BOTTOM);
        }
        for (i = 0; i < 18; ++i) {
            this.draw(context, x, y + 1 + i, Sprite.BORDER_VERTICAL_LEFT);
            this.draw(context, x + 18 + 1, y + 1 + i, Sprite.BORDER_VERTICAL_RIGHT);
        }
    }

    private void draw(class_332 context, int x, int y, Sprite sprite) {
        context.method_25291(TEXTURE, x, y, 0, (float)sprite.u, (float)sprite.v, sprite.width, sprite.height, 128, 128);
    }

    @Environment(value=EnvType.CLIENT)
    private static enum Sprite {
        SLOT(0, 0, 18, 18),
        BLOCKED_SLOT(0, 40, 18, 18),
        BORDER_HORIZONTAL_TOP(0, 20, 1, 1),
        BORDER_HORIZONTAL_BOTTOM(0, 60, 1, 1),
        BORDER_VERTICAL_LEFT(0, 18, 1, 1),
        BORDER_VERTICAL_RIGHT(19, 18, 1, 1),
        BORDER_CORNER_TOP_LEFT(0, 20, 1, 1),
        BORDER_CORNER_TOP_RIGHT(19, 20, 1, 1),
        BORDER_CORNER_BOTTOM_LEFT(0, 60, 1, 1),
        BORDER_CORNER_BOTTOM_RIGHT(19, 60, 1, 1);

        public final int u;
        public final int v;
        public final int width;
        public final int height;

        private Sprite(int u, int v, int width, int height) {
            this.u = u;
            this.v = v;
            this.width = width;
            this.height = height;
        }
    }
}

