/*
 * Decompiled with CFR 0.152.
 */
package org.foodcraft.client.util;

import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;
import net.minecraft.class_630;
import net.minecraft.class_7179;
import net.minecraft.class_7184;
import net.minecraft.class_7186;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class ModAnimationHelper {
    public static void animate(Map<String, class_630> modelParts, class_7184 animation, long runningTime, float scale, Vector3f tempVec) {
        float f = ModAnimationHelper.getRunningSeconds(animation, runningTime);
        for (Map.Entry entry : animation.comp_599().entrySet()) {
            String boneName = (String)entry.getKey();
            class_630 part = modelParts.get(boneName);
            if (part == null) continue;
            List transformations = (List)entry.getValue();
            for (class_7179 transformation : transformations) {
                ModAnimationHelper.applyTransformation(part, transformation, f, scale, tempVec);
            }
        }
    }

    public static void animateWithPartial(Map<String, class_630> modelParts, class_7184 animation, long runningTime, float partialTime, float scale, Vector3f tempVec) {
        long effectiveTime = runningTime;
        if (animation.comp_598() && animation.comp_597() > 0.0f) {
            long animationLengthMs = (long)(animation.comp_597() * 1000.0f);
            effectiveTime = runningTime % animationLengthMs;
        }
        float totalTime = ((float)effectiveTime + partialTime) / 1000.0f;
        float f = animation.comp_598() ? totalTime % animation.comp_597() : totalTime;
        for (Map.Entry entry : animation.comp_599().entrySet()) {
            String boneName = (String)entry.getKey();
            class_630 part = modelParts.get(boneName);
            if (part == null) continue;
            List transformations = (List)entry.getValue();
            for (class_7179 transformation : transformations) {
                ModAnimationHelper.applyTransformation(part, transformation, f, scale, tempVec);
            }
        }
    }

    private static void applyTransformation(class_630 part, class_7179 transformation, float time, float scale, Vector3f tempVec) {
        class_7186[] keyframes = transformation.comp_596();
        int i = Math.max(0, class_3532.method_15360((int)0, (int)keyframes.length, index -> time <= keyframes[index].comp_600()) - 1);
        int j = Math.min(keyframes.length - 1, i + 1);
        class_7186 keyframe = keyframes[i];
        class_7186 keyframe2 = keyframes[j];
        float h = time - keyframe.comp_600();
        float k = j != i ? class_3532.method_15363((float)(h / (keyframe2.comp_600() - keyframe.comp_600())), (float)0.0f, (float)1.0f) : 0.0f;
        keyframe2.comp_602().apply(tempVec, k, keyframes, i, j, scale);
        transformation.comp_595().apply(part, tempVec);
    }

    private static float getRunningSeconds(class_7184 animation, long runningTime) {
        long effectiveTime = runningTime;
        if (animation.comp_598() && animation.comp_597() > 0.0f) {
            long animationLengthMs = (long)(animation.comp_597() * 1000.0f);
            effectiveTime = runningTime % animationLengthMs;
        }
        float f = (float)effectiveTime / 1000.0f;
        return animation.comp_598() ? f % animation.comp_597() : f;
    }

    public static Vector3f createTranslationalVector(float x, float y, float z) {
        return new Vector3f(x, -y, z);
    }

    public static Vector3f createRotationalVector(float x, float y, float z) {
        return new Vector3f(x * ((float)Math.PI / 180), y * ((float)Math.PI / 180), z * ((float)Math.PI / 180));
    }

    public static Vector3f createScalingVector(double x, double y, double z) {
        return new Vector3f((float)(x - 1.0), (float)(y - 1.0), (float)(z - 1.0));
    }
}

