/*
 * Decompiled with CFR 0.152.
 */
package org.foodcraft.item;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5328;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import org.foodcraft.block.entity.FlourSackBlockEntity;
import org.foodcraft.item.FlourItem;
import org.jetbrains.annotations.Nullable;

public class FlourSackItem
extends class_1747 {
    private static final String ITEMS_KEY = "Items";
    private static final int MAX_STORAGE = 16;
    private static final int ITEM_BAR_COLOR = class_3532.method_15353((float)0.4f, (float)0.4f, (float)1.0f);
    private static final int ITEM_OCCUPANCY = 1;

    public FlourSackItem(class_2248 block, class_1792.class_1793 settings) {
        super(block, settings);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1799 stack = context.method_8041();
        if (FlourSackItem.getBundleOccupancy(stack) == 0) {
            return class_1269.field_5814;
        }
        return super.method_7884(context);
    }

    protected boolean method_7708(class_1750 context, class_2680 state) {
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_1799 itemStack = context.method_8041();
        if (!world.method_8652(pos, state, 11)) {
            return false;
        }
        this.initializeBlockEntity(world, pos, itemStack);
        return true;
    }

    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 clickType, class_1657 player) {
        if (clickType != class_5536.field_27014) {
            return false;
        }
        class_1799 slotStack = slot.method_7677();
        if (slotStack.method_7960()) {
            this.handleRemoveFromBundle(stack, slot, player);
        } else if (FlourSackItem.canAcceptItem(slotStack)) {
            this.handleAddToBundle(stack, slot, slotStack, player);
        }
        return true;
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        if (clickType == class_5536.field_27014 && slot.method_32754(player)) {
            if (otherStack.method_7960()) {
                this.handleRemoveToCursor(stack, cursorStackReference, player);
            } else if (FlourSackItem.canAcceptItem(otherStack)) {
                this.handleAddFromCursor(stack, otherStack, cursorStackReference, player);
            }
            return true;
        }
        return false;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (FlourSackItem.dropAllBundledItems(itemStack, user)) {
            this.playDropContentsSound((class_1297)user);
            user.method_7259(class_3468.field_15372.method_14956((Object)this));
            return class_1271.method_29237((Object)itemStack, (boolean)world.method_8608());
        }
        return class_1271.method_22431((Object)itemStack);
    }

    public boolean method_31567(class_1799 stack) {
        return FlourSackItem.getBundleOccupancy(stack) > 0;
    }

    public int method_31569(class_1799 stack) {
        return Math.min(1 + 12 * FlourSackItem.getBundleOccupancy(stack) / 16, 13);
    }

    public int method_31571(class_1799 stack) {
        return ITEM_BAR_COLOR;
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        Optional<class_1799> content = FlourSackItem.getFirstBundledStack(stack);
        return Optional.of(new FlourSackTooltipData(content, FlourSackItem.getBundleOccupancy(stack), 16));
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        this.appendCapacityTooltip(stack, tooltip);
        this.appendContentTooltip(stack, tooltip);
        this.appendUsageTooltip(stack, tooltip);
        this.appendStackInfoTooltip(stack, tooltip);
    }

    public void method_33261(class_1542 entity) {
        class_5328.method_33263((class_1542)entity, FlourSackItem.getBundledStacks(entity.method_6983()));
    }

    public static float getAmountFilled(class_1799 stack) {
        return (float)FlourSackItem.getBundleOccupancy(stack) / 16.0f;
    }

    public static Optional<class_1799> getFirstBundledStack(class_1799 stack) {
        return FlourSackItem.getBundledStacks(stack).findFirst();
    }

    public static class_2371<class_1799> fromBlockEntity(FlourSackBlockEntity blockEntity) {
        class_2371 result = class_2371.method_10211();
        for (int i = 0; i < blockEntity.getSackCount(); ++i) {
            class_1799 sackContent = blockEntity.getSackContent(i);
            class_1799 sackItem = FlourSackItem.createSackItem(blockEntity, sackContent);
            result.add((Object)sackItem);
        }
        return result;
    }

    public static boolean canStackWith(class_1799 stack1, class_1799 stack2) {
        if (stack1.method_7960() || stack2.method_7960()) {
            return false;
        }
        Optional<class_1799> content1 = FlourSackItem.getFirstBundledStack(stack1);
        Optional<class_1799> content2 = FlourSackItem.getFirstBundledStack(stack2);
        if (content1.isEmpty() && content2.isEmpty()) {
            return true;
        }
        if (content1.isEmpty() != content2.isEmpty()) {
            return false;
        }
        return class_1799.method_7984((class_1799)content1.get(), (class_1799)content2.get());
    }

    private static boolean canAcceptItem(class_1799 stack) {
        return !stack.method_7960() && stack.method_7909() instanceof FlourItem;
    }

    private static int addToBundle(class_1799 bundle, class_1799 stack) {
        if (!FlourSackItem.canAcceptItem(stack)) {
            return 0;
        }
        class_2487 nbt = bundle.method_7948();
        class_2499 items = FlourSackItem.getOrCreateItemsList(nbt);
        int currentOccupancy = FlourSackItem.getBundleOccupancy(bundle);
        int availableSpace = 16 - currentOccupancy;
        int maxToAdd = Math.min(stack.method_7947(), availableSpace);
        if (maxToAdd <= 0) {
            return 0;
        }
        if (items.isEmpty()) {
            return FlourSackItem.addNewItemToBundle(items, stack, maxToAdd);
        }
        return FlourSackItem.mergeWithExistingItem(items, stack, maxToAdd);
    }

    private static int getBundleOccupancy(class_1799 stack) {
        return FlourSackItem.getBundledStacks(stack).mapToInt(itemStack -> 1 * itemStack.method_7947()).sum();
    }

    private static Optional<class_1799> removeFirstStack(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        if (!nbt.method_10545(ITEMS_KEY)) {
            return Optional.empty();
        }
        class_2499 items = nbt.method_10554(ITEMS_KEY, 10);
        if (items.isEmpty()) {
            return Optional.empty();
        }
        class_2487 itemNbt = items.method_10602(0);
        class_1799 itemStack = class_1799.method_7915((class_2487)itemNbt);
        items.method_10536(0);
        if (items.isEmpty()) {
            stack.method_7983(ITEMS_KEY);
        }
        return Optional.of(itemStack);
    }

    private static boolean dropAllBundledItems(class_1799 stack, class_1657 player) {
        class_2487 nbt = stack.method_7948();
        if (!nbt.method_10545(ITEMS_KEY)) {
            return false;
        }
        if (player instanceof class_3222) {
            class_2499 items = nbt.method_10554(ITEMS_KEY, 10);
            FlourSackItem.dropItemsToPlayer(items, player);
        }
        stack.method_7983(ITEMS_KEY);
        return true;
    }

    private static Stream<class_1799> getBundledStacks(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null || !nbt.method_10545(ITEMS_KEY)) {
            return Stream.empty();
        }
        class_2499 items = nbt.method_10554(ITEMS_KEY, 10);
        return items.stream().map(class_2487.class::cast).map(class_1799::method_7915);
    }

    private void initializeBlockEntity(class_1937 world, class_2338 pos, class_1799 itemStack) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof FlourSackBlockEntity) {
            FlourSackBlockEntity flourSackBlockEntity = (FlourSackBlockEntity)blockEntity;
            class_2487 itemNbt = itemStack.method_7948();
            flourSackBlockEntity.readItemNbt(itemNbt);
            flourSackBlockEntity.setSackCount(itemStack.method_7947());
        }
    }

    private void handleRemoveFromBundle(class_1799 stack, class_1735 slot, class_1657 player) {
        this.playRemoveOneSound((class_1297)player);
        FlourSackItem.removeFirstStack(stack).ifPresent(removedStack -> {
            class_1799 remaining = slot.method_32756(removedStack);
            if (!remaining.method_7960()) {
                FlourSackItem.addToBundle(stack, remaining);
            }
        });
    }

    private void handleAddToBundle(class_1799 stack, class_1735 slot, class_1799 slotStack, class_1657 player) {
        class_1799 toAdd;
        int actuallyAdded;
        int availableSpace = 16 - FlourSackItem.getBundleOccupancy(stack);
        int maxToAdd = Math.min(slotStack.method_7947(), availableSpace);
        if (maxToAdd > 0 && (actuallyAdded = FlourSackItem.addToBundle(stack, toAdd = slot.method_32753(slotStack.method_7947(), maxToAdd, player))) > 0) {
            this.playInsertSound((class_1297)player);
        }
    }

    private void handleRemoveToCursor(class_1799 stack, class_5630 cursorStackReference, class_1657 player) {
        FlourSackItem.removeFirstStack(stack).ifPresent(itemStack -> {
            this.playRemoveOneSound((class_1297)player);
            cursorStackReference.method_32332(itemStack);
        });
    }

    private void handleAddFromCursor(class_1799 stack, class_1799 otherStack, class_5630 cursorStackReference, class_1657 player) {
        class_1799 toAdd;
        int actuallyAdded;
        int availableSpace = 16 - FlourSackItem.getBundleOccupancy(stack);
        int maxToAdd = Math.min(otherStack.method_7947(), availableSpace);
        if (maxToAdd > 0 && (actuallyAdded = FlourSackItem.addToBundle(stack, toAdd = otherStack.method_46651(maxToAdd))) > 0) {
            this.playInsertSound((class_1297)player);
            otherStack.method_7934(actuallyAdded);
        }
    }

    private static class_1799 createSackItem(FlourSackBlockEntity blockEntity, class_1799 content) {
        class_1799 sackItem = new class_1799((class_1935)blockEntity.method_11010().method_26204().method_8389());
        if (!content.method_7960()) {
            class_2487 nbt = new class_2487();
            class_2499 items = new class_2499();
            class_2487 itemNbt = new class_2487();
            content.method_7953(itemNbt);
            items.add((Object)itemNbt);
            nbt.method_10566(ITEMS_KEY, (class_2520)items);
            sackItem.method_7980(nbt);
        }
        return sackItem;
    }

    private static class_2499 getOrCreateItemsList(class_2487 nbt) {
        if (!nbt.method_10545(ITEMS_KEY)) {
            nbt.method_10566(ITEMS_KEY, (class_2520)new class_2499());
        }
        return nbt.method_10554(ITEMS_KEY, 10);
    }

    private static int addNewItemToBundle(class_2499 items, class_1799 stack, int maxToAdd) {
        class_1799 toAdd = stack.method_46651(maxToAdd);
        class_2487 itemNbt = new class_2487();
        toAdd.method_7953(itemNbt);
        items.add((Object)itemNbt);
        return maxToAdd;
    }

    private static int mergeWithExistingItem(class_2499 items, class_1799 stack, int maxToAdd) {
        int canMerge;
        class_2487 existingItemNbt = items.method_10602(0);
        class_1799 existingItem = class_1799.method_7915((class_2487)existingItemNbt);
        if (class_1799.method_31577((class_1799)existingItem, (class_1799)stack) && (canMerge = Math.min(maxToAdd, existingItem.method_7914() - existingItem.method_7947())) > 0) {
            existingItem.method_7933(canMerge);
            existingItem.method_7953(existingItemNbt);
            return canMerge;
        }
        return 0;
    }

    private static void dropItemsToPlayer(class_2499 items, class_1657 player) {
        for (int i = 0; i < items.size(); ++i) {
            class_2487 itemNbt = items.method_10602(i);
            class_1799 itemStack = class_1799.method_7915((class_2487)itemNbt);
            player.method_7328(itemStack, true);
        }
    }

    private void appendCapacityTooltip(class_1799 stack, List<class_2561> tooltip) {
        int occupancy = FlourSackItem.getBundleOccupancy(stack);
        tooltip.add((class_2561)class_2561.method_43469((String)"item.foodcraft.flour_sack.fullness", (Object[])new Object[]{occupancy, 16}).method_27692(class_124.field_1080));
    }

    private void appendContentTooltip(class_1799 stack, List<class_2561> tooltip) {
        FlourSackItem.getFirstBundledStack(stack).ifPresent(content -> {
            class_5250 contentText = class_2561.method_43469((String)"item.foodcraft.flour_sack.content", (Object[])new Object[]{content.method_7964(), content.method_7947()});
            tooltip.add((class_2561)contentText.method_27692(class_124.field_1080));
        });
    }

    private void appendUsageTooltip(class_1799 stack, List<class_2561> tooltip) {
        int occupancy = FlourSackItem.getBundleOccupancy(stack);
        String translationKey = occupancy == 0 ? "item.foodcraft.flour_sack.tooltip.empty" : "item.foodcraft.flour_sack.tooltip.non_empty";
        tooltip.add((class_2561)class_2561.method_43471((String)translationKey).method_27695(new class_124[]{class_124.field_1056, class_124.field_1063}));
    }

    private void appendStackInfoTooltip(class_1799 stack, List<class_2561> tooltip) {
        if (stack.method_7947() > 1) {
            tooltip.add((class_2561)class_2561.method_43469((String)"item.foodcraft.flour_sack.stack_count", (Object[])new Object[]{stack.method_7947()}).method_27692(class_124.field_1058));
        }
    }

    private void playRemoveOneSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34377, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private void playInsertSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34376, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private void playDropContentsSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34375, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    public record FlourSackTooltipData(Optional<class_1799> content, int occupancy, int maxStorage) implements class_5632
    {
    }
}

