/*
 * Decompiled with CFR 0.152.
 */
package org.foodcraft.util;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2694;
import net.minecraft.class_2700;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import org.dfood.block.FoodBlock;
import org.dfood.item.DoubleBlockItem;
import org.foodcraft.FoodCraft;
import org.slf4j.Logger;

public class FoodCraftUtils {
    private static final Logger LOGGER = FoodCraft.LOGGER;

    public static class_2680 createFoodBlockState(class_2680 state, int foodCount, class_2350 facing) {
        class_2248 class_22482;
        if (facing == class_2350.field_11036 || facing == class_2350.field_11033) {
            LOGGER.warn("FoodBlock direction can only be horizontal");
            facing = class_2350.field_11034;
        }
        if ((class_22482 = state.method_26204()) instanceof FoodBlock) {
            FoodBlock foodBlock = (FoodBlock)class_22482;
            return (class_2680)((class_2680)state.method_11657((class_2769)FoodBlock.FACING, (Comparable)facing)).method_11657((class_2769)foodBlock.NUMBER_OF_FOOD, (Comparable)Integer.valueOf(foodCount));
        }
        return class_2246.field_10124.method_9564();
    }

    public static boolean hasProperty(class_2248 block, class_2769<?> property) {
        if (block == null || property == null) {
            return false;
        }
        class_2689 stateManager = block.method_9595();
        class_2769 foundProperty = stateManager.method_11663(property.method_11899());
        return foundProperty != null && foundProperty.equals(property);
    }

    public static Set<class_2338> findTargetPositionsFromPattern(class_2700.class_2702 result, Predicate<class_2694> isTargetPositionPredicate) {
        HashSet<class_2338> TargetPos = new HashSet<class_2338>();
        for (int depth = 0; depth < result.method_35304(); ++depth) {
            for (int height = 0; height < result.method_35303(); ++height) {
                for (int width = 0; width < result.method_35302(); ++width) {
                    class_2694 cachedPos = result.method_11717(width, height, depth);
                    if (!isTargetPositionPredicate.test(cachedPos)) continue;
                    TargetPos.add(cachedPos.method_11683());
                }
            }
        }
        return TargetPos;
    }

    public static class_2487 serializeBlockPos(class_2338 pos) {
        class_2487 tag = new class_2487();
        tag.method_10569("x", pos.method_10263());
        tag.method_10569("y", pos.method_10264());
        tag.method_10569("z", pos.method_10260());
        return tag;
    }

    public static class_2338 deserializeBlockPos(class_2487 tag) {
        if (tag.method_10545("x") && tag.method_10545("y") && tag.method_10545("z")) {
            return new class_2338(tag.method_10550("x"), tag.method_10550("y"), tag.method_10550("z"));
        }
        return null;
    }

    public static class_2680 createCountBlockstate(class_1799 stack, class_2350 facing) {
        class_1747 blockItem;
        DoubleBlockItem doubleBlockItem;
        class_1792 item = stack.method_7909();
        if (item instanceof DoubleBlockItem && (doubleBlockItem = (DoubleBlockItem)item).getSecondBlock() instanceof FoodBlock) {
            return FoodCraftUtils.createFoodBlockState(doubleBlockItem.getSecondBlock().method_9564(), stack.method_7947(), facing);
        }
        if (item instanceof class_1747 && (blockItem = (class_1747)item).method_7711() instanceof FoodBlock) {
            return FoodCraftUtils.createFoodBlockState(blockItem.method_7711().method_9564(), stack.method_7947(), facing);
        }
        if (item instanceof class_1747) {
            class_1747 blockItem2 = (class_1747)item;
            if (FoodCraftUtils.hasProperty(blockItem2.method_7711(), class_2741.field_12481)) {
                return (class_2680)blockItem2.method_7711().method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)facing);
            }
            return blockItem2.method_7711().method_9564();
        }
        return class_2246.field_10124.method_9564();
    }

    public static class_265 scale(class_265 shape, double scale) {
        if (shape.method_1110()) {
            return class_259.method_1073();
        }
        class_265[] result = new class_265[]{class_259.method_1073()};
        shape.method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
            double centerX = (minX + maxX) / 2.0;
            double centerY = (minY + maxY) / 2.0;
            double centerZ = (minZ + maxZ) / 2.0;
            double newMinX = centerX + (minX - centerX) * scale;
            double newMinY = centerY + (minY - centerY) * scale;
            double newMinZ = centerZ + (minZ - centerZ) * scale;
            double newMaxX = centerX + (maxX - centerX) * scale;
            double newMaxY = centerY + (maxY - centerY) * scale;
            double newMaxZ = centerZ + (maxZ - centerZ) * scale;
            class_265 scaledBox = class_259.method_1081((double)newMinX, (double)newMinY, (double)newMinZ, (double)newMaxX, (double)newMaxY, (double)newMaxZ);
            result[0] = class_259.method_1084((class_265)result[0], (class_265)scaledBox);
        });
        return result[0];
    }

    public static class_265 scaleFromOrigin(class_265 shape, double scale) {
        if (shape.method_1110()) {
            return class_259.method_1073();
        }
        class_265[] result = new class_265[]{class_259.method_1073()};
        shape.method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
            double newMinX = minX * scale;
            double newMinY = minY * scale;
            double newMinZ = minZ * scale;
            double newMaxX = maxX * scale;
            double newMaxY = maxY * scale;
            double newMaxZ = maxZ * scale;
            class_265 scaledBox = class_259.method_1081((double)newMinX, (double)newMinY, (double)newMinZ, (double)newMaxX, (double)newMaxY, (double)newMaxZ);
            result[0] = class_259.method_1084((class_265)result[0], (class_265)scaledBox);
        });
        return result[0];
    }
}

