/*
 * Decompiled with CFR 0.152.
 */
package org.foodcraft.util;

import java.util.function.Consumer;
import net.minecraft.class_3532;

public class ModAnimationState {
    private static final long STOPPED = Long.MAX_VALUE;
    public long updatedAt = Long.MAX_VALUE;
    public long timeRunning;
    public float partialTime;
    private boolean looping = false;
    private float animationLength = 0.0f;
    private long lastTimeRunning = 0L;

    public void FStart(int age) {
        this.resetRunningTime();
        this.start(age);
    }

    public void start(int age) {
        this.updatedAt = (long)((float)age * 1000.0f / 20.0f);
        this.partialTime = 0.0f;
        this.lastTimeRunning = this.timeRunning;
    }

    public void startIfNotRunning(int age) {
        if (!this.isRunning()) {
            this.start(age);
        }
    }

    public void setRunning(boolean running, int age) {
        if (running) {
            this.startIfNotRunning(age);
        } else {
            this.stop();
        }
    }

    public void stop() {
        this.updatedAt = Long.MAX_VALUE;
        this.partialTime = 0.0f;
    }

    public void run(Consumer<ModAnimationState> consumer) {
        if (this.isRunning()) {
            consumer.accept(this);
        }
    }

    public void update(float animationProgress, float speedMultiplier, boolean looping, float animationLength) {
        this.looping = looping;
        this.animationLength = animationLength;
        if (this.isRunning()) {
            long currentTime = class_3532.method_15372((double)(animationProgress * 1000.0f / 20.0f));
            float partial = class_3532.method_15372((double)(animationProgress * 1000.0f / 20.0f)) - currentTime;
            long timeDelta = (long)((float)(currentTime - this.updatedAt) * speedMultiplier);
            this.timeRunning += timeDelta;
            if (this.timeRunning < this.lastTimeRunning) {
                this.timeRunning = this.lastTimeRunning;
            } else {
                this.lastTimeRunning = this.timeRunning;
            }
            this.partialTime = partial * speedMultiplier;
            this.updatedAt = currentTime;
        }
    }

    public float getTimeRunningWithPartial() {
        if (this.looping && this.animationLength > 0.0f) {
            long animationLengthMs = (long)(this.animationLength * 1000.0f);
            return ((float)this.timeRunning + this.partialTime) % (float)animationLengthMs;
        }
        return (float)this.timeRunning + this.partialTime;
    }

    public long getTimeRunning() {
        if (this.looping && this.animationLength > 0.0f) {
            long animationLengthMs = (long)(this.animationLength * 1000.0f);
            return this.timeRunning % animationLengthMs;
        }
        return this.timeRunning;
    }

    public boolean isRunning() {
        return this.updatedAt != Long.MAX_VALUE;
    }

    public void resetRunningTime() {
        this.timeRunning = 0L;
        this.lastTimeRunning = 0L;
    }
}

