/*
 * Decompiled with CFR 0.152.
 */
package link.e4mc;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import link.e4mc.Agnos;
import link.e4mc.Config;
import link.e4mc.Mirror;
import link.e4mc.QuiclimeSession;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.commands.BanListCommands;
import net.minecraft.server.commands.BanPlayerCommands;
import net.minecraft.server.commands.PardonCommand;
import net.minecraft.server.commands.WhitelistCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class E4mcClient {
    public static final String MOD_ID = "e4mc_minecraft";
    public static QuiclimeSession session;
    public static final Logger LOGGER;

    public static void init() {
        Config.INSTANCE.id();
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        if (Config.INSTANCE.restoreDedicatedCommands.value().booleanValue() && Agnos.isClient()) {
            BanListCommands.register(dispatcher);
            BanPlayerCommands.register(dispatcher);
            PardonCommand.register(dispatcher);
            WhitelistCommand.register(dispatcher);
        }
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"e4mc").requires(src -> {
            if (src.getServer() == null) {
                return false;
            }
            if (src.getServer().isDedicatedServer()) {
                return src.hasPermission(4);
            }
            try {
                return Mirror.isSingleplayerOwner(src.getServer(), src.getPlayerOrException());
            }
            catch (CommandSyntaxException e) {
                return false;
            }
        })).then(Commands.literal((String)"stop").executes(ctx -> {
            if (session != null && E4mcClient.session.state != QuiclimeSession.State.STOPPED) {
                session.stop();
                Mirror.sendSuccessToSource((CommandSourceStack)ctx.getSource(), Mirror.translatable("text.e4mc_minecraft.closeServer", new Object[0]));
            } else {
                Mirror.sendFailureToSource((CommandSourceStack)ctx.getSource(), Mirror.translatable("text.e4mc_minecraft.serverAlreadyClosed", new Object[0]));
            }
            return 1;
        }))).then(Commands.literal((String)"restart").executes(ctx -> {
            if (session != null && E4mcClient.session.state != QuiclimeSession.State.STARTED) {
                session.stop();
                session = new QuiclimeSession(E4mcClient.session.handler);
                session.startAsync();
            }
            return 1;
        })));
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)MOD_ID);
    }
}

