/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.extshape.blockus;

import com.brand.blockus.datagen.family.BlockusFamilies;
import com.brand.blockus.registry.content.BlockusBlocks;
import com.brand.blockus.registry.content.bundles.BSSWBundle;
import com.brand.blockus.registry.content.bundles.ConcreteBundle;
import com.brand.blockus.registry.content.bundles.WoolBundle;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_5794;
import pers.solid.extshape.builder.BlockShape;
import pers.solid.extshape.util.BlockBiMaps;

public final class BlockusBlockBiMaps {
    private BlockusBlockBiMaps() {
    }

    static void importFromBlockus() {
        Stream families = BlockusFamilies.getFamilies();
        families.forEach(blockFamily -> {
            class_2248 baseBlock = blockFamily.method_33469();
            if (baseBlock == class_2246.field_22108) {
                return;
            }
            Map variants = blockFamily.method_33474();
            for (BlockShape shape : BlockShape.values()) {
                if (shape.vanillaVariant == null) continue;
                class_2248 variant = (class_2248)variants.get(shape.vanillaVariant);
                if (variant == null) {
                    if (shape == BlockShape.FENCE) {
                        variant = (class_2248)variants.get(class_5794.class_5796.field_40592);
                    } else if (shape == BlockShape.FENCE_GATE) {
                        variant = (class_2248)variants.get(class_5794.class_5796.field_40593);
                    }
                }
                if (variant == null) continue;
                BlockBiMaps.setBlockOf((BlockShape)shape, (class_2248)baseBlock, (class_2248)variant);
                BlockBiMaps.BASE_BLOCKS.add(baseBlock);
            }
        });
        BSSWBundle.values().forEach(bsswBundle -> {
            if (bsswBundle.stairs() != null) {
                BlockBiMaps.setBlockOf((BlockShape)BlockShape.STAIRS, (class_2248)bsswBundle.block(), (class_2248)bsswBundle.stairs());
            }
            if (bsswBundle.slab() != null) {
                BlockBiMaps.setBlockOf((BlockShape)BlockShape.SLAB, (class_2248)bsswBundle.block(), (class_2248)bsswBundle.slab());
            }
            if (bsswBundle.wall() != null) {
                BlockBiMaps.setBlockOf((BlockShape)BlockShape.WALL, (class_2248)bsswBundle.block(), (class_2248)bsswBundle.wall());
            }
        });
        WoolBundle.values().forEach(woolBundle -> woolBundle.colorMap().values().forEach(woolVariants -> {
            if (woolVariants.stairs() != null) {
                BlockBiMaps.setBlockOf((BlockShape)BlockShape.STAIRS, (class_2248)woolVariants.block(), (class_2248)woolVariants.stairs());
            }
            if (woolVariants.slab() != null) {
                BlockBiMaps.setBlockOf((BlockShape)BlockShape.SLAB, (class_2248)woolVariants.block(), (class_2248)woolVariants.slab());
            }
        }));
        ConcreteBundle.values().forEach(concreteBundle -> concreteBundle.colorMap().values().forEach(concreteVariants -> {
            if (concreteVariants.stairs() != null) {
                BlockBiMaps.setBlockOf((BlockShape)BlockShape.STAIRS, (class_2248)concreteVariants.block(), (class_2248)concreteVariants.stairs());
            }
            if (concreteVariants.slab() != null) {
                BlockBiMaps.setBlockOf((BlockShape)BlockShape.SLAB, (class_2248)concreteVariants.block(), (class_2248)concreteVariants.slab());
            }
            if (concreteVariants.wall() != null) {
                BlockBiMaps.setBlockOf((BlockShape)BlockShape.WALL, (class_2248)concreteVariants.block(), (class_2248)concreteVariants.wall());
            }
        }));
        BlockBiMaps.setBlockOf((BlockShape)BlockShape.PRESSURE_PLATE, (class_2248)BlockusBlocks.LIMESTONE.block(), (class_2248)BlockusBlocks.LIMESTONE_PRESSURE_PLATE);
        BlockBiMaps.setBlockOf((BlockShape)BlockShape.PRESSURE_PLATE, (class_2248)BlockusBlocks.MARBLE.block(), (class_2248)BlockusBlocks.MARBLE_PRESSURE_PLATE);
        BlockBiMaps.setBlockOf((BlockShape)BlockShape.PRESSURE_PLATE, (class_2248)BlockusBlocks.BLUESTONE.block(), (class_2248)BlockusBlocks.BLUESTONE_PRESSURE_PLATE);
        BlockBiMaps.setBlockOf((BlockShape)BlockShape.PRESSURE_PLATE, (class_2248)BlockusBlocks.VIRIDITE.block(), (class_2248)BlockusBlocks.VIRIDITE_PRESSURE_PLATE);
        BlockBiMaps.setBlockOf((BlockShape)BlockShape.PRESSURE_PLATE, (class_2248)BlockusBlocks.POLISHED_NETHERRACK.block(), (class_2248)BlockusBlocks.POLISHED_NETHERRACK_PRESSURE_PLATE);
        BlockBiMaps.setBlockOf((BlockShape)BlockShape.PRESSURE_PLATE, (class_2248)BlockusBlocks.POLISHED_END_STONE.block(), (class_2248)BlockusBlocks.POLISHED_END_STONE_PRESSURE_PLATE);
        BlockBiMaps.setBlockOf((BlockShape)BlockShape.PRESSURE_PLATE, (class_2248)BlockusBlocks.POLISHED_SCULK.block(), (class_2248)BlockusBlocks.POLISHED_SCULK_PRESSURE_PLATE);
        BlockBiMaps.setBlockOf((BlockShape)BlockShape.BUTTON, (class_2248)BlockusBlocks.LIMESTONE.block(), (class_2248)BlockusBlocks.LIMESTONE_BUTTON);
        BlockBiMaps.setBlockOf((BlockShape)BlockShape.BUTTON, (class_2248)BlockusBlocks.MARBLE.block(), (class_2248)BlockusBlocks.MARBLE_BUTTON);
        BlockBiMaps.setBlockOf((BlockShape)BlockShape.BUTTON, (class_2248)BlockusBlocks.BLUESTONE.block(), (class_2248)BlockusBlocks.BLUESTONE_BUTTON);
        BlockBiMaps.setBlockOf((BlockShape)BlockShape.BUTTON, (class_2248)BlockusBlocks.VIRIDITE.block(), (class_2248)BlockusBlocks.VIRIDITE_BUTTON);
        BlockBiMaps.setBlockOf((BlockShape)BlockShape.BUTTON, (class_2248)BlockusBlocks.POLISHED_NETHERRACK.block(), (class_2248)BlockusBlocks.POLISHED_NETHERRACK_BUTTON);
        BlockBiMaps.setBlockOf((BlockShape)BlockShape.BUTTON, (class_2248)BlockusBlocks.POLISHED_END_STONE.block(), (class_2248)BlockusBlocks.POLISHED_END_STONE_BUTTON);
        BlockBiMaps.setBlockOf((BlockShape)BlockShape.BUTTON, (class_2248)BlockusBlocks.POLISHED_SCULK.block(), (class_2248)BlockusBlocks.POLISHED_SCULK_BUTTON);
        BlockBiMaps.setBlockOf((BlockShape)BlockShape.SLAB, (class_2248)BlockusBlocks.CUT_SOUL_SANDSTONE, (class_2248)BlockusBlocks.CUT_SOUL_SANDSTONE_SLAB);
        BlockBiMaps.setBlockOf((BlockShape)BlockShape.WALL, (class_2248)BlockusBlocks.ICE_BRICKS, (class_2248)BlockusBlocks.ICE_BRICK_WALL);
    }
}

