/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.extshape.blockus;

import com.brand.blockus.registry.content.BlockusBlocks;
import java.util.ArrayList;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pers.solid.extshape.ExtShape;
import pers.solid.extshape.blockus.ExtShapeBlockusBlocks;
import pers.solid.extshape.blockus.ExtShapeBlockusItemGroup;
import pers.solid.extshape.builder.BlockShape;
import pers.solid.extshape.util.BlockBiMaps;

public class ExtShapeBlockus
implements ModInitializer {
    public static final String NAMESPACE = "extshape_blockus";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Extended Block Shapes for Blockus");
    private static final class_2960 defaultId = class_2960.method_60655((String)"extshape_blockus", (String)"default");
    public static Map<String, String> replacing_id_map = null;

    public static class_2960 id(@NotNull String path) {
        return defaultId.method_45136(path);
    }

    public void onInitialize() {
        if (FabricLoader.getInstance().isModLoaded("blockus")) {
            LOGGER.info("Blockus mod loaded. Extended Block Shapes mod is trying to apply it.");
            ExtShapeBlockusBlocks.init();
            ExtShapeBlockusItemGroup.registerEvent();
            ExtShapeBlockus.registerStrippableBlocks();
            if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
                ExtShapeBlockus.validateBlockIds();
                ExtShapeBlockus.validateReplacingIds();
            }
        }
    }

    private static void registerStrippableBlocks() {
        for (BlockShape shape : BlockShape.values()) {
            class_2248 block1 = BlockBiMaps.getBlockOf((BlockShape)shape, (class_2248)BlockusBlocks.WHITE_OAK_LOG);
            class_2248 block2 = BlockBiMaps.getBlockOf((BlockShape)shape, (class_2248)BlockusBlocks.STRIPPED_WHITE_OAK_LOG);
            if (block1 != null && block2 != null) {
                ExtShape.EXTENDED_STRIPPABLE_BLOCKS.put(block1, block2);
            }
            class_2248 block3 = BlockBiMaps.getBlockOf((BlockShape)shape, (class_2248)BlockusBlocks.WHITE_OAK_WOOD);
            class_2248 block4 = BlockBiMaps.getBlockOf((BlockShape)shape, (class_2248)BlockusBlocks.STRIPPED_WHITE_OAK_WOOD);
            if (block3 == null || block4 == null) continue;
            ExtShape.EXTENDED_STRIPPABLE_BLOCKS.put(block3, block4);
        }
    }

    private static void validateBlockIds() {
        Validate.notEmpty(ExtShapeBlockusBlocks.BLOCKUS_BLOCKS);
        for (class_2248 block : ExtShapeBlockusBlocks.BLOCKUS_BLOCKS) {
            class_2248 blockusBlock;
            class_2960 blockId = class_7923.field_41175.method_10221((Object)block);
            class_2960 blockusId = class_2960.method_60655((String)"blockus", (String)blockId.method_12832());
            if (!class_7923.field_41175.method_10250(blockusId) || (blockusBlock = (class_2248)class_7923.field_41175.method_63535(blockusId)) == BlockusBlocks.PAPER_WALL) continue;
            throw new IllegalStateException("Block with id " + String.valueOf(blockId) + " is registered in the mod, but block " + String.valueOf(blockusId) + " already exists in Blockus mod!");
        }
    }

    private static void validateReplacingIds() {
        if (replacing_id_map == null) {
            return;
        }
        ArrayList exceptions = new ArrayList();
        replacing_id_map.forEach((k, v) -> {
            class_2960 key = class_2960.method_60654((String)k);
            try {
                Validate.validState((!class_7923.field_41175.method_10250(key) ? 1 : 0) != 0, (String)"The id %s is to be replaced, but still exists in the block registry!", (Object[])new Object[]{key});
                Validate.validState((!class_7923.field_41178.method_10250(key) ? 1 : 0) != 0, (String)"The id %s is to be replaced, but still exists in the item registry!", (Object[])new Object[]{key});
            }
            catch (RuntimeException e) {
                LOGGER.error("Data fixer:", (Throwable)e);
                exceptions.add(e);
            }
            class_2960 value = class_2960.method_60654((String)v);
            try {
                Validate.validState((boolean)class_7923.field_41175.method_10250(value), (String)"The id %s is to be replace with, but does not exist in the block registry!", (Object[])new Object[]{value});
                Validate.validState((boolean)class_7923.field_41178.method_10250(value), (String)"The id %s is to be replace with, but does not exist in the item registry!", (Object[])new Object[]{value});
            }
            catch (RuntimeException e) {
                LOGGER.error("Data fixer:", (Throwable)e);
                exceptions.add(e);
            }
        });
        if (!exceptions.isEmpty()) {
            throw (RuntimeException)exceptions.getLast();
        }
    }
}

