/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.extshape.blockus;

import com.brand.blockus.Blockus;
import com.brand.blockus.registry.content.BlockusBlocks;
import com.brand.blockus.registry.content.bundles.BSSWBundle;
import com.brand.blockus.registry.content.bundles.WoodBundle;
import com.brand.blockus.registry.content.bundles.WoolBundle;
import com.brand.blockus.utils.helper.WoodMaps;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.registry.CompostingChanceRegistry;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_4719;
import net.minecraft.class_5244;
import net.minecraft.class_8177;
import org.jetbrains.annotations.UnmodifiableView;
import pers.solid.extshape.ExtShapeBlockItem;
import pers.solid.extshape.block.BlockExtension;
import pers.solid.extshape.block.ExtShapeBlockInterface;
import pers.solid.extshape.blockus.BlockusBlockBiMaps;
import pers.solid.extshape.blockus.ExtShapeBlockusBlockTypes;
import pers.solid.extshape.blockus.WoolPressurePlate;
import pers.solid.extshape.builder.AbstractBlockBuilder;
import pers.solid.extshape.builder.BlockShape;
import pers.solid.extshape.builder.BlocksBuilder;
import pers.solid.extshape.builder.BlocksBuilderFactory;
import pers.solid.extshape.builder.PressurePlateBuilder;
import pers.solid.extshape.util.ActivationSettings;
import pers.solid.extshape.util.ExtShapeBlockTypes;
import pers.solid.extshape.util.FenceSettings;

public final class ExtShapeBlockusBlocks {
    public static final @UnmodifiableView ObjectSet<class_2248> BLOCKUS_BLOCKS;
    public static final @UnmodifiableView ObjectSet<class_2248> BLOCKUS_BASE_BLOCKS;
    private static final BlocksBuilderFactory FACTORY;
    private static boolean markStoneCuttableWhenCreating;

    private ExtShapeBlockusBlocks() {
    }

    private static BlocksBuilder create(class_2248 baseBlock) {
        if (markStoneCuttableWhenCreating) {
            ExtShapeBlockInterface.STONECUTTABLE_BASE_BLOCKS.add((Object)baseBlock);
        }
        return FACTORY.createAllShapes(baseBlock);
    }

    private static BlocksBuilder create(BSSWBundle bsswBundle) {
        BlocksBuilder blocksBuilder = ExtShapeBlockusBlocks.create(bsswBundle.block());
        if (bsswBundle.stairs() != null) {
            blocksBuilder.without(BlockShape.STAIRS);
        }
        if (bsswBundle.slab() != null) {
            blocksBuilder.without(BlockShape.SLAB);
        }
        if (bsswBundle.wall() != null) {
            blocksBuilder.without(BlockShape.WALL);
        }
        return blocksBuilder;
    }

    private static BlocksBuilder create(WoodBundle woodTypes) {
        return ExtShapeBlockusBlocks.create(woodTypes.planks()).without(new BlockShape[]{BlockShape.STAIRS, BlockShape.SLAB, BlockShape.FENCE, BlockShape.FENCE_GATE, BlockShape.PRESSURE_PLATE, BlockShape.BUTTON});
    }

    private static void buildCircularPavingBlock(BlocksBuilder blocksBuilder) {
        blocksBuilder.with(new BlockShape[]{BlockShape.SLAB, BlockShape.PRESSURE_PLATE}).setCircularPaving().build();
    }

    public static void init() {
    }

    static {
        FACTORY = (BlocksBuilderFactory)class_156.method_654((Object)new BlocksBuilderFactory(), blocksBuilderFactory -> {
            blocksBuilderFactory.defaultNamespace = "extshape_blockus";
        });
        ObjectLinkedOpenHashSet blocks = new ObjectLinkedOpenHashSet();
        ObjectLinkedOpenHashSet baseBlocks = new ObjectLinkedOpenHashSet();
        BLOCKUS_BLOCKS = ObjectSets.unmodifiable((ObjectSet)blocks);
        BLOCKUS_BASE_BLOCKS = ObjectSets.unmodifiable((ObjectSet)baseBlocks);
        ExtShapeBlockusBlocks.FACTORY.instanceCollection = blocks;
        ExtShapeBlockusBlocks.FACTORY.baseBlockCollection = baseBlocks;
        BlockusBlockBiMaps.importFromBlockus();
        markStoneCuttableWhenCreating = true;
        ExtShapeBlockusBlocks.create(BlockusBlocks.STONE_TILES).setFenceSettings(FenceSettings.STONE).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.HERRINGBONE_STONE_BRICKS).setFenceSettings(FenceSettings.STONE).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.buildCircularPavingBlock(FACTORY.createEmpty(BlockusBlocks.STONE_CIRCULAR_PAVING).markStoneCuttable());
        ExtShapeBlockusBlocks.create(BlockusBlocks.ANDESITE_BRICKS).setFenceSettings(FenceSettings.STONE).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.HERRINGBONE_ANDESITE_BRICKS).setFenceSettings(FenceSettings.STONE).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.buildCircularPavingBlock(FACTORY.createEmpty(BlockusBlocks.ANDESITE_CIRCULAR_PAVING).markStoneCuttable());
        ExtShapeBlockusBlocks.create(BlockusBlocks.DIORITE_BRICKS).setFenceSettings(FenceSettings.STONE).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.HERRINGBONE_DIORITE_BRICKS).setFenceSettings(FenceSettings.STONE).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.buildCircularPavingBlock(FACTORY.createEmpty(BlockusBlocks.DIORITE_CIRCULAR_PAVING).markStoneCuttable());
        ExtShapeBlockusBlocks.create(BlockusBlocks.GRANITE_BRICKS).setFenceSettings(FenceSettings.STONE).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.HERRINGBONE_GRANITE_BRICKS).setFenceSettings(FenceSettings.STONE).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.buildCircularPavingBlock(FACTORY.createEmpty(BlockusBlocks.GRANITE_CIRCULAR_PAVING).markStoneCuttable());
        ExtShapeBlockusBlocks.create(BlockusBlocks.POLISHED_DRIPSTONE).setFenceSettings(FenceSettings.DRIPSTONE).setActivationSettings(ActivationSettings.DRIPSTONE).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.DRIPSTONE_BRICKS).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).setActivationSettings(ActivationSettings.DRIPSTONE).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.MOSSY_DRIPSTONE_BRICKS).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).setActivationSettings(ActivationSettings.DRIPSTONE).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.MOSSY_TUFF_BRICKS).setFenceSettings(FenceSettings.TUFF).setActivationSettings(ActivationSettings.TUFF).without(BlockShape.BUTTON).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.TUFF_TILES).setFenceSettings(FenceSettings.TUFF).setActivationSettings(ActivationSettings.TUFF).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.HERRINGBONE_TUFF_BRICKS).setFenceSettings(FenceSettings.TUFF).setActivationSettings(ActivationSettings.TUFF).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.buildCircularPavingBlock(FACTORY.createEmpty(BlockusBlocks.TUFF_CIRCULAR_PAVING).markStoneCuttable().setFenceSettings(FenceSettings.TUFF).setActivationSettings(ActivationSettings.TUFF));
        ExtShapeBlockusBlocks.create(BlockusBlocks.MOSSY_DEEPSLATE_BRICKS).setFenceSettings(FenceSettings.DEEPSLATE_BRICKS).setActivationSettings(ActivationSettings.DEEPSLATE_BRICKS).without(BlockShape.BUTTON).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.HERRINGBONE_DEEPSLATE_BRICKS).setFenceSettings(FenceSettings.DEEPSLATE_BRICKS).setActivationSettings(ActivationSettings.DEEPSLATE_BRICKS).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.buildCircularPavingBlock(FACTORY.createEmpty(BlockusBlocks.DEEPSLATE_CIRCULAR_PAVING).markStoneCuttable().setFenceSettings(FenceSettings.DEEPSLATE_BRICKS).setActivationSettings(ActivationSettings.DEEPSLATE_BRICKS));
        ExtShapeBlockusBlocks.create(BlockusBlocks.POLISHED_SCULK).setFenceSettings(new FenceSettings(class_1802.field_37524, ExtShapeBlockTypes.DEEPSLATE_BRICKS_WOOD_TYPE)).setActivationSettings(ActivationSettings.DEEPSLATE_BRICKS).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.SCULK_BRICKS).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).setFenceSettings(new FenceSettings(class_1802.field_37524, ExtShapeBlockTypes.DEEPSLATE_BRICKS_WOOD_TYPE)).setActivationSettings(ActivationSettings.DEEPSLATE_BRICKS).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.POLISHED_AMETHYST).withoutRedstone().withExtension(BlockExtension.AMETHYST).setFenceSettings(FenceSettings.AMETHYST).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.AMETHYST_BRICKS).withoutRedstone().withExtension(BlockExtension.AMETHYST).setFenceSettings(FenceSettings.AMETHYST).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ActivationSettings blackstoneActivationSettings = ActivationSettings.stone((class_8177)class_8177.field_42822);
        ExtShapeBlockusBlocks.create(BlockusBlocks.POLISHED_BLACKSTONE_TILES).setActivationSettings(blackstoneActivationSettings).setFenceSettings(FenceSettings.STONE).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.CRIMSON_WARTY_BLACKSTONE_BRICKS).setActivationSettings(blackstoneActivationSettings).setFenceSettings(FenceSettings.STONE).without(BlockShape.BUTTON).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.WARPED_WARTY_BLACKSTONE_BRICKS).setActivationSettings(blackstoneActivationSettings).setFenceSettings(FenceSettings.STONE).without(BlockShape.BUTTON).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.HERRINGBONE_POLISHED_BLACKSTONE_BRICKS).setActivationSettings(blackstoneActivationSettings).setFenceSettings(FenceSettings.STONE).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.buildCircularPavingBlock(FACTORY.createEmpty(BlockusBlocks.POLISHED_BLACKSTONE_CIRCULAR_PAVING).markStoneCuttable().setActivationSettings(blackstoneActivationSettings).setFenceSettings(FenceSettings.STONE));
        ExtShapeBlockusBlocks.create(BlockusBlocks.ROUGH_BASALT).setFenceSettings(FenceSettings.BASALT).setActivationSettings(ActivationSettings.BASALT).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.POLISHED_BASALT_BRICKS).setFenceSettings(FenceSettings.BASALT).setActivationSettings(ActivationSettings.BASALT).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.HERRINGBONE_POLISHED_BASALT_BRICKS).setFenceSettings(FenceSettings.BASALT).setActivationSettings(ActivationSettings.BASALT).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.buildCircularPavingBlock(FACTORY.createEmpty(BlockusBlocks.POLISHED_BASALT_CIRCULAR_PAVING));
        ExtShapeBlockusBlocks.create(BlockusBlocks.CRIMSON_WART_BRICKS).setFenceSettings(new FenceSettings(class_1802.field_8790, ExtShapeBlockTypes.NETHER_BRICKS_WOOD_TYPE)).setActivationSettings(ActivationSettings.stone((class_8177)ExtShapeBlockTypes.NETHER_BRICKS_BLOCK_SET_TYPE)).without(BlockShape.BUTTON).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.WARPED_WART_BRICKS).setFenceSettings(new FenceSettings(class_1802.field_8790, ExtShapeBlockTypes.NETHER_BRICKS_WOOD_TYPE)).setActivationSettings(ActivationSettings.stone((class_8177)ExtShapeBlockTypes.NETHER_BRICKS_BLOCK_SET_TYPE)).without(BlockShape.BUTTON).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.LIMESTONE).setFenceSettings(FenceSettings.STONE).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.POLISHED_LIMESTONE).setFenceSettings(FenceSettings.STONE).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.LIMESTONE_BRICKS).setFenceSettings(FenceSettings.STONE).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.SMALL_LIMESTONE_BRICKS).setFenceSettings(FenceSettings.STONE).without(BlockShape.BUTTON).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.LIMESTONE_TILES).setFenceSettings(FenceSettings.STONE).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.LIMESTONE_SQUARES).setFenceSettings(FenceSettings.STONE).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.buildCircularPavingBlock(FACTORY.createEmpty(BlockusBlocks.LIMESTONE_CIRCULAR_PAVING).markStoneCuttable());
        ExtShapeBlockusBlocks.create(BlockusBlocks.MARBLE).setFenceSettings(FenceSettings.STONE).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.POLISHED_MARBLE).setFenceSettings(FenceSettings.STONE).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.MARBLE_BRICKS).setFenceSettings(FenceSettings.STONE).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.SMALL_MARBLE_BRICKS).setFenceSettings(FenceSettings.STONE).without(BlockShape.BUTTON).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.MARBLE_TILES).setFenceSettings(FenceSettings.STONE).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.MARBLE_SQUARES).setFenceSettings(FenceSettings.STONE).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.buildCircularPavingBlock(FACTORY.createEmpty(BlockusBlocks.MARBLE_CIRCULAR_PAVING).markStoneCuttable());
        ExtShapeBlockusBlocks.create(BlockusBlocks.BLUESTONE).setFenceSettings(FenceSettings.STONE).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.POLISHED_BLUESTONE).setFenceSettings(FenceSettings.STONE).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.BLUESTONE_BRICKS).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.SMALL_BLUESTONE_BRICKS).setFenceSettings(FenceSettings.STONE).without(BlockShape.BUTTON).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.BLUESTONE_TILES).setFenceSettings(FenceSettings.STONE).without(BlockShape.BUTTON).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.BLUESTONE_SQUARES).setFenceSettings(FenceSettings.STONE).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.buildCircularPavingBlock(FACTORY.createEmpty(BlockusBlocks.BLUESTONE_CIRCULAR_PAVING).markStoneCuttable());
        ExtShapeBlockusBlocks.create(BlockusBlocks.VIRIDITE).setFenceSettings(FenceSettings.STONE).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.POLISHED_VIRIDITE).setFenceSettings(FenceSettings.STONE).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.VIRIDITE_BRICKS).setFenceSettings(FenceSettings.STONE).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.SMALL_VIRIDITE_BRICKS).setFenceSettings(FenceSettings.STONE).without(BlockShape.BUTTON).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.VIRIDITE_TILES).setFenceSettings(FenceSettings.STONE).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.VIRIDITE_SQUARES).setFenceSettings(FenceSettings.STONE).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.buildCircularPavingBlock(FACTORY.createEmpty(BlockusBlocks.VIRIDITE_CIRCULAR_PAVING).markStoneCuttable());
        ExtShapeBlockusBlocks.create(BlockusBlocks.LAVA_BRICKS).setFenceSettings(FenceSettings.STONE).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.LAVA_POLISHED_BLACKSTONE_BRICKS).setActivationSettings(ActivationSettings.stone((class_8177)class_8177.field_42822)).setFenceSettings(FenceSettings.STONE).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.SNOW_BRICKS).setFenceSettings(FenceSettings.STONE).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.ICE_BRICKS).setActivationSettings(ActivationSettings.stone((class_8177)ExtShapeBlockusBlockTypes.ICE_BLOCK_SET_TYPE)).setFenceSettings(new FenceSettings(class_1802.field_8426, ExtShapeBlockusBlockTypes.ICE_WOOD_TYPE)).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.WALL}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.OBSIDIAN_BRICKS).setActivationSettings(ActivationSettings.HARD).setFenceSettings(FenceSettings.STONE).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.SMALL_OBSIDIAN_BRICKS).setActivationSettings(ActivationSettings.HARD).setFenceSettings(FenceSettings.STONE).without(BlockShape.BUTTON).build();
        ExtShapeBlockusBlocks.buildCircularPavingBlock(FACTORY.createEmpty(BlockusBlocks.OBSIDIAN_CIRCULAR_PAVING).markStoneCuttable().setActivationSettings(ActivationSettings.HARD));
        ExtShapeBlockusBlocks.create(BlockusBlocks.GLOWING_OBSIDIAN).setActivationSettings(ActivationSettings.HARD).setFenceSettings(FenceSettings.STONE).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.POLISHED_NETHERRACK).setFenceSettings(FenceSettings.NETHERRACK).setActivationSettings(ActivationSettings.NETHERRACK).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.NETHERRACK_BRICKS).setFenceSettings(FenceSettings.NETHERRACK).setActivationSettings(ActivationSettings.NETHERRACK).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.buildCircularPavingBlock(FACTORY.createEmpty(BlockusBlocks.NETHERRACK_CIRCULAR_PAVING).markStoneCuttable().setFenceSettings(FenceSettings.NETHERRACK).setActivationSettings(ActivationSettings.NETHERRACK));
        ExtShapeBlockusBlocks.create(BlockusBlocks.QUARTZ_TILES).setFenceSettings(FenceSettings.QUARTZ).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.buildCircularPavingBlock(FACTORY.createEmpty(BlockusBlocks.QUARTZ_CIRCULAR_PAVING).markStoneCuttable().setFenceSettings(FenceSettings.QUARTZ));
        ExtShapeBlockusBlocks.create(BlockusBlocks.MAGMA_BRICKS).setFenceSettings(FenceSettings.STONE).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.SMALL_MAGMA_BRICKS).setFenceSettings(FenceSettings.STONE).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.BLAZE_BRICKS).setStoneFenceSettings(class_1802.field_8894).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.BLAZE_LANTERN).setStoneFenceSettings(class_1802.field_8894).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.POLISHED_NETHER_BRICKS).setStoneFenceSettings(class_1802.field_8729).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.POLISHED_RED_NETHER_BRICKS).setStoneFenceSettings(class_1802.field_8729).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.HERRINGBONE_NETHER_BRICKS).setStoneFenceSettings(class_1802.field_8729).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.HERRINGBONE_RED_NETHER_BRICKS).setStoneFenceSettings(class_1802.field_8729).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.NETHER_TILES).setStoneFenceSettings(class_1802.field_8729).without(BlockShape.BUTTON).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.CHARRED_NETHER_BRICKS).setStoneFenceSettings(class_1802.field_8729).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.POLISHED_CHARRED_NETHER_BRICKS).setStoneFenceSettings(class_1802.field_8729).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.HERRINGBONE_CHARRED_NETHER_BRICKS).setStoneFenceSettings(class_1802.field_8729).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.TEAL_NETHER_BRICKS).setStoneFenceSettings(class_1802.field_8729).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.POLISHED_TEAL_NETHER_BRICKS).setStoneFenceSettings(class_1802.field_8729).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.HERRINGBONE_TEAL_NETHER_BRICKS).setStoneFenceSettings(class_1802.field_8729).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.buildCircularPavingBlock(FACTORY.createEmpty(BlockusBlocks.PRISMARINE_CIRCULAR_PAVING));
        ExtShapeBlockusBlocks.create(BlockusBlocks.PRISMARINE_TILES).setStoneFenceSettings(class_1802.field_8662).without(BlockShape.BUTTON).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.LARGE_BRICKS).setStoneFenceSettings(class_1802.field_8621).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.HERRINGBONE_BRICKS).setStoneFenceSettings(class_1802.field_8621).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.SOAKED_BRICKS).setStoneFenceSettings(class_1802.field_8621).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.HERRINGBONE_SOAKED_BRICKS).setStoneFenceSettings(class_1802.field_8621).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.CHARRED_BRICKS).setStoneFenceSettings(class_1802.field_8621).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.HERRINGBONE_CHARRED_BRICKS).setStoneFenceSettings(class_1802.field_8621).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.SANDY_BRICKS).setStoneFenceSettings(class_1802.field_8621).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.HERRINGBONE_SANDY_BRICKS).setStoneFenceSettings(class_1802.field_8621).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.LARGE_RESIN_BRICKS).setStoneFenceSettings(class_1802.field_55037).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.HERRINGBONE_RESIN_BRICKS).setStoneFenceSettings(class_1802.field_55037).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.ROUGH_SANDSTONE).setStoneFenceSettings(class_1802.field_8858).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.SANDSTONE_BRICKS).setStoneFenceSettings(class_1802.field_8858).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.SMALL_SANDSTONE_BRICKS).setStoneFenceSettings(class_1802.field_8858).without(BlockShape.BUTTON).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.ROUGH_RED_SANDSTONE).setStoneFenceSettings(class_1802.field_8200).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.RED_SANDSTONE_BRICKS).setStoneFenceSettings(class_1802.field_8200).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.SMALL_RED_SANDSTONE_BRICKS).setStoneFenceSettings(class_1802.field_8200).without(BlockShape.BUTTON).build();
        FACTORY.createConstructionOnly(BlockusBlocks.SOUL_SANDSTONE.block()).markStoneCuttable().setStoneFenceSettings(class_1802.field_8067).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.ROUGH_SOUL_SANDSTONE).setStoneFenceSettings(class_1802.field_8067).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.SOUL_SANDSTONE_BRICKS).setStoneFenceSettings(class_1802.field_8067).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.SMALL_SOUL_SANDSTONE_BRICKS).setStoneFenceSettings(class_1802.field_8067).without(BlockShape.BUTTON).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.SMOOTH_SOUL_SANDSTONE).setStoneFenceSettings(class_1802.field_8067).build();
        FACTORY.createConstructionOnly(BlockusBlocks.CUT_SOUL_SANDSTONE).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.RAINBOW_BLOCK).setStoneFenceSettings(BlockusBlocks.RAINBOW_PETALS.method_8389()).setPillar().build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.RAINBOW_BRICKS).setStoneFenceSettings(BlockusBlocks.RAINBOW_PETALS.method_8389()).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.RAINBOW_GLOWSTONE).setFenceSettings(new FenceSettings(BlockusBlocks.RAINBOW_PETALS.method_8389(), ExtShapeBlockTypes.GLOWSTONE_WOOD_TYPE)).setActivationSettings(ActivationSettings.stone((class_8177)ExtShapeBlockTypes.GLOWSTONE_BLOCK_SET_TYPE)).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.HONEYCOMB_BRICKS).setStoneFenceSettings(class_1802.field_20414).without(BlockShape.BUTTON).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.PURPUR_BRICKS).setStoneFenceSettings(class_1802.field_20393).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.SMALL_PURPUR_BRICKS).setStoneFenceSettings(class_1802.field_20393).without(BlockShape.BUTTON).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.POLISHED_PURPUR).setStoneFenceSettings(class_1802.field_20393).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.PURPUR_SQUARES).setStoneFenceSettings(class_1802.field_20393).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.PHANTOM_PURPUR_BRICKS).setStoneFenceSettings(class_1802.field_8614).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.SMALL_PHANTOM_PURPUR_BRICKS).setStoneFenceSettings(class_1802.field_8614).without(BlockShape.BUTTON).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.PHANTOM_PURPUR_BLOCK).setStoneFenceSettings(class_1802.field_8614).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.POLISHED_PHANTOM_PURPUR).setStoneFenceSettings(class_1802.field_8614).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.PHANTOM_PURPUR_SQUARES).setStoneFenceSettings(class_1802.field_8614).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.POLISHED_END_STONE).setStoneFenceSettings(class_1802.field_20400).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.SMALL_END_STONE_BRICKS).setStoneFenceSettings(class_1802.field_20400).without(BlockShape.BUTTON).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.HERRINGBONE_END_STONE_BRICKS).setStoneFenceSettings(class_1802.field_20400).without(new BlockShape[]{BlockShape.BUTTON, BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.END_TILES).setStoneFenceSettings(class_1802.field_20400).without(BlockShape.BUTTON).build();
        markStoneCuttableWhenCreating = false;
        BiConsumer<BlockShape, AbstractBlockBuilder> logFlammable = (blockShape, blockBuilder) -> FlammableBlockRegistry.getDefaultInstance().add(blockBuilder.instance, 5, 5);
        FACTORY.createAllShapes(BlockusBlocks.WHITE_OAK_WOOD).setActivationSettings(ActivationSettings.wood((class_8177)class_8177.field_42823)).setPillar().addPostBuildConsumer(logFlammable).fuelTime(300).build();
        FACTORY.createAllShapes(BlockusBlocks.STRIPPED_WHITE_OAK_WOOD).setActivationSettings(ActivationSettings.wood((class_8177)class_8177.field_42823)).setPillar().addPostBuildConsumer(logFlammable).fuelTime(300).build();
        BiConsumer<BlockShape, AbstractBlockBuilder> plankFlammable = (blockShape, blockBuilder) -> FlammableBlockRegistry.getDefaultInstance().add(blockBuilder.instance, 5, 20);
        ExtShapeBlockusBlocks.create(BlockusBlocks.WHITE_OAK).setActivationSettings(ActivationSettings.wood((class_8177)class_8177.field_42823)).addPostBuildConsumer(plankFlammable).fuelTime(300).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.RAW_BAMBOO).setActivationSettings(ActivationSettings.BAMBOO).setFenceSettings(new FenceSettings(class_1802.field_8648, class_4719.field_40350)).addPostBuildConsumer(plankFlammable).fuelTime(300).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.CHARRED).setActivationSettings(ActivationSettings.wood((class_8177)class_8177.field_42823)).build();
        BlockusBlocks.WOODEN_MOSAIC.bundle().forEach((woodType, bsswBundle) -> {
            boolean isNonFlammable = woodType.equals(WoodMaps.WARPED.getId()) || woodType.equals(WoodMaps.CRIMSON.getId()) || woodType.equals(WoodMaps.CHARRED.getId());
            BlocksBuilder builder = FACTORY.createConstructionOnly(bsswBundle.block()).without(new BlockShape[]{BlockShape.STAIRS, BlockShape.SLAB}).with(BlockShape.WALL).setRecipeGroup(blockShape -> "wooden_mosaic_" + blockShape.method_15434());
            if (isNonFlammable) {
                builder.build();
            } else {
                builder.addPostBuildConsumer(plankFlammable).build();
            }
        });
        BlockusBlocks.MOSSY_PLANKS.bundle().forEach((woodType, bsswBundle) -> {
            boolean isNonFlammable;
            boolean bl = isNonFlammable = woodType.equals(WoodMaps.WARPED.getId()) || woodType.equals(WoodMaps.CRIMSON.getId()) || woodType.equals(WoodMaps.CHARRED.getId());
            if (isNonFlammable) {
                FACTORY.createConstructionOnly(bsswBundle.block()).without(new BlockShape[]{BlockShape.STAIRS, BlockShape.SLAB}).with(BlockShape.WALL).setRecipeGroup(blockShape -> "mossy_wooden_" + blockShape.method_15434()).build();
            } else {
                FACTORY.createConstructionOnly(bsswBundle.block()).without(new BlockShape[]{BlockShape.STAIRS, BlockShape.SLAB}).with(BlockShape.WALL).addPostBuildConsumer(plankFlammable).fuelTime(300).setRecipeGroup(blockShape -> "mossy_wooden_" + blockShape.method_15434()).build();
            }
        });
        BlockusBlocks.HERRINGBONE_PLANKS.bundle().forEach((woodType, block) -> {
            boolean isNonFlammable;
            boolean bl = isNonFlammable = woodType.equals(WoodMaps.WARPED.getId()) || woodType.equals(WoodMaps.CRIMSON.getId()) || woodType.equals(WoodMaps.CHARRED.getId());
            if (isNonFlammable) {
                FACTORY.createConstructionOnly(block).with(BlockShape.WALL).setRecipeGroup(blockShape -> "herringbone_wooden_" + blockShape.method_15434()).build();
            } else {
                FACTORY.createConstructionOnly(block).with(BlockShape.WALL).addPostBuildConsumer(plankFlammable).fuelTime(300).setRecipeGroup(blockShape -> "herringbone_wooden_" + blockShape.method_15434()).build();
            }
        });
        BlockusBlocks.SMALL_LOGS.bundle().forEach((woodType, block) -> {
            if (woodType.equals(WoodMaps.CRIMSON.getId()) || woodType.equals(WoodMaps.WARPED.getId()) || woodType.equals(WoodMaps.CHARRED.getId())) {
                FACTORY.createConstructionOnly(block).setPillar().setRecipeGroup(blockShape -> "small_logs_" + blockShape.method_15434()).build();
            } else {
                FACTORY.createConstructionOnly(block).setPillar().addPostBuildConsumer(logFlammable).fuelTime(300).setRecipeGroup(blockShape -> "small_logs_" + blockShape.method_15434()).build();
            }
        });
        markStoneCuttableWhenCreating = true;
        ExtShapeBlockusBlocks.create(BlockusBlocks.CHOCOLATE_BLOCK).setFenceSettings(FenceSettings.STONE).setActivationSettings(ActivationSettings.STONE).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.CHOCOLATE_BRICKS).setFenceSettings(FenceSettings.STONE).setActivationSettings(ActivationSettings.STONE).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.CHOCOLATE_SQUARES).setFenceSettings(FenceSettings.STONE).setActivationSettings(ActivationSettings.STONE).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.IRON_BRICKS).withoutRedstone().without(new BlockShape[]{BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.GOLD_BRICKS).withoutRedstone().without(new BlockShape[]{BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.LAPIS_BRICKS).withoutRedstone().without(new BlockShape[]{BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.REDSTONE_BRICKS).withExtension(BlockExtension.builder().setEmitsRedstonePower((state, original) -> true).setWeakRedstonePower((state, world, pos, direction, original) -> 15).build()).withoutRedstone().without(new BlockShape[]{BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.EMERALD_BRICKS).withoutRedstone().without(new BlockShape[]{BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.DIAMOND_BRICKS).withoutRedstone().without(new BlockShape[]{BlockShape.FENCE, BlockShape.FENCE_GATE}).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.NETHERITE_BRICKS).withoutRedstone().without(new BlockShape[]{BlockShape.FENCE, BlockShape.FENCE_GATE}).addPostBuildConsumer((blockShape, abstractBlockBuilder) -> abstractBlockBuilder.itemSettings.method_24359()).build();
        markStoneCuttableWhenCreating = false;
        ExtShapeBlockusBlocks.create(BlockusBlocks.CHORUS_BLOCK).setStoneFenceSettings(class_1802.field_8358).setPillar().build();
        for (BSSWBundle bsswBundle2 : BlockusBlocks.STAINED_STONE_BRICKS.colorMap().values()) {
            ExtShapeBlockusBlocks.create(bsswBundle2).markStoneCuttable().setRecipeGroup(blockShape -> "stained_stone_brick_" + blockShape.method_15434()).setActivationSettings(ActivationSettings.STONE).setFenceSettings(FenceSettings.STONE).without(BlockShape.BUTTON).build();
        }
        BlockusBlocks.CONCRETE_BRICKS.colorMap().forEach((dyeColor, concreteVariants) -> FACTORY.createConstructionOnly(concreteVariants.block()).markStoneCuttable().without(new BlockShape[]{BlockShape.BUTTON, BlockShape.STAIRS, BlockShape.SLAB, BlockShape.WALL}).setRecipeGroup(blockShape1 -> "concrete_brick_" + blockShape1.method_15434()).setActivationSettings(ActivationSettings.STONE).setFenceSettings(FenceSettings.STONE).build());
        ExtShapeBlockusBlocks.create(BlockusBlocks.SHINGLES).markStoneCuttable().setActivationSettings(ActivationSettings.STONE).setFenceSettings(FenceSettings.STONE).build();
        for (BSSWBundle bssTypes : BlockusBlocks.STAINED_SHINGLES.colorMap().values()) {
            ExtShapeBlockusBlocks.create(bssTypes).markStoneCuttable().setActivationSettings(ActivationSettings.STONE).setFenceSettings(FenceSettings.STONE).setRecipeGroup(blockShape -> "shingles_" + blockShape.method_15434()).build();
        }
        for (WoolBundle woolTypes : List.of(BlockusBlocks.PATTERNED_WOOL, BlockusBlocks.GINGHAM_WOOL)) {
            woolTypes.colorMap().forEach((dyeColor, woolVariants) -> FACTORY.createAllShapes(woolVariants.block()).without(new BlockShape[]{BlockShape.STAIRS, BlockShape.SLAB, BlockShape.BUTTON}).addPreBuildConsumer((blockShape, blockBuilder) -> {
                if (blockShape == BlockShape.PRESSURE_PLATE) {
                    ((PressurePlateBuilder)blockBuilder).setInstanceSupplier(x -> new WoolPressurePlate(x.baseBlock, x.blockSettings, ((PressurePlateBuilder)x).activationSettings, woolVariants.carpet()));
                }
            }).addPostBuildConsumer((blockShape, blockBuilder) -> FlammableBlockRegistry.getDefaultInstance().add(blockBuilder.instance, 30, 60)).fuelTime(100).setRecipeGroup(blockShape -> "patterned_wool_" + blockShape.method_15434()).setActivationSettings(ActivationSettings.WOOL).setFenceSettings(FenceSettings.WOOL).build());
        }
        for (class_2248 block2 : BlockusBlocks.GLAZED_TERRACOTTA_PILLAR.colorMap().values()) {
            FACTORY.createConstructionOnly(block2).markStoneCuttable().with(BlockShape.WALL).setRecipeGroup(blockShape -> "glazed_terracotta_pillar_" + blockShape.method_15434()).setPillar().build();
        }
        ExtShapeBlockusBlocks.create(BlockusBlocks.THATCH).addPostBuildConsumer((blockShape4, blockBuilder3) -> {
            FlammableBlockRegistry.getDefaultInstance().add(blockBuilder3.instance, 60, 20);
            CompostingChanceRegistry.INSTANCE.add((class_1935)blockBuilder3.instance, (Object)Float.valueOf(blockShape4.logicalCompleteness * 0.75f));
        }).setActivationSettings(ActivationSettings.soft((class_8177)ExtShapeBlockusBlockTypes.GRASS_BLOCK_SET_TYPE)).setFenceSettings(new FenceSettings(class_1802.field_8861, ExtShapeBlockusBlockTypes.GRASS_BLOCK_WOOD_TYPE)).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.PAPER_BLOCK).addPostBuildConsumer((blockShape3, blockBuilder2) -> FlammableBlockRegistry.getDefaultInstance().add(blockBuilder2.instance, 30, 60)).fuelTime(100).setActivationSettings(ActivationSettings.soft((class_8177)ExtShapeBlockusBlockTypes.GRASS_BLOCK_SET_TYPE)).setFenceSettings(new FenceSettings(class_1802.field_8407, ExtShapeBlockusBlockTypes.GRASS_BLOCK_WOOD_TYPE)).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.BURNT_PAPER_BLOCK).addPostBuildConsumer((blockShape2, blockBuilder1) -> FlammableBlockRegistry.getDefaultInstance().add(blockBuilder1.instance, 5, 60)).setActivationSettings(ActivationSettings.soft((class_8177)ExtShapeBlockusBlockTypes.GRASS_BLOCK_SET_TYPE)).setFenceSettings(new FenceSettings(class_1802.field_8054, ExtShapeBlockusBlockTypes.GRASS_BLOCK_WOOD_TYPE)).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.IRON_PLATING).markStoneCuttable().without(new BlockShape[]{BlockShape.FENCE, BlockShape.FENCE_GATE, BlockShape.BUTTON}).setActivationSettings(ActivationSettings.IRON).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.GOLD_PLATING).markStoneCuttable().without(new BlockShape[]{BlockShape.FENCE, BlockShape.FENCE_GATE, BlockShape.BUTTON}).setActivationSettings(ActivationSettings.GOLD).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.CHARCOAL_BLOCK).markStoneCuttable().setStoneFenceSettings(class_1802.field_8665).fuelTime(16000).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.ENDER_BLOCK).markStoneCuttable().setStoneFenceSettings(class_1802.field_8634).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.ROTTEN_FLESH_BLOCK).setActivationSettings(ActivationSettings.soft((class_8177)ExtShapeBlockTypes.SLIME_BLOCK_SET_TYPE)).setFenceSettings(new FenceSettings(class_1802.field_8511, ExtShapeBlockTypes.SLIME_WOOD_TYPE)).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.MEMBRANE_BLOCK).setFenceSettings(new FenceSettings(class_1802.field_8614, ExtShapeBlockTypes.SLIME_WOOD_TYPE)).setActivationSettings(ActivationSettings.soft((class_8177)ExtShapeBlockTypes.SLIME_BLOCK_SET_TYPE)).build();
        FACTORY.createAllShapes(BlockusBlocks.NETHER_STAR_BLOCK).markStoneCuttable().withoutRedstone().setStoneFenceSettings(class_1802.field_8137).withExtension(BlockExtension.builder().setSteppedOnCallback((world, pos, state, entity) -> {
            if (entity.method_5864() == class_1299.field_6097) {
                ((class_1309)entity).method_6092(new class_1293(class_1294.field_5924, 1, 3, true, false, false));
                ((class_1309)entity).method_6092(new class_1293(class_1294.field_5898, 900, 3, true, false, true));
                ((class_1309)entity).method_6092(new class_1293(class_1294.field_5910, 80, 2, true, false, true));
            }
        }).build()).addPreBuildConsumer((blockShape, builder) -> {
            builder.setItemSettings(new class_1792.class_1793().method_7894(class_1814.field_8903));
            builder.setItemInstanceSupplier(builder0 -> new ExtShapeBlockItem(builder0.instance, builder0.itemSettings.method_7894(class_1814.field_8907)){

                public boolean method_7886(class_1799 stack) {
                    return true;
                }

                public void method_67187(class_1799 stack, class_1792.class_9635 context, class_10712 displayComponent, Consumer<class_2561> textConsumer, class_1836 type) {
                    super.method_67187(stack, context, displayComponent, textConsumer, type);
                    textConsumer.accept(class_5244.field_39003);
                    textConsumer.accept(Blockus.STEPPED_ON_TEXT);
                    textConsumer.accept((class_2561)class_5244.method_48320().method_10852(((class_1291)class_1294.field_5924.comp_349()).method_5560()).method_27693(" IV").method_27692(class_124.field_1078));
                    textConsumer.accept((class_2561)class_5244.method_48320().method_10852(((class_1291)class_1294.field_5898.comp_349()).method_5560()).method_27693(" IV").method_27692(class_124.field_1078).method_27693(" - 00:45"));
                    textConsumer.accept((class_2561)class_5244.method_48320().method_10852(((class_1291)class_1294.field_5910.comp_349()).method_5560()).method_27693(" III").method_27692(class_124.field_1078).method_27693(" - 00:04"));
                }
            });
        }).build();
        ExtShapeBlockusBlocks.create(BlockusBlocks.STARS_BLOCK).markStoneCuttable().setStoneFenceSettings(class_1802.field_8713).build();
    }
}

