/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.extshape.blockus;

import com.brand.blockus.itemgroups.BlockusItemGroups;
import com.brand.blockus.registry.content.BlockusBlocks;
import com.brand.blockus.registry.content.bundles.BSSWBundle;
import com.google.common.collect.BiMap;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1761;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import pers.solid.extshape.VanillaItemGroup;
import pers.solid.extshape.blockus.ExtShapeBlockus;
import pers.solid.extshape.blockus.ExtShapeBlockusBlocks;
import pers.solid.extshape.builder.BlockShape;
import pers.solid.extshape.config.ExtShapeConfig;
import pers.solid.extshape.util.BlockBiMaps;
import pers.solid.extshape.util.EntryVariantAppender;

public final class ExtShapeBlockusItemGroup {
    private static final class_2960 ADD_EXTRA_ITEMS = ExtShapeBlockus.id("add_extra_items");
    private static final ImmutableSet<class_2248> SPECIAL_SORTED_RAINBOW_BLOCKS = (ImmutableSet)Streams.concat((Stream[])new Stream[]{BlockusBlocks.STAINED_SHINGLES.colorMap().values().stream().map(BSSWBundle::block), BlockusBlocks.STAINED_STONE_BRICKS.colorMap().values().stream().map(BSSWBundle::block), Stream.of(BlockusBlocks.SHINGLES).map(BSSWBundle::block)}).collect(ImmutableSet.toImmutableSet());

    private ExtShapeBlockusItemGroup() {
    }

    public static void addVanillaGroupRules(Collection<BlockShape> shapes) {
        Multimap buildingAppendingRule = VanillaItemGroup.getAppendingRule((class_5321)BlockusItemGroups.BLOCKUS_BUILDING_BLOCKS);
        new EntryVariantAppender(BlockusItemGroups.BLOCKUS_BUILDING_BLOCKS, shapes, ExtShapeBlockusBlocks.BLOCKUS_BASE_BLOCKS, arg_0 -> ExtShapeBlockusBlocks.BLOCKUS_BLOCKS.contains(arg_0)).appendItems(buildingAppendingRule);
        Multimap coloredAppendingRule = VanillaItemGroup.getAppendingRule((class_5321)BlockusItemGroups.BLOCKUS_COLORED_BLOCKS);
        Multimap coloredTilesAppendingRule = VanillaItemGroup.getAppendingRule((class_5321)BlockusItemGroups.BLOCKUS_COLORED_TILES);
        new EntryVariantAppender(BlockusItemGroups.BLOCKUS_COLORED_BLOCKS, shapes, Iterables.filter(ExtShapeBlockusBlocks.BLOCKUS_BASE_BLOCKS, input -> !SPECIAL_SORTED_RAINBOW_BLOCKS.contains(input)), arg_0 -> ExtShapeBlockusBlocks.BLOCKUS_BLOCKS.contains(arg_0)).appendItems(coloredAppendingRule);
        new EntryVariantAppender(BlockusItemGroups.BLOCKUS_COLORED_TILES, shapes, Iterables.filter(ExtShapeBlockusBlocks.BLOCKUS_BASE_BLOCKS, input -> !SPECIAL_SORTED_RAINBOW_BLOCKS.contains(input)), arg_0 -> ExtShapeBlockusBlocks.BLOCKUS_BLOCKS.contains(arg_0)).appendItems(coloredTilesAppendingRule);
        class_1792 shingleAnchor = ((BSSWBundle)BlockusBlocks.STAINED_SHINGLES.colorMap().get(class_1767.field_7954)).slab().method_8389();
        class_1792 stainedStoneBrickAnchor = ((BSSWBundle)BlockusBlocks.STAINED_STONE_BRICKS.colorMap().get(class_1767.field_7954)).wall().method_8389();
        for (BlockShape blockShape : ExtShapeConfig.CURRENT_CONFIG.shapesToAddToVanilla) {
            class_2248 block;
            BiMap biMap = BlockBiMaps.of((BlockShape)blockShape);
            class_2248 block1 = (class_2248)biMap.get((Object)BlockusBlocks.SHINGLES.block());
            if (block1 != null && ExtShapeBlockusBlocks.BLOCKUS_BLOCKS.contains((Object)block1)) {
                coloredAppendingRule.put((Object)shingleAnchor, (Object)block1.method_8389());
            }
            for (BSSWBundle bsswBundle : BlockusBlocks.STAINED_SHINGLES.colorMap().values()) {
                block = (class_2248)biMap.get((Object)bsswBundle.block());
                if (block == null || !ExtShapeBlockusBlocks.BLOCKUS_BLOCKS.contains((Object)block)) continue;
                coloredAppendingRule.put((Object)shingleAnchor, (Object)block.method_8389());
            }
            for (BSSWBundle bsswBundle : BlockusBlocks.STAINED_STONE_BRICKS.colorMap().values()) {
                block = (class_2248)biMap.get((Object)bsswBundle.block());
                if (block == null || !ExtShapeBlockusBlocks.BLOCKUS_BLOCKS.contains((Object)block)) continue;
                coloredAppendingRule.put((Object)stainedStoneBrickAnchor, (Object)block.method_8389());
            }
        }
    }

    public static void registerEvent() {
        VanillaItemGroup.UPDATE_SHAPES_EVENT.register(() -> ExtShapeBlockusItemGroup.addVanillaGroupRules(ExtShapeConfig.CURRENT_CONFIG.shapesToAddToVanilla));
        ExtShapeBlockusItemGroup.addModifyEntriesEvent((class_5321<class_1761>)BlockusItemGroups.BLOCKUS_BUILDING_BLOCKS);
        ExtShapeBlockusItemGroup.addModifyEntriesEvent((class_5321<class_1761>)BlockusItemGroups.BLOCKUS_COLORED_BLOCKS);
        ExtShapeBlockusItemGroup.addModifyEntriesEvent((class_5321<class_1761>)BlockusItemGroups.BLOCKUS_COLORED_TILES);
    }

    private static void addModifyEntriesEvent(class_5321<class_1761> itemGroup) {
        Event event = ItemGroupEvents.modifyEntriesEvent(itemGroup);
        event.addPhaseOrdering(Event.DEFAULT_PHASE, ADD_EXTRA_ITEMS);
        event.register(ADD_EXTRA_ITEMS, entries -> {
            class_1792 item;
            if (!ExtShapeConfig.CURRENT_CONFIG.addToVanillaGroups) {
                return;
            }
            List displayStacks = entries.getDisplayStacks();
            List searchTabStacks = entries.getSearchTabStacks();
            Multimap prependingRule = VanillaItemGroup.getPrependingRule((class_5321)itemGroup);
            Multimap appendingRule = VanillaItemGroup.getAppendingRule((class_5321)itemGroup);
            List<class_1799> immutableDisplayStacks = List.copyOf(displayStacks);
            List<class_1799> immutableSearchTabStacks = List.copyOf(searchTabStacks);
            displayStacks.clear();
            searchTabStacks.clear();
            for (class_1799 stack : immutableDisplayStacks) {
                item = stack.method_7909();
                displayStacks.addAll(Collections2.transform((Collection)prependingRule.get((Object)item), class_1799::new));
                displayStacks.add(stack);
                displayStacks.addAll(Collections2.transform((Collection)appendingRule.get((Object)item), class_1799::new));
            }
            for (class_1799 stack : immutableSearchTabStacks) {
                item = stack.method_7909();
                searchTabStacks.addAll(Collections2.transform((Collection)prependingRule.get((Object)item), class_1799::new));
                searchTabStacks.add(stack);
                searchTabStacks.addAll(Collections2.transform((Collection)appendingRule.get((Object)item), class_1799::new));
            }
        });
    }
}

