/*
 * Decompiled with CFR 0.152.
 */
package igentuman.blockbooster.client.screen;

import igentuman.blockbooster.client.screen.element.CheckBox;
import igentuman.blockbooster.container.BoosterManaContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BoosterManaScreen
extends AbstractContainerScreen<BoosterManaContainer> {
    private final ResourceLocation GUI = new ResourceLocation("blockbooster", "textures/gui/blockbooster_mana_gui.png");
    private List<CheckBox> checkboxes = new ArrayList<CheckBox>();

    public BoosterManaScreen(BoosterManaContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.f_97726_ = 180;
        this.f_97727_ = 152;
    }

    public void m_7286_(GuiGraphics graphics, float pPartialTick, int pMouseX, int pMouseY) {
        this.m_280273_(graphics);
        int relX = (this.f_96543_ - this.f_97726_) / 2;
        int relY = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280218_(this.GUI, relX, relY, 0, 0, this.f_97726_, this.f_97727_);
        this.m_280072_(graphics, pMouseX, pMouseY);
        this.drawManaBar(graphics);
        this.drawAttachedBlocks(graphics);
        this.drawTPSIndicator(graphics);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.checkboxes.clear();
        this.checkboxes.add(new CheckBox(this.getGuiLeft() + 28, this.getGuiTop() + 15, 13, 13, 181, 0, 13, this.GUI, btn -> this.checkboxClicked(btn, 0)));
        this.checkboxes.add(new CheckBox(this.getGuiLeft() + 28, this.getGuiTop() + 35, 13, 13, 181, 0, 13, this.GUI, btn -> this.checkboxClicked(btn, 1)));
        this.checkboxes.add(new CheckBox(this.getGuiLeft() + 28, this.getGuiTop() + 55, 13, 13, 181, 0, 13, this.GUI, btn -> this.checkboxClicked(btn, 2)));
        this.checkboxes.add(new CheckBox(this.getGuiLeft() + 28, this.getGuiTop() + 75, 13, 13, 181, 0, 13, this.GUI, btn -> this.checkboxClicked(btn, 3)));
        this.checkboxes.add(new CheckBox(this.getGuiLeft() + 28, this.getGuiTop() + 95, 13, 13, 181, 0, 13, this.GUI, btn -> this.checkboxClicked(btn, 4)));
        this.checkboxes.add(new CheckBox(this.getGuiLeft() + 28, this.getGuiTop() + 115, 13, 13, 181, 0, 13, this.GUI, btn -> this.checkboxClicked(btn, 5)));
        for (Button button : this.checkboxes) {
            this.m_142416_((GuiEventListener)button);
        }
    }

    public Button.OnPress checkboxClicked(Button btn, int id) {
        if (this.checkboxes == null) {
            return AbstractButton::m_5691_;
        }
        CheckBox checkBox = this.checkboxes.get(id);
        int val = 0;
        if (!checkBox.isChecked()) {
            val = 1;
        }
        ((BoosterManaContainer)this.f_97732_).checkboxClicked(id, val);
        return checkBox::onPress;
    }

    public void m_181908_() {
        super.m_181908_();
        byte[] boostFlags = ((BoosterManaContainer)this.f_97732_).getBoostFlags();
        int i = 0;
        for (byte flag : boostFlags) {
            this.checkboxes.get(i).setChecked(flag == 1);
            ++i;
        }
    }

    protected HashMap<Integer, BlockEntity> getAttachedBlocks() {
        return ((BoosterManaContainer)this.f_97732_).getAttachedBlocks();
    }

    public void drawManaBar(GuiGraphics graphics) {
        graphics.m_280218_(this.GUI, this.getGuiLeft() + 4, this.getGuiTop() + 140, 0, 153, ((BoosterManaContainer)this.f_97732_).getManaScaled(171), 7);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280137_(Minecraft.m_91087_().f_91062_, I18n.m_118938_((String)"gui.block_booster", (Object[])new Object[0]), this.f_97726_ / 2, 4, 0xFFFFFF);
        if (((BoosterManaContainer)this.f_97732_).isDisabled()) {
            graphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"gui.block_booster.disabled"), 10, 65, 0xFFFFFF);
        }
    }

    public void m_280072_(GuiGraphics graphics, int x, int y) {
        if (x > this.getGuiLeft() + 4 && x < this.getGuiLeft() + 175 && y > this.getGuiTop() + 139 && y < this.getGuiTop() + 149) {
            MutableComponent textComponent = Component.m_237110_((String)"gui.mana.info", (Object[])new Object[]{((BoosterManaContainer)this.f_97732_).getMana(), ((BoosterManaContainer)this.f_97732_).getMaxMana()});
            graphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)textComponent, x, y);
            return;
        }
        int tpsX = this.getGuiLeft() + 165;
        int tpsY = this.getGuiTop() + 4;
        if (x >= tpsX && x < tpsX + 8 && y >= tpsY && y < tpsY + 8) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            if (((BoosterManaContainer)this.f_97732_).isLagging()) {
                tooltip.add(Component.m_237115_((String)"gui.tps.lagging"));
                tooltip.add(Component.m_237110_((String)"gui.tps.current", (Object[])new Object[]{String.format("%.1f", ((BoosterManaContainer)this.f_97732_).getCurrentTPS())}));
                tooltip.add(Component.m_237115_((String)"gui.tps.boosting_paused"));
            } else {
                tooltip.add(Component.m_237115_((String)"gui.tps.ok"));
                tooltip.add(Component.m_237110_((String)"gui.tps.current", (Object[])new Object[]{String.format("%.1f", ((BoosterManaContainer)this.f_97732_).getCurrentTPS())}));
            }
            graphics.m_280677_(Minecraft.m_91087_().f_91062_, tooltip, Optional.empty(), x, y);
            return;
        }
        HashMap<Integer, BlockEntity> attachedBlocks = ((BoosterManaContainer)this.f_97732_).getAttachedBlocks();
        int blockIconX = this.getGuiLeft() + 9;
        int blockIconSize = 16;
        int blockSpacing = 20;
        int startY = this.getGuiTop() + 14;
        for (Integer i : attachedBlocks.keySet()) {
            BlockEntity be = attachedBlocks.get(i);
            if (be == null || be.m_58901_()) continue;
            int blockY = startY + i * blockSpacing;
            if (x < blockIconX || x >= blockIconX + blockIconSize || y < blockY || y >= blockY + blockIconSize) continue;
            ItemStack blockStack = new ItemStack((ItemLike)be.m_58900_().m_60734_().m_5456_());
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.m_237115_((String)blockStack.m_41778_()));
            tooltip.add(Component.m_237113_((String)be.m_58899_().m_123344_()));
            graphics.m_280677_(Minecraft.m_91087_().f_91062_, tooltip, Optional.empty(), x, y);
            return;
        }
    }

    private void drawAttachedBlocks(GuiGraphics graphics) {
        int y = 14;
        for (Integer i : ((BoosterManaContainer)this.f_97732_).getAttachedBlocks().keySet()) {
            graphics.m_280480_(new ItemStack((ItemLike)((BoosterManaContainer)this.f_97732_).getAttachedBlocks().get(i).m_58900_().m_60734_().m_5456_()), this.getGuiLeft() + 9, this.getGuiTop() + i * 20 + y);
        }
    }

    private void drawTPSIndicator(GuiGraphics graphics) {
        int x = this.getGuiLeft() + 165;
        int y = this.getGuiTop() + 4;
        int size = 8;
        int color = ((BoosterManaContainer)this.f_97732_).isLagging() ? -65536 : -16711936;
        graphics.m_280509_(x, y, x + size, y + size, color);
        graphics.m_280509_(x, y, x + size, y + 1, -16777216);
        graphics.m_280509_(x, y + size - 1, x + size, y + size, -16777216);
        graphics.m_280509_(x, y, x + 1, y + size, -16777216);
        graphics.m_280509_(x + size - 1, y, x + size, y + size, -16777216);
    }
}

