/*
 * Decompiled with CFR 0.152.
 */
package igentuman.blockbooster.client.screen;

import igentuman.blockbooster.client.screen.element.CheckBox;
import igentuman.blockbooster.container.BoosterT3Container;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BoosterT3Screen
extends AbstractContainerScreen<BoosterT3Container> {
    private final ResourceLocation GUI = new ResourceLocation("blockbooster", "textures/gui/blockbooster_t2_gui.png");
    private List<CheckBox> checkboxes = new ArrayList<CheckBox>();
    private int scrollOffset = 0;
    private int maxVisibleItems = 6;
    private int totalItems = 0;

    public BoosterT3Screen(BoosterT3Container container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.f_97726_ = 180;
        this.f_97727_ = 152;
    }

    public void m_7286_(GuiGraphics graphics, float pPartialTick, int pMouseX, int pMouseY) {
        this.m_280273_(graphics);
        int relX = (this.f_96543_ - this.f_97726_) / 2;
        int relY = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280218_(this.GUI, relX, relY, 0, 0, this.f_97726_, this.f_97727_);
        this.m_280072_(graphics, pMouseX, pMouseY);
        this.drawEnergyBar(graphics);
        this.drawAttachedBlocks(graphics);
        this.drawScrollBar(graphics);
        this.drawTPSIndicator(graphics);
    }

    public void m_280072_(GuiGraphics graphics, int x, int y) {
        if (x > this.getGuiLeft() + 4 && x < this.getGuiLeft() + 175 && y > this.getGuiTop() + 139 && y < this.getGuiTop() + 149) {
            MutableComponent textComponent = Component.m_237110_((String)"gui.energy.info", (Object[])new Object[]{((BoosterT3Container)this.f_97732_).getEnergy(), ((BoosterT3Container)this.f_97732_).getMaxEnergy()});
            graphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)textComponent, x, y);
            return;
        }
        int tpsX = this.getGuiLeft() + 165;
        int tpsY = this.getGuiTop() + 4;
        if (x >= tpsX && x < tpsX + 8 && y >= tpsY && y < tpsY + 8) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            if (((BoosterT3Container)this.f_97732_).isLagging()) {
                tooltip.add(Component.m_237115_((String)"gui.tps.lagging"));
                tooltip.add(Component.m_237110_((String)"gui.tps.current", (Object[])new Object[]{String.format("%.1f", ((BoosterT3Container)this.f_97732_).getCurrentTPS())}));
                tooltip.add(Component.m_237115_((String)"gui.tps.boosting_paused"));
            } else {
                tooltip.add(Component.m_237115_((String)"gui.tps.ok"));
                tooltip.add(Component.m_237110_((String)"gui.tps.current", (Object[])new Object[]{String.format("%.1f", ((BoosterT3Container)this.f_97732_).getCurrentTPS())}));
            }
            graphics.m_280677_(Minecraft.m_91087_().f_91062_, tooltip, Optional.empty(), x, y);
            return;
        }
        HashMap<Integer, BlockEntity> attachedBlocks = ((BoosterT3Container)this.f_97732_).getAttachedBlocks();
        HashMap<Integer, Long> boostTimes = ((BoosterT3Container)this.f_97732_).getBoostTimes();
        ArrayList<Integer> sortedKeys = new ArrayList<Integer>(attachedBlocks.keySet());
        sortedKeys.sort(Integer::compareTo);
        int blockIconX = this.getGuiLeft() + 9;
        int blockIconSize = 16;
        int blockSpacing = 20;
        int startY = this.getGuiTop() + 14;
        int displayIndex = 0;
        for (int i = this.scrollOffset; i < Math.min(this.scrollOffset + this.maxVisibleItems, sortedKeys.size()); ++i) {
            Integer key = (Integer)sortedKeys.get(i);
            BlockEntity be = attachedBlocks.get(key);
            if (be != null && !be.m_58901_()) {
                int blockY = startY + displayIndex * blockSpacing;
                if (x >= blockIconX && x < blockIconX + blockIconSize && y >= blockY && y < blockY + blockIconSize) {
                    ItemStack blockStack = new ItemStack((ItemLike)be.m_58900_().m_60734_().m_5456_());
                    ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
                    tooltip.add(Component.m_237115_((String)blockStack.m_41778_()));
                    tooltip.add(Component.m_237113_((String)be.m_58899_().m_123344_()));
                    Long boostTime = boostTimes.get(key);
                    if (boostTime != null && boostTime > 0L) {
                        double timeMs = (double)boostTime.longValue() / 1000000.0;
                        tooltip.add(Component.m_237110_((String)"gui.boost.time", (Object[])new Object[]{String.format("%.3f", timeMs)}));
                        if (((BoosterT3Container)this.f_97732_).isSlowBlock(key)) {
                            tooltip.add(Component.m_237115_((String)"gui.boost.slow_block"));
                        }
                    }
                    graphics.m_280677_(Minecraft.m_91087_().f_91062_, tooltip, Optional.empty(), x, y);
                    return;
                }
            }
            ++displayIndex;
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.updateCheckboxes();
    }

    private void updateCheckboxes() {
        for (CheckBox checkbox : this.checkboxes) {
            this.m_169411_((GuiEventListener)checkbox);
        }
        this.checkboxes.clear();
        this.totalItems = ((BoosterT3Container)this.f_97732_).getAttachedBlocks().size();
        for (int i = 0; i < Math.min(this.maxVisibleItems, this.totalItems - this.scrollOffset); ++i) {
            int actualIndex = i + this.scrollOffset;
            CheckBox checkbox = new CheckBox(this.getGuiLeft() + 28, this.getGuiTop() + 15 + i * 20, 13, 13, 181, 0, 13, this.GUI, btn -> this.checkboxClicked(btn, actualIndex));
            this.checkboxes.add(checkbox);
            this.m_142416_((GuiEventListener)checkbox);
        }
    }

    public Button.OnPress checkboxClicked(Button btn, int id) {
        if (this.checkboxes == null) {
            return AbstractButton::m_5691_;
        }
        int localIndex = id - this.scrollOffset;
        if (localIndex < 0 || localIndex >= this.checkboxes.size()) {
            return AbstractButton::m_5691_;
        }
        CheckBox checkBox = this.checkboxes.get(localIndex);
        int val = 0;
        if (!checkBox.isChecked()) {
            val = 1;
        }
        ((BoosterT3Container)this.f_97732_).checkboxClicked(id, val);
        return checkBox::onPress;
    }

    public void m_181908_() {
        super.m_181908_();
        int newTotalItems = ((BoosterT3Container)this.f_97732_).getAttachedBlocks().size();
        if (newTotalItems != this.totalItems) {
            this.totalItems = newTotalItems;
            if (this.scrollOffset > Math.max(0, this.totalItems - this.maxVisibleItems)) {
                this.scrollOffset = Math.max(0, this.totalItems - this.maxVisibleItems);
            }
            this.updateCheckboxes();
        }
        HashMap<Integer, Boolean> boostFlags = ((BoosterT3Container)this.f_97732_).getBoostFlags();
        for (int i = 0; i < this.checkboxes.size(); ++i) {
            int actualIndex = i + this.scrollOffset;
            this.checkboxes.get(i).setChecked(boostFlags.getOrDefault(actualIndex, false));
        }
    }

    protected HashMap<Integer, BlockEntity> getAttachedBlocks() {
        return ((BoosterT3Container)this.f_97732_).getAttachedBlocks();
    }

    public void drawEnergyBar(GuiGraphics graphics) {
        graphics.m_280218_(this.GUI, this.getGuiLeft() + 4, this.getGuiTop() + 140, 0, 153, ((BoosterT3Container)this.f_97732_).getEnergyScaled(171), 7);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280137_(Minecraft.m_91087_().f_91062_, I18n.m_118938_((String)"gui.block_booster_t3", (Object[])new Object[0]), this.f_97726_ / 2, 4, 0xFFFFFF);
        if (((BoosterT3Container)this.f_97732_).isDisabled()) {
            graphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"gui.block_booster.disabled"), 10, 90, 0xFFFFFF);
        }
    }

    private void drawAttachedBlocks(GuiGraphics graphics) {
        HashMap<Integer, BlockEntity> attachedBlocks = ((BoosterT3Container)this.f_97732_).getAttachedBlocks();
        ArrayList<Integer> sortedKeys = new ArrayList<Integer>(attachedBlocks.keySet());
        sortedKeys.sort(Integer::compareTo);
        int displayIndex = 0;
        for (int i = this.scrollOffset; i < Math.min(this.scrollOffset + this.maxVisibleItems, sortedKeys.size()); ++i) {
            Integer key = (Integer)sortedKeys.get(i);
            BlockEntity be = attachedBlocks.get(key);
            if (be != null && !be.m_58901_()) {
                int blockX = this.getGuiLeft() + 9;
                int blockY = this.getGuiTop() + 14 + displayIndex * 20;
                if (((BoosterT3Container)this.f_97732_).isSlowBlock(key)) {
                    this.drawRedFrame(graphics, blockX, blockY, 16, 16);
                }
                graphics.m_280480_(new ItemStack((ItemLike)be.m_58900_().m_60734_().m_49966_().m_60734_().m_5456_()), blockX, blockY);
            }
            ++displayIndex;
        }
    }

    private void drawRedFrame(GuiGraphics graphics, int x, int y, int width, int height) {
        int frameColor = -65536;
        int thickness = 1;
        graphics.m_280509_(x - thickness, y - thickness, x + width + thickness, y, frameColor);
        graphics.m_280509_(x - thickness, y + height, x + width + thickness, y + height + thickness, frameColor);
        graphics.m_280509_(x - thickness, y, x, y + height, frameColor);
        graphics.m_280509_(x + width, y, x + width + thickness, y + height, frameColor);
    }

    private void drawScrollBar(GuiGraphics graphics) {
        if (this.totalItems <= this.maxVisibleItems) {
            return;
        }
        int scrollBarX = this.getGuiLeft() + 165;
        int scrollBarY = this.getGuiTop() + 14;
        int scrollBarHeight = this.maxVisibleItems * 20;
        int scrollBarWidth = 6;
        graphics.m_280509_(scrollBarX, scrollBarY, scrollBarX + scrollBarWidth, scrollBarY + scrollBarHeight, -7631989);
        int maxScroll = this.totalItems - this.maxVisibleItems;
        int thumbHeight = Math.max(20, scrollBarHeight * this.maxVisibleItems / this.totalItems);
        int thumbY = scrollBarY + (int)((float)(scrollBarHeight - thumbHeight) * ((float)this.scrollOffset / (float)maxScroll));
        graphics.m_280509_(scrollBarX, thumbY, scrollBarX + scrollBarWidth, thumbY + thumbHeight, -1);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.totalItems > this.maxVisibleItems) {
            int oldOffset = this.scrollOffset;
            this.scrollOffset = Math.max(0, Math.min(this.totalItems - this.maxVisibleItems, this.scrollOffset - (int)delta));
            if (oldOffset != this.scrollOffset) {
                this.updateCheckboxes();
                return true;
            }
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.totalItems > this.maxVisibleItems && button == 0) {
            int scrollBarX = this.getGuiLeft() + 165;
            int scrollBarY = this.getGuiTop() + 14;
            int scrollBarHeight = this.maxVisibleItems * 20;
            int scrollBarWidth = 6;
            if (mouseX >= (double)scrollBarX && mouseX <= (double)(scrollBarX + scrollBarWidth) && mouseY >= (double)scrollBarY && mouseY <= (double)(scrollBarY + scrollBarHeight)) {
                int maxScroll = this.totalItems - this.maxVisibleItems;
                int thumbHeight = Math.max(20, scrollBarHeight * this.maxVisibleItems / this.totalItems);
                float scrollPercentage = (float)(mouseY - (double)scrollBarY - (double)(thumbHeight / 2)) / (float)(scrollBarHeight - thumbHeight);
                int oldOffset = this.scrollOffset;
                this.scrollOffset = Math.max(0, Math.min(maxScroll, (int)(scrollPercentage * (float)maxScroll)));
                if (oldOffset != this.scrollOffset) {
                    this.updateCheckboxes();
                }
                return true;
            }
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    private void drawTPSIndicator(GuiGraphics graphics) {
        int x = this.getGuiLeft() + 165;
        int y = this.getGuiTop() + 4;
        int size = 8;
        int color = ((BoosterT3Container)this.f_97732_).isLagging() ? -65536 : -16711936;
        graphics.m_280509_(x, y, x + size, y + size, color);
        graphics.m_280509_(x, y, x + size, y + 1, -16777216);
        graphics.m_280509_(x, y + size - 1, x + size, y + size, -16777216);
        graphics.m_280509_(x, y, x + 1, y + size, -16777216);
        graphics.m_280509_(x + size - 1, y, x + size, y + size, -16777216);
    }
}

