/*
 * Decompiled with CFR 0.152.
 */
package igentuman.blockbooster.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.registries.ForgeRegistries;

public class CommandBoosterShowBlockId {
    private CommandBoosterShowBlockId() {
    }

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        MinecraftForge.EVENT_BUS.register(CommandBoosterShowBlockId.class);
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"booster_show_block_id").executes(ctx -> CommandBoosterShowBlockId.execute((CommandSourceStack)ctx.getSource()));
    }

    public static int execute(CommandSourceStack ctx) {
        ServerPlayer pl = ctx.m_230896_();
        BlockHitResult hitResult = CommandBoosterShowBlockId.rayTrace((Player)pl, 5.0);
        if (hitResult.m_6662_().equals((Object)HitResult.Type.BLOCK)) {
            BlockEntity be = pl.m_9236_().m_7702_(hitResult.m_82425_());
            if (be == null) {
                return 0;
            }
            pl.m_213846_((Component)Component.m_237113_((String)CommandBoosterShowBlockId.getBlockName(be)));
        }
        return 0;
    }

    public static String getBlockName(BlockEntity be) {
        return ForgeRegistries.BLOCKS.getKey((Object)be.m_58900_().m_60734_()).toString();
    }

    public static BlockHitResult rayTrace(Player player, double reach) {
        return CommandBoosterShowBlockId.rayTrace(player, reach, ClipContext.Fluid.NONE);
    }

    public static BlockHitResult rayTrace(Player player, double reach, ClipContext.Fluid fluidMode) {
        Vec3 headVec = CommandBoosterShowBlockId.getHeadVec(player);
        Vec3 lookVec = player.m_20252_(1.0f);
        Vec3 endVec = headVec.m_82520_(lookVec.f_82479_ * reach, lookVec.f_82480_ * reach, lookVec.f_82481_ * reach);
        return player.m_20193_().m_45547_(new ClipContext(headVec, endVec, ClipContext.Block.OUTLINE, fluidMode, (Entity)player));
    }

    private static Vec3 getHeadVec(Player player) {
        double posY = player.m_20186_() + (double)player.m_20192_();
        if (player.m_6047_()) {
            posY -= 0.08;
        }
        return new Vec3(player.m_20185_(), posY, player.m_20189_());
    }
}

