/*
 * Decompiled with CFR 0.152.
 */
package igentuman.blockbooster.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final General GENERAL = new General(BUILDER);
    public static final ForgeConfigSpec spec = BUILDER.build();
    private static boolean loaded = false;
    private static List<Runnable> loadActions = new ArrayList<Runnable>();

    public static void setLoaded() {
        if (!loaded) {
            loadActions.forEach(Runnable::run);
        }
        loaded = true;
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static void onLoad(Runnable action) {
        if (loaded) {
            action.run();
        } else {
            loadActions.add(action);
        }
    }

    public static class General {
        public final ForgeConfigSpec.ConfigValue<Integer> boosters_per_chunk;
        public final ForgeConfigSpec.ConfigValue<Integer> t1_fe_per_tick;
        public final ForgeConfigSpec.ConfigValue<Integer> t1_boost_rate;
        public final ForgeConfigSpec.ConfigValue<Integer> t2_fe_per_tick;
        public final ForgeConfigSpec.ConfigValue<Integer> t2_boost_rate;
        public final ForgeConfigSpec.ConfigValue<Integer> t3_fe_per_tick;
        public final ForgeConfigSpec.ConfigValue<Integer> t3_boost_rate;
        public final ForgeConfigSpec.ConfigValue<Integer> t3_scan_radius;
        public final ForgeConfigSpec.ConfigValue<Integer> mana_per_tick;
        public final ForgeConfigSpec.ConfigValue<Integer> mana_booster_rate;
        public final ForgeConfigSpec.ConfigValue<Boolean> deactivate_with_redstone;
        public final ForgeConfigSpec.ConfigValue<List<String>> white_list;
        public final ForgeConfigSpec.ConfigValue<List<String>> black_list;
        public final ForgeConfigSpec.ConfigValue<Boolean> enable_tps_protection;
        public final ForgeConfigSpec.ConfigValue<Double> min_tps_threshold;
        public final ForgeConfigSpec.ConfigValue<Boolean> prevent_slow_blocks;
        public final ForgeConfigSpec.ConfigValue<Long> slow_block_threshold_ns;

        public General(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            this.boosters_per_chunk = builder.comment("Limit boosters per chunk. Boosters might affect server performance negatively. Consider limiting boosters per chunk").defineInRange("boosters_per_chunk", 5, 1, 20);
            this.t1_fe_per_tick = builder.comment("Booster Tier 1 FE per tick to operate").define("t1_fe_per_tick", (Object)5000);
            this.t1_boost_rate = builder.comment("Booster Tier 1 boost rate").define("t1_boost_rate", (Object)2);
            this.t2_fe_per_tick = builder.comment("Booster Tier 2 FE per tick to operate").define("t2_fe_per_tick", (Object)10000);
            this.t2_boost_rate = builder.comment("Booster Tier 2 boost rate").define("t2_boost_rate", (Object)5);
            this.t3_fe_per_tick = builder.comment("Booster Tier 3 FE per tick to operate").define("t3_fe_per_tick", (Object)20000);
            this.t3_boost_rate = builder.comment("Booster Tier 3 boost rate").define("t3_boost_rate", (Object)10);
            this.t3_scan_radius = builder.comment("Booster Tier 3 scan radius (scans a cube area)").defineInRange("t3_scan_radius", 3, 1, 10);
            this.mana_per_tick = builder.comment("Mana Booster mana per tick to operate").define("mana_per_tick", (Object)100);
            this.mana_booster_rate = builder.comment("Mana Booster boost rate").define("mana_booster_rate", (Object)5);
            this.deactivate_with_redstone = builder.comment("Deactivate booster with redstone signal").define("deactivate_with_redstone", true);
            this.black_list = builder.comment("Blacklist of block entities (example: \"minecraft:furnace\",\"somemod:machine\")").define("black_list", new ArrayList<String>(List.of("mekanism:bounding_block")));
            this.white_list = builder.comment("Whitelist of block entities (example: \"minecraft:furnace\",\"somemod:machine\") has higher priority").define("white_list", new ArrayList());
            this.enable_tps_protection = builder.comment("Enable TPS-based lag protection. Boosters will stop working when server TPS drops below threshold").define("enable_tps_protection", true);
            this.min_tps_threshold = builder.comment("Minimum TPS threshold for boosters to operate. If server TPS drops below this value, boosters will pause").defineInRange("min_tps_threshold", 15.0, 1.0, 20.0);
            this.prevent_slow_blocks = builder.comment("Prevent boosting of slow blocks that take longer than the threshold to process").define("prevent_slow_blocks", true);
            this.slow_block_threshold_ns = builder.comment("Threshold in nanoseconds for considering a block as 'slow'. Blocks taking longer will be marked as slow (1ms = 1000000ns)").defineInRange("slow_block_threshold_ns", 5000000L, 100000L, 100000000L);
            builder.pop();
        }
    }
}

