/*
 * Decompiled with CFR 0.152.
 */
package igentuman.blockbooster.tile;

import igentuman.blockbooster.config.CommonConfig;
import igentuman.blockbooster.tile.ITileBooster;
import igentuman.blockbooster.util.BoosterUtil;
import igentuman.blockbooster.util.TPSTracker;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class AbstractBooster
extends BlockEntity
implements BlockEntityTicker,
ITileBooster {
    protected LinkedList<String> whiteList = this.loadWhiteList();
    protected LinkedList<String> blackList = this.loadBlackList();
    protected HashMap<Integer, BlockEntity> attachedBlocks = new HashMap();
    protected HashMap<Integer, Long> boostTimes = new HashMap();
    protected HashMap<Integer, Boolean> boostFlags = new HashMap();
    protected byte[] boostFlag = new byte[]{0, 0, 0, 0, 0, 0};
    public boolean isDisabled = false;
    public boolean isLagging = false;
    protected long tick = 0L;

    public AbstractBooster(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    private LinkedList<String> loadBlackList() {
        LinkedList<String> list = new LinkedList<String>();
        for (String s : (List)CommonConfig.GENERAL.black_list.get()) {
            list.add(s);
        }
        return list;
    }

    private LinkedList<String> loadWhiteList() {
        LinkedList<String> list = new LinkedList<String>();
        for (String s : (List)CommonConfig.GENERAL.white_list.get()) {
            list.add(s);
        }
        return list;
    }

    public String getBlockName(BlockEntity be) {
        return ForgeRegistries.BLOCKS.getKey((Object)be.m_58900_().m_60734_()).toString();
    }

    protected void updateRedstoneControl() {
        if (this.f_58857_.m_276867_(this.f_58858_) && ((Boolean)CommonConfig.GENERAL.deactivate_with_redstone.get()).booleanValue()) {
            if (((Boolean)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue()) {
                this.m_6596_();
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false)), 3);
            }
            this.isDisabled = true;
            return;
        }
        this.isDisabled = false;
    }

    public void updateAttachedBlocks() {
        boolean changed = false;
        for (Direction direction : Direction.values()) {
            if (this.shouldSkipDirection(direction)) continue;
            BlockEntity be = this.f_58857_.m_7702_(new BlockPos((Vec3i)this.m_58899_().m_5484_(direction, 1)));
            boolean contains = this.attachedBlocks.containsKey(direction.ordinal());
            if (be == null) {
                if (!contains) continue;
                changed = true;
                this.attachedBlocks.remove(direction.ordinal());
                continue;
            }
            if (be instanceof AbstractBooster) {
                if (!contains) continue;
                changed = true;
                this.attachedBlocks.remove(direction.ordinal());
                continue;
            }
            if (contains && this.attachedBlocks.get(direction.ordinal()).equals(be) || (this.whiteList.isEmpty() ? this.blackList.contains(this.getBlockName(be)) : !this.whiteList.contains(this.getBlockName(be)))) continue;
            if (contains) {
                this.attachedBlocks.remove(direction.ordinal());
            }
            changed = true;
            this.attachedBlocks.put(direction.ordinal(), be);
        }
        if (changed) {
            this.boostFlags.clear();
            this.boostTimes.clear();
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    protected boolean shouldSkipDirection(Direction direction) {
        return false;
    }

    protected boolean checkTPS() {
        if (!((Boolean)CommonConfig.GENERAL.enable_tps_protection.get()).booleanValue()) {
            return true;
        }
        return TPSTracker.isTpsAcceptable((Double)CommonConfig.GENERAL.min_tps_threshold.get());
    }

    @Override
    public void tickServer() {
        if (this.f_58857_ == null) {
            return;
        }
        ++this.tick;
        if (this.tick % 20L == 0L) {
            if (!this.f_58857_.m_5776_()) {
                boolean lastState = this.isDisabled;
                boolean lastLagState = this.isLagging;
                this.updateRedstoneControl();
                boolean bl = this.isLagging = !this.checkTPS();
                if (lastState != this.isDisabled || lastLagState != this.isLagging) {
                    this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
                }
                if (this.isDisabled || this.isLagging) {
                    return;
                }
            }
            this.updateAttachedBlocks();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
        if (this.isLagging) {
            return;
        }
        this.processBoostingLogic();
    }

    protected void processBoostingLogic() {
        for (Integer id : this.attachedBlocks.keySet()) {
            if (id > this.boostFlag.length - 1) break;
            if (this.boostFlag[id] == 0) continue;
            BlockEntity be = this.attachedBlocks.get(id);
            if (be == null || !this.canBoost()) {
                return;
            }
            if (!BoosterUtil.BoostBlockEntity(this.f_58857_, be.m_58899_(), be, this.getBoostRate())) continue;
            this.consumeResource();
        }
    }

    protected abstract boolean canBoost();

    protected abstract int getBoostRate();

    protected abstract void consumeResource();

    protected abstract void saveBoosterData(CompoundTag var1);

    protected abstract void loadBoosterData(CompoundTag var1);

    @Override
    public void tickClient() {
        if (this.tick % 10L == 0L) {
            this.updateAttachedBlocks();
        }
    }

    public void m_155252_(Level world, BlockPos pos, BlockState state, BlockEntity be) {
    }

    public HashMap<Integer, BlockEntity> getAttachedBlocks() {
        return this.attachedBlocks;
    }

    public byte[] getBoostFlag() {
        return this.boostFlag;
    }

    public boolean isIndexEnabled(int i) {
        return this.boostFlag[i] == 1;
    }

    @Override
    public void setIndexStatus(int i, byte status) {
        this.boostFlag[i] = status;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.saveClientData(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        if (tag != null) {
            this.loadClientData(tag);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        this.handleUpdateTag(tag);
    }

    protected void saveClientData(CompoundTag tag) {
        tag.m_128379_("isDisabled", this.isDisabled);
        tag.m_128379_("isLagging", this.isLagging);
        tag.m_128382_("boostFlag", this.boostFlag);
        this.saveBoosterData(tag);
    }

    protected void loadClientData(CompoundTag tag) {
        this.isDisabled = tag.m_128471_("isDisabled");
        this.isLagging = tag.m_128471_("isLagging");
        if (tag.m_128463_("boostFlag").length == this.boostFlag.length) {
            this.boostFlag = tag.m_128463_("boostFlag");
        }
        this.loadBoosterData(tag);
    }

    public void m_142466_(CompoundTag tag) {
        this.isDisabled = tag.m_128471_("isDisabled");
        this.isLagging = tag.m_128471_("isLagging");
        if (tag.m_128463_("boostFlag").length == this.boostFlag.length) {
            this.boostFlag = tag.m_128463_("boostFlag");
        }
        this.loadBoosterData(tag);
        super.m_142466_(tag);
    }

    public void m_183515_(CompoundTag tag) {
        tag.m_128379_("isDisabled", this.isDisabled);
        tag.m_128379_("isLagging", this.isLagging);
        tag.m_128382_("boostFlag", this.boostFlag);
        this.saveBoosterData(tag);
    }

    public boolean isLagging() {
        return this.isLagging;
    }

    public double getCurrentTPS() {
        return TPSTracker.getCurrentTPS();
    }
}

