/*
 * Decompiled with CFR 0.152.
 */
package igentuman.blockbooster.tile;

import igentuman.blockbooster.config.CommonConfig;
import igentuman.blockbooster.setup.Registration;
import igentuman.blockbooster.tile.AbstractBooster;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.BotaniaForgeCapabilities;
import vazkii.botania.api.mana.ManaBlockType;
import vazkii.botania.api.mana.ManaNetworkAction;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.common.handler.ManaNetworkHandler;

public class TileBoosterMana
extends AbstractBooster
implements ManaPool {
    private int mana;
    private boolean addedToManaNetwork = false;
    public int manaPerTick;

    public TileBoosterMana(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.BLOCKBOOSTER_MANA_BE.get(), pos, state);
        this.manaPerTick = (Integer)CommonConfig.GENERAL.mana_per_tick.get();
    }

    public void m_7651_() {
        super.m_7651_();
        BotaniaAPI.instance().getManaNetworkInstance().fireManaNetworkEvent((ManaReceiver)this, ManaBlockType.POOL, ManaNetworkAction.REMOVE);
        this.addedToManaNetwork = false;
    }

    @Override
    public void tickServer() {
        this.addToManaNetwork();
        super.tickServer();
    }

    @Override
    protected boolean canBoost() {
        return this.mana >= this.manaPerTick;
    }

    @Override
    protected int getBoostRate() {
        return (Integer)CommonConfig.GENERAL.mana_booster_rate.get();
    }

    @Override
    protected void consumeResource() {
        this.consumeMana();
    }

    @Override
    protected void saveBoosterData(CompoundTag tag) {
        tag.m_128405_("mana", this.mana);
    }

    @Override
    protected void loadBoosterData(CompoundTag tag) {
        this.mana = tag.m_128451_("mana");
    }

    private void addToManaNetwork() {
        if (!ManaNetworkHandler.instance.isPoolIn(this.f_58857_, (ManaPool)this) && !this.m_58901_()) {
            BotaniaAPI.instance().getManaNetworkInstance().fireManaNetworkEvent((ManaReceiver)this, ManaBlockType.POOL, ManaNetworkAction.ADD);
            this.addedToManaNetwork = true;
        }
    }

    private void consumeMana() {
        this.mana -= this.manaPerTick;
        TileBoosterMana.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)this.m_58900_());
    }

    public boolean isOutputtingPower() {
        return false;
    }

    public int getMaxMana() {
        return (Integer)CommonConfig.GENERAL.mana_per_tick.get() * 100;
    }

    public Optional<DyeColor> getColor() {
        return Optional.empty();
    }

    public void setColor(Optional<DyeColor> color) {
    }

    public Level getManaReceiverLevel() {
        return this.m_58904_();
    }

    public BlockPos getManaReceiverPos() {
        return this.m_58899_();
    }

    public int getCurrentMana() {
        return this.mana;
    }

    public boolean isFull() {
        return this.mana >= this.getMaxMana();
    }

    public void receiveMana(int mana) {
        this.mana += mana;
        TileBoosterMana.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)this.m_58900_());
    }

    public boolean canReceiveManaFromBursts() {
        return true;
    }

    public int getMana() {
        return this.mana;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == BotaniaForgeCapabilities.MANA_RECEIVER) {
            return LazyOptional.of(() -> this);
        }
        return super.getCapability(cap, side);
    }
}

