/*
 * Decompiled with CFR 0.152.
 */
package igentuman.blockbooster.tile;

import igentuman.blockbooster.config.CommonConfig;
import igentuman.blockbooster.setup.Registration;
import igentuman.blockbooster.tile.AbstractBooster;
import igentuman.blockbooster.util.CustomEnergyStorage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class TileBoosterMechanical
extends AbstractBooster {
    private final CustomEnergyStorage energy = this.createEnergyStorage();
    private final LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(() -> this.energy);
    public int fePerTick;

    public TileBoosterMechanical(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.BLOCKBOOSTER_T2_BE.get(), pos, state);
        this.fePerTick = (Integer)CommonConfig.GENERAL.t2_fe_per_tick.get();
    }

    @Override
    protected boolean canBoost() {
        return this.getEnergy() >= this.fePerTick;
    }

    @Override
    protected int getBoostRate() {
        return (Integer)CommonConfig.GENERAL.t2_boost_rate.get();
    }

    @Override
    protected void consumeResource() {
        this.consumeEnergy(this.fePerTick);
    }

    @Override
    protected void saveBoosterData(CompoundTag tag) {
        tag.m_128365_("Energy", this.energy.serializeNBT());
    }

    @Override
    protected void loadBoosterData(CompoundTag tag) {
        if (tag.m_128441_("Energy")) {
            this.energy.deserializeNBT(tag.m_128423_("Energy"));
        }
    }

    public int getEnergy() {
        return this.energy.getEnergyStored();
    }

    public void consumeEnergy(int amount) {
        this.energy.consumeEnergy(amount);
    }

    public int getMaxEnergy() {
        return (Integer)CommonConfig.GENERAL.t2_fe_per_tick.get() * 100;
    }

    private CustomEnergyStorage createEnergyStorage() {
        return new CustomEnergyStorage(this.getMaxEnergy(), (Integer)CommonConfig.GENERAL.t2_fe_per_tick.get() * 10){

            @Override
            public int receiveEnergy(int maxReceive, boolean simulate) {
                int rc = super.receiveEnergy(maxReceive, simulate);
                if (rc > 0 && !simulate) {
                    TileBoosterMechanical.this.m_6596_();
                }
                return rc;
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyHandler.cast();
        }
        return super.getCapability(cap, side);
    }
}

