/*
 * Decompiled with CFR 0.152.
 */
package igentuman.blockbooster.tile;

import igentuman.blockbooster.config.CommonConfig;
import igentuman.blockbooster.setup.Registration;
import igentuman.blockbooster.tile.AbstractBooster;
import igentuman.blockbooster.util.BoosterUtil;
import igentuman.blockbooster.util.CustomEnergyStorage;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class TileBoosterT3
extends AbstractBooster {
    private final CustomEnergyStorage energy = this.createEnergyStorage();
    private final LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(() -> this.energy);
    public int fePerTick;

    public TileBoosterT3(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.BLOCKBOOSTER_T3_BE.get(), pos, state);
        this.fePerTick = (Integer)CommonConfig.GENERAL.t3_fe_per_tick.get();
    }

    @Override
    public void updateAttachedBlocks() {
        boolean changed = false;
        HashMap<Integer, BlockEntity> newAttachedBlocks = new HashMap<Integer, BlockEntity>();
        int radius = (Integer)CommonConfig.GENERAL.t3_scan_radius.get();
        int index = 0;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos checkPos;
                    BlockEntity be;
                    if (x == 0 && y == 0 && z == 0 || (be = this.f_58857_.m_7702_(checkPos = this.m_58899_().m_7918_(x, y, z))) == null || (this.whiteList.size() > 0 ? !this.whiteList.contains(this.getBlockName(be)) : this.blackList.contains(this.getBlockName(be)))) continue;
                    newAttachedBlocks.put(index, be);
                    if (!this.boostFlags.containsKey(index)) {
                        this.boostFlags.put(index, false);
                    }
                    ++index;
                }
            }
        }
        if (newAttachedBlocks.size() != this.attachedBlocks.size()) {
            changed = true;
        } else {
            for (Integer key : newAttachedBlocks.keySet()) {
                if (this.attachedBlocks.containsKey(key) && ((BlockEntity)this.attachedBlocks.get(key)).equals(newAttachedBlocks.get(key))) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            this.attachedBlocks = newAttachedBlocks;
            this.boostFlags.clear();
            this.boostTimes.clear();
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @Override
    protected void processBoostingLogic() {
        for (Integer id : this.attachedBlocks.keySet()) {
            Long lastBoostTime;
            BlockEntity be;
            if (!this.boostFlags.getOrDefault(id, false).booleanValue() || (be = (BlockEntity)this.attachedBlocks.get(id)) == null || be.m_58901_() || !this.canBoost() || ((Boolean)CommonConfig.GENERAL.prevent_slow_blocks.get()).booleanValue() && (lastBoostTime = (Long)this.boostTimes.get(id)) != null && lastBoostTime > (Long)CommonConfig.GENERAL.slow_block_threshold_ns.get()) continue;
            BoosterUtil.BoostResult result = BoosterUtil.BoostBlockEntityWithTiming(this.f_58857_, be.m_58899_(), be, this.getBoostRate());
            if (!result.success) continue;
            this.boostTimes.put(id, result.timeNanos);
            this.consumeResource();
        }
    }

    @Override
    protected boolean canBoost() {
        return this.getEnergy() >= this.fePerTick;
    }

    @Override
    protected int getBoostRate() {
        return (Integer)CommonConfig.GENERAL.t3_boost_rate.get();
    }

    @Override
    protected void consumeResource() {
        this.consumeEnergy(this.fePerTick);
    }

    @Override
    protected void saveBoosterData(CompoundTag tag) {
        tag.m_128365_("Energy", this.energy.serializeNBT());
        ListTag flagsList = new ListTag();
        for (Integer key : this.boostFlags.keySet()) {
            CompoundTag flagTag = new CompoundTag();
            flagTag.m_128405_("index", key.intValue());
            flagTag.m_128379_("enabled", ((Boolean)this.boostFlags.get(key)).booleanValue());
            flagsList.add((Object)flagTag);
        }
        tag.m_128365_("boostFlags", (Tag)flagsList);
        ListTag timesList = new ListTag();
        for (Integer key : this.boostTimes.keySet()) {
            CompoundTag timeTag = new CompoundTag();
            timeTag.m_128405_("index", key.intValue());
            timeTag.m_128356_("time", ((Long)this.boostTimes.get(key)).longValue());
            timesList.add((Object)timeTag);
        }
        tag.m_128365_("boostTimes", (Tag)timesList);
    }

    @Override
    protected void loadBoosterData(CompoundTag tag) {
        int i;
        if (tag.m_128441_("Energy")) {
            this.energy.deserializeNBT(tag.m_128423_("Energy"));
        }
        if (tag.m_128441_("boostFlags")) {
            this.boostFlags.clear();
            ListTag flagsList = tag.m_128437_("boostFlags", 10);
            for (i = 0; i < flagsList.size(); ++i) {
                CompoundTag flagTag = flagsList.m_128728_(i);
                this.boostFlags.put(flagTag.m_128451_("index"), flagTag.m_128471_("enabled"));
            }
        }
        if (tag.m_128441_("boostTimes")) {
            this.boostTimes.clear();
            ListTag timesList = tag.m_128437_("boostTimes", 10);
            for (i = 0; i < timesList.size(); ++i) {
                CompoundTag timeTag = timesList.m_128728_(i);
                this.boostTimes.put(timeTag.m_128451_("index"), timeTag.m_128454_("time"));
            }
        }
    }

    public int getEnergy() {
        return this.energy.getEnergyStored();
    }

    public void consumeEnergy(int amount) {
        this.energy.consumeEnergy(amount);
    }

    public int getMaxEnergy() {
        return (Integer)CommonConfig.GENERAL.t3_fe_per_tick.get() * 100;
    }

    private CustomEnergyStorage createEnergyStorage() {
        return new CustomEnergyStorage(this.getMaxEnergy(), this.getMaxEnergy()){

            @Override
            public int receiveEnergy(int maxReceive, boolean simulate) {
                int rc = super.receiveEnergy(maxReceive, simulate);
                if (rc > 0 && !simulate) {
                    TileBoosterT3.this.m_6596_();
                }
                return rc;
            }
        };
    }

    @Override
    public boolean isIndexEnabled(int i) {
        return this.boostFlags.getOrDefault(i, false);
    }

    @Override
    public void setIndexStatus(int i, byte status) {
        this.boostFlags.put(i, status == 1);
        TileBoosterT3.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)this.m_58900_());
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public HashMap<Integer, Boolean> getBoostFlags() {
        return this.boostFlags;
    }

    public HashMap<Integer, Long> getBoostTimes() {
        return this.boostTimes;
    }

    public boolean isSlowBlock(int index) {
        Long boostTime = (Long)this.boostTimes.get(index);
        if (boostTime == null) {
            return false;
        }
        return boostTime > (Long)CommonConfig.GENERAL.slow_block_threshold_ns.get();
    }
}

