/*
 * Decompiled with CFR 0.152.
 */
package igentuman.blockbooster.client.screen;

import igentuman.blockbooster.client.screen.element.CheckBox;
import igentuman.blockbooster.container.BoosterT2Container;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BoosterT2Screen
extends AbstractContainerScreen<BoosterT2Container> {
    private final ResourceLocation GUI = ResourceLocation.fromNamespaceAndPath((String)"blockbooster", (String)"textures/gui/blockbooster_t2_gui.png");
    private final HashMap<Long, CheckBox> checkboxes = new HashMap();

    public BoosterT2Screen(BoosterT2Container container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.imageWidth = 180;
        this.imageHeight = 152;
    }

    public void renderBg(GuiGraphics graphics, float pPartialTick, int pMouseX, int pMouseY) {
        int relX = (this.width - this.imageWidth) / 2;
        int relY = (this.height - this.imageHeight) / 2;
        graphics.blit(this.GUI, relX, relY, 0, 0, this.imageWidth, this.imageHeight);
        this.renderTooltip(graphics, pMouseX, pMouseY);
        this.drawEnergyBar(graphics);
        this.drawAttachedBlocks(graphics);
        this.drawTPSIndicator(graphics);
    }

    public void renderTooltip(GuiGraphics graphics, int x, int y) {
        if (x > this.getGuiLeft() + 4 && x < this.getGuiLeft() + 175 && y > this.getGuiTop() + 139 && y < this.getGuiTop() + 149) {
            MutableComponent textComponent = Component.translatable((String)"gui.energy.info", (Object[])new Object[]{((BoosterT2Container)this.menu).getEnergy(), ((BoosterT2Container)this.menu).getMaxEnergy()});
            graphics.renderTooltip(Minecraft.getInstance().font, (Component)textComponent, x, y);
            return;
        }
        int tpsX = this.getGuiLeft() + 165;
        int tpsY = this.getGuiTop() + 4;
        if (x >= tpsX && x < tpsX + 8 && y >= tpsY && y < tpsY + 8) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            if (((BoosterT2Container)this.menu).isLagging()) {
                tooltip.add(Component.translatable((String)"gui.tps.lagging"));
                tooltip.add(Component.translatable((String)"gui.tps.current", (Object[])new Object[]{String.format("%.1f", ((BoosterT2Container)this.menu).getCurrentTPS())}));
                tooltip.add(Component.translatable((String)"gui.tps.boosting_paused"));
            } else {
                tooltip.add(Component.translatable((String)"gui.tps.ok"));
                tooltip.add(Component.translatable((String)"gui.tps.current", (Object[])new Object[]{String.format("%.1f", ((BoosterT2Container)this.menu).getCurrentTPS())}));
            }
            graphics.renderTooltip(Minecraft.getInstance().font, tooltip, Optional.empty(), x, y);
            return;
        }
        HashMap<Long, BlockEntity> attachedBlocks = ((BoosterT2Container)this.menu).getAttachedBlocks();
        int blockIconX = this.getGuiLeft() + 9;
        int blockIconSize = 16;
        int blockSpacing = 20;
        int startY = this.getGuiTop() + 14;
        int index = 0;
        for (Long posKey : attachedBlocks.keySet()) {
            BlockEntity be = attachedBlocks.get(posKey);
            if (be == null || be.isRemoved()) continue;
            int blockY = startY + index * blockSpacing;
            if (x >= blockIconX && x < blockIconX + blockIconSize && y >= blockY && y < blockY + blockIconSize) {
                ItemStack blockStack = new ItemStack((ItemLike)be.getBlockState().getBlock().asItem());
                ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
                tooltip.add(Component.translatable((String)blockStack.getDescriptionId()));
                tooltip.add(Component.literal((String)be.getBlockPos().toShortString()));
                graphics.renderTooltip(Minecraft.getInstance().font, tooltip, Optional.empty(), x, y);
                return;
            }
            ++index;
        }
    }

    protected void init() {
        super.init();
        this.checkboxes.clear();
        int index = 0;
        Iterator<Object> iterator = ((BoosterT2Container)this.menu).getBoostFlags().keySet().iterator();
        while (iterator.hasNext()) {
            long l = iterator.next();
            this.checkboxes.put(l, new CheckBox(this.getGuiLeft() + 28, this.getGuiTop() + 15 + index * 20, 13, 13, 181, 0, 13, this.GUI, btn -> this.checkboxClicked(btn, id)));
            this.checkboxes.get(l).setChecked(((BoosterT2Container)this.menu).getBoostFlags().get(l));
            ++index;
        }
        for (Button button : this.checkboxes.values()) {
            this.addRenderableWidget((GuiEventListener)button);
        }
    }

    public Button.OnPress checkboxClicked(Button btn, long id) {
        if (this.checkboxes == null) {
            return AbstractButton::onPress;
        }
        CheckBox checkBox = this.checkboxes.get(id);
        boolean val = false;
        if (!checkBox.isChecked()) {
            val = true;
        }
        ((BoosterT2Container)this.menu).checkboxClicked(id, val);
        return checkBox::onPress;
    }

    public void containerTick() {
        super.containerTick();
        for (long id : ((BoosterT2Container)this.menu).getBoostFlags().keySet()) {
            if (!this.checkboxes.containsKey(id)) continue;
            this.checkboxes.get(id).setChecked(((BoosterT2Container)this.menu).getBoostFlags().get(id));
        }
    }

    protected HashMap<Long, BlockEntity> getAttachedBlocks() {
        return ((BoosterT2Container)this.menu).getAttachedBlocks();
    }

    public void drawEnergyBar(GuiGraphics graphics) {
        graphics.blit(this.GUI, this.getGuiLeft() + 4, this.getGuiTop() + 140, 0, 153, ((BoosterT2Container)this.menu).getEnergyScaled(171), 7);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawCenteredString(Minecraft.getInstance().font, I18n.get((String)"gui.block_booster", (Object[])new Object[0]), this.imageWidth / 2, 4, 0xFFFFFF);
        if (((BoosterT2Container)this.menu).isDisabled()) {
            graphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"gui.block_booster.disabled"), 10, 65, 0xFFFFFF);
        }
    }

    private void drawAttachedBlocks(GuiGraphics graphics) {
        int y = 14;
        int index = 0;
        for (Long posKey : ((BoosterT2Container)this.menu).getAttachedBlocks().keySet()) {
            graphics.renderItem(new ItemStack((ItemLike)((BoosterT2Container)this.menu).getAttachedBlocks().get(posKey).getBlockState().getBlock().asItem()), this.getGuiLeft() + 9, this.getGuiTop() + index * 20 + y);
            ++index;
        }
    }

    private void drawTPSIndicator(GuiGraphics graphics) {
        int x = this.getGuiLeft() + 165;
        int y = this.getGuiTop() + 4;
        int size = 8;
        int color = ((BoosterT2Container)this.menu).isLagging() ? -65536 : -16711936;
        graphics.fill(x, y, x + size, y + size, color);
        graphics.fill(x, y, x + size, y + 1, -16777216);
        graphics.fill(x, y + size - 1, x + size, y + size, -16777216);
        graphics.fill(x, y, x + 1, y + size, -16777216);
        graphics.fill(x + size - 1, y, x + size, y + size, -16777216);
    }
}

