/*
 * Decompiled with CFR 0.152.
 */
package igentuman.blockbooster.client.screen;

import igentuman.blockbooster.client.screen.element.CheckBox;
import igentuman.blockbooster.container.BoosterT3Container;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BoosterT3Screen
extends AbstractContainerScreen<BoosterT3Container> {
    private final ResourceLocation GUI = ResourceLocation.fromNamespaceAndPath((String)"blockbooster", (String)"textures/gui/blockbooster_t3_gui.png");
    private final HashMap<Long, CheckBox> checkboxes = new HashMap();
    private int scrollOffset = 0;
    private int maxVisibleRows = 6;
    private int itemsPerRow = 2;
    private int totalItems = 0;

    public BoosterT3Screen(BoosterT3Container container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.imageWidth = 180;
        this.imageHeight = 152;
    }

    public void renderBg(GuiGraphics graphics, float pPartialTick, int pMouseX, int pMouseY) {
        int relX = (this.width - this.imageWidth) / 2;
        int relY = (this.height - this.imageHeight) / 2;
        graphics.blit(this.GUI, relX, relY, 0, 0, this.imageWidth, this.imageHeight);
        this.renderTooltip(graphics, pMouseX, pMouseY);
        this.drawEnergyBar(graphics);
        this.drawAttachedBlocks(graphics);
        this.drawScrollBar(graphics);
        this.drawTPSIndicator(graphics);
    }

    public void renderTooltip(GuiGraphics graphics, int x, int y) {
        if (x > this.getGuiLeft() + 4 && x < this.getGuiLeft() + 175 && y > this.getGuiTop() + 139 && y < this.getGuiTop() + 149) {
            MutableComponent textComponent = Component.translatable((String)"gui.energy.info", (Object[])new Object[]{((BoosterT3Container)this.menu).getEnergy(), ((BoosterT3Container)this.menu).getMaxEnergy()});
            graphics.renderTooltip(Minecraft.getInstance().font, (Component)textComponent, x, y);
            return;
        }
        int tpsX = this.getGuiLeft() + 165;
        int tpsY = this.getGuiTop() + 4;
        if (x >= tpsX && x < tpsX + 8 && y >= tpsY && y < tpsY + 8) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            if (((BoosterT3Container)this.menu).isLagging()) {
                tooltip.add(Component.translatable((String)"gui.tps.lagging"));
                tooltip.add(Component.translatable((String)"gui.tps.current", (Object[])new Object[]{String.format("%.1f", ((BoosterT3Container)this.menu).getCurrentTPS())}));
                tooltip.add(Component.translatable((String)"gui.tps.boosting_paused"));
            } else {
                tooltip.add(Component.translatable((String)"gui.tps.ok"));
                tooltip.add(Component.translatable((String)"gui.tps.current", (Object[])new Object[]{String.format("%.1f", ((BoosterT3Container)this.menu).getCurrentTPS())}));
            }
            graphics.renderTooltip(Minecraft.getInstance().font, tooltip, Optional.empty(), x, y);
            return;
        }
        HashMap<Long, BlockEntity> attachedBlocks = ((BoosterT3Container)this.menu).getAttachedBlocks();
        HashMap<Long, Long> boostTimes = ((BoosterT3Container)this.menu).getBoostTimes();
        ArrayList<Long> sortedKeys = new ArrayList<Long>(attachedBlocks.keySet());
        sortedKeys.sort(Long::compareTo);
        int blockIconSize = 16;
        int blockSpacing = 20;
        int columnSpacing = 85;
        int startX = this.getGuiLeft() + 9;
        int startY = this.getGuiTop() + 14;
        int displayIndex = 0;
        int maxItemsVisible = this.maxVisibleRows * this.itemsPerRow;
        for (int i = this.scrollOffset; i < Math.min(this.scrollOffset + maxItemsVisible, sortedKeys.size()); ++i) {
            Long key = (Long)sortedKeys.get(i);
            BlockEntity be = attachedBlocks.get(key);
            if (be != null && !be.isRemoved()) {
                int rowIndex = displayIndex / this.itemsPerRow;
                int colIndex = displayIndex % this.itemsPerRow;
                int blockX = startX + colIndex * columnSpacing;
                int blockY = startY + rowIndex * blockSpacing;
                if (x >= blockX && x < blockX + blockIconSize && y >= blockY && y < blockY + blockIconSize) {
                    ItemStack blockStack = new ItemStack((ItemLike)be.getBlockState().getBlock().asItem());
                    ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
                    tooltip.add(Component.translatable((String)blockStack.getDescriptionId()));
                    tooltip.add(Component.literal((String)be.getBlockPos().toShortString()));
                    Long boostTime = boostTimes.get(key);
                    if (boostTime != null && boostTime > 0L) {
                        double timeMs = (double)boostTime.longValue() / 1000000.0;
                        tooltip.add(Component.translatable((String)"gui.boost.time", (Object[])new Object[]{String.format("%.3f", timeMs)}));
                        if (((BoosterT3Container)this.menu).isSlowBlock(key)) {
                            tooltip.add(Component.translatable((String)"gui.boost.slow_block"));
                        }
                    }
                    graphics.renderTooltip(Minecraft.getInstance().font, tooltip, Optional.empty(), x, y);
                    return;
                }
            }
            ++displayIndex;
        }
    }

    protected void init() {
        super.init();
        this.updateCheckboxes();
    }

    private void updateCheckboxes() {
        for (CheckBox checkbox : this.checkboxes.values()) {
            this.removeWidget((GuiEventListener)checkbox);
        }
        this.checkboxes.clear();
        HashMap<Long, BlockEntity> attachedBlocks = ((BoosterT3Container)this.menu).getAttachedBlocks();
        ArrayList<Long> sortedKeys = new ArrayList<Long>(attachedBlocks.keySet());
        sortedKeys.sort(Long::compareTo);
        this.totalItems = sortedKeys.size();
        int columnSpacing = 85;
        int blockSpacing = 20;
        int maxItemsVisible = this.maxVisibleRows * this.itemsPerRow;
        for (int i = 0; i < Math.min(maxItemsVisible, this.totalItems - this.scrollOffset); ++i) {
            int actualIndex = i + this.scrollOffset;
            if (actualIndex >= sortedKeys.size()) continue;
            long posKey = (Long)sortedKeys.get(actualIndex);
            int rowIndex = i / this.itemsPerRow;
            int colIndex = i % this.itemsPerRow;
            CheckBox checkbox = new CheckBox(this.getGuiLeft() + 28 + colIndex * columnSpacing, this.getGuiTop() + 15 + rowIndex * blockSpacing, 13, 13, 181, 0, 13, this.GUI, btn -> this.checkboxClicked(btn, posKey));
            this.checkboxes.put(posKey, checkbox);
            this.addRenderableWidget((GuiEventListener)checkbox);
        }
    }

    public Button.OnPress checkboxClicked(Button btn, long posKey) {
        if (this.checkboxes == null) {
            return AbstractButton::onPress;
        }
        CheckBox checkBox = (CheckBox)btn;
        boolean val = false;
        if (!checkBox.isChecked()) {
            val = true;
        }
        ((BoosterT3Container)this.menu).checkboxClicked(posKey, val);
        return checkBox::onPress;
    }

    public void containerTick() {
        super.containerTick();
        int newTotalItems = ((BoosterT3Container)this.menu).getAttachedBlocks().size();
        if (newTotalItems != this.totalItems) {
            this.totalItems = newTotalItems;
            int maxItemsVisible = this.maxVisibleRows * this.itemsPerRow;
            if (this.scrollOffset > Math.max(0, this.totalItems - maxItemsVisible)) {
                this.scrollOffset = Math.max(0, this.totalItems - maxItemsVisible);
            }
            this.updateCheckboxes();
        }
        HashMap<Long, Boolean> boostFlags = ((BoosterT3Container)this.menu).getBoostFlags();
        HashMap<Long, BlockEntity> attachedBlocks = ((BoosterT3Container)this.menu).getAttachedBlocks();
        ArrayList<Long> sortedKeys = new ArrayList<Long>(attachedBlocks.keySet());
        sortedKeys.sort(Long::compareTo);
        for (long id : this.checkboxes.keySet()) {
            if (!this.checkboxes.containsKey(id)) continue;
            this.checkboxes.get(id).setChecked(boostFlags.getOrDefault(id, false));
        }
    }

    protected HashMap<Long, BlockEntity> getAttachedBlocks() {
        return ((BoosterT3Container)this.menu).getAttachedBlocks();
    }

    public void drawEnergyBar(GuiGraphics graphics) {
        graphics.blit(this.GUI, this.getGuiLeft() + 4, this.getGuiTop() + 140, 0, 153, ((BoosterT3Container)this.menu).getEnergyScaled(171), 7);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawCenteredString(Minecraft.getInstance().font, I18n.get((String)"gui.block_booster_t3", (Object[])new Object[0]), this.imageWidth / 2, 4, 0xFFFFFF);
        if (((BoosterT3Container)this.menu).isDisabled()) {
            graphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"gui.block_booster.disabled"), 10, 90, 0xFFFFFF);
        }
    }

    private void drawAttachedBlocks(GuiGraphics graphics) {
        HashMap<Long, BlockEntity> attachedBlocks = ((BoosterT3Container)this.menu).getAttachedBlocks();
        ArrayList<Long> sortedKeys = new ArrayList<Long>(attachedBlocks.keySet());
        sortedKeys.sort(Long::compareTo);
        int columnSpacing = 85;
        int blockSpacing = 20;
        int startX = this.getGuiLeft() + 9;
        int startY = this.getGuiTop() + 14;
        int maxItemsVisible = this.maxVisibleRows * this.itemsPerRow;
        int displayIndex = 0;
        for (int i = this.scrollOffset; i < Math.min(this.scrollOffset + maxItemsVisible, sortedKeys.size()); ++i) {
            Long key = (Long)sortedKeys.get(i);
            BlockEntity be = attachedBlocks.get(key);
            if (be != null && !be.isRemoved()) {
                int rowIndex = displayIndex / this.itemsPerRow;
                int colIndex = displayIndex % this.itemsPerRow;
                int blockX = startX + colIndex * columnSpacing;
                int blockY = startY + rowIndex * blockSpacing;
                if (((BoosterT3Container)this.menu).isSlowBlock(key)) {
                    this.drawRedFrame(graphics, blockX, blockY, 16, 16);
                }
                graphics.renderItem(new ItemStack((ItemLike)be.getBlockState().getBlock().defaultBlockState().getBlock().asItem()), blockX, blockY);
            }
            ++displayIndex;
        }
    }

    private void drawRedFrame(GuiGraphics graphics, int x, int y, int width, int height) {
        int frameColor = -65536;
        int thickness = 1;
        graphics.fill(x - thickness, y - thickness, x + width + thickness, y, frameColor);
        graphics.fill(x - thickness, y + height, x + width + thickness, y + height + thickness, frameColor);
        graphics.fill(x - thickness, y, x, y + height, frameColor);
        graphics.fill(x + width, y, x + width + thickness, y + height, frameColor);
    }

    private void drawScrollBar(GuiGraphics graphics) {
        int maxItemsVisible = this.maxVisibleRows * this.itemsPerRow;
        if (this.totalItems <= maxItemsVisible) {
            return;
        }
        int scrollBarX = this.getGuiLeft() + 165;
        int scrollBarY = this.getGuiTop() + 14;
        int scrollBarHeight = this.maxVisibleRows * 20;
        int scrollBarWidth = 6;
        graphics.fill(scrollBarX, scrollBarY, scrollBarX + scrollBarWidth, scrollBarY + scrollBarHeight, -7631989);
        int maxScroll = this.totalItems - maxItemsVisible;
        int thumbHeight = Math.max(20, scrollBarHeight * maxItemsVisible / this.totalItems);
        int thumbY = scrollBarY + (int)((float)(scrollBarHeight - thumbHeight) * ((float)this.scrollOffset / (float)maxScroll));
        graphics.fill(scrollBarX, thumbY, scrollBarX + scrollBarWidth, thumbY + thumbHeight, -1);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        int maxItemsVisible = this.maxVisibleRows * this.itemsPerRow;
        if (this.totalItems > maxItemsVisible) {
            int oldOffset = this.scrollOffset;
            this.scrollOffset = Math.max(0, Math.min(this.totalItems - maxItemsVisible, this.scrollOffset - (int)(scrollY * (double)this.itemsPerRow)));
            if (oldOffset != this.scrollOffset) {
                this.updateCheckboxes();
                return true;
            }
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        int maxItemsVisible = this.maxVisibleRows * this.itemsPerRow;
        if (this.totalItems > maxItemsVisible && button == 0) {
            int scrollBarX = this.getGuiLeft() + 165;
            int scrollBarY = this.getGuiTop() + 14;
            int scrollBarHeight = this.maxVisibleRows * 20;
            int scrollBarWidth = 6;
            if (mouseX >= (double)scrollBarX && mouseX <= (double)(scrollBarX + scrollBarWidth) && mouseY >= (double)scrollBarY && mouseY <= (double)(scrollBarY + scrollBarHeight)) {
                int maxScroll = this.totalItems - maxItemsVisible;
                int thumbHeight = Math.max(20, scrollBarHeight * maxItemsVisible / this.totalItems);
                float scrollPercentage = (float)(mouseY - (double)scrollBarY - (double)(thumbHeight / 2)) / (float)(scrollBarHeight - thumbHeight);
                int oldOffset = this.scrollOffset;
                this.scrollOffset = Math.max(0, Math.min(maxScroll, (int)(scrollPercentage * (float)maxScroll)));
                if (oldOffset != this.scrollOffset) {
                    this.updateCheckboxes();
                }
                return true;
            }
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    private void drawTPSIndicator(GuiGraphics graphics) {
        int x = this.getGuiLeft() + 165;
        int y = this.getGuiTop() + 4;
        int size = 8;
        int color = ((BoosterT3Container)this.menu).isLagging() ? -65536 : -16711936;
        graphics.fill(x, y, x + size, y + size, color);
        graphics.fill(x, y, x + size, y + 1, -16777216);
        graphics.fill(x, y + size - 1, x + size, y + size, -16777216);
        graphics.fill(x, y, x + 1, y + size, -16777216);
        graphics.fill(x + size - 1, y, x + size, y + size, -16777216);
    }
}

