/*
 * Decompiled with CFR 0.152.
 */
package igentuman.blockbooster.client.screen.element;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class CheckBox
extends Button {
    private ResourceLocation resourceLocation;
    private int xTexStart;
    private int yTexStart;
    private int yDiffTex;
    private int textureWidth;
    private int textureHeight;
    private boolean isChecked = false;

    public boolean isChecked() {
        return this.isChecked;
    }

    public CheckBox(int pX, int pY, int pWidth, int pHeight, int pXTexStart, int pYTexStart, int yDiffTex, ResourceLocation pResourceLocation, Button.OnPress pOnPress) {
        super(pX, pY, pWidth, pHeight, (Component)Component.translatable((String)"gui.checkbox.boost"), pOnPress, DEFAULT_NARRATION);
        this.resourceLocation = pResourceLocation;
        this.xTexStart = pXTexStart;
        this.yTexStart = pYTexStart;
        this.yDiffTex = yDiffTex;
        this.textureWidth = 256;
        this.textureHeight = 256;
    }

    public void toggleChecked() {
        boolean bl = this.isChecked = !this.isChecked;
        if (this.isChecked) {
            this.setXStart(194);
        } else {
            this.setXStart(181);
        }
    }

    public void setChecked(boolean val) {
        this.isChecked = val;
        if (this.isChecked) {
            this.setXStart(194);
        } else {
            this.setXStart(181);
        }
    }

    public void setXStart(int val) {
        this.xTexStart = val;
    }

    public void onPress(Button button) {
        this.toggleChecked();
    }

    public void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.resourceLocation);
        int i = this.yTexStart;
        if (!this.isActive()) {
            i += this.yDiffTex * 2;
        } else if (this.isHoveredOrFocused()) {
            i += this.yDiffTex;
        }
        RenderSystem.enableDepthTest();
        guiGraphics.blit(this.resourceLocation, this.getX(), this.getY(), (float)this.xTexStart, (float)i, this.width, this.height, this.textureWidth, this.textureHeight);
        if (this.isHovered) {
            guiGraphics.renderTooltip(Minecraft.getInstance().font, this.getMessage(), pMouseX, pMouseY);
        }
        guiGraphics.drawString(Minecraft.getInstance().font, I18n.get((String)"gui.checkbox.boost", (Object[])new Object[0]), this.getX() + 15, this.getY() + 3, 0xFFFFFF);
    }
}

