/*
 * Decompiled with CFR 0.152.
 */
package igentuman.blockbooster.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForge;

public class CommandBoosterShowBlockId {
    private CommandBoosterShowBlockId() {
    }

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        NeoForge.EVENT_BUS.register(CommandBoosterShowBlockId.class);
        return (LiteralArgumentBuilder)Commands.literal((String)"booster_show_block_id").executes(ctx -> CommandBoosterShowBlockId.execute((CommandSourceStack)ctx.getSource()));
    }

    public static int execute(CommandSourceStack ctx) {
        ServerPlayer pl = ctx.getPlayer();
        BlockHitResult hitResult = CommandBoosterShowBlockId.rayTrace((Player)pl, 5.0);
        if (hitResult.getType().equals((Object)HitResult.Type.BLOCK)) {
            BlockEntity be = pl.level().getBlockEntity(hitResult.getBlockPos());
            if (be == null) {
                return 0;
            }
            pl.sendSystemMessage((Component)Component.literal((String)CommandBoosterShowBlockId.getBlockName(be)));
        }
        return 0;
    }

    public static String getBlockName(BlockEntity be) {
        return BuiltInRegistries.BLOCK.getKey((Object)be.getBlockState().getBlock()).toString();
    }

    public static BlockHitResult rayTrace(Player player, double reach) {
        return CommandBoosterShowBlockId.rayTrace(player, reach, ClipContext.Fluid.NONE);
    }

    public static BlockHitResult rayTrace(Player player, double reach, ClipContext.Fluid fluidMode) {
        Vec3 headVec = CommandBoosterShowBlockId.getHeadVec(player);
        Vec3 lookVec = player.getViewVector(1.0f);
        Vec3 endVec = headVec.add(lookVec.x * reach, lookVec.y * reach, lookVec.z * reach);
        return player.getCommandSenderWorld().clip(new ClipContext(headVec, endVec, ClipContext.Block.OUTLINE, fluidMode, (Entity)player));
    }

    private static Vec3 getHeadVec(Player player) {
        double posY = player.getY() + (double)player.getEyeHeight();
        if (player.isCrouching()) {
            posY -= 0.08;
        }
        return new Vec3(player.getX(), posY, player.getZ());
    }
}

