/*
 * Decompiled with CFR 0.152.
 */
package igentuman.blockbooster.container;

import igentuman.blockbooster.network.BoosterPacket;
import igentuman.blockbooster.setup.Messages;
import igentuman.blockbooster.setup.Registration;
import igentuman.blockbooster.tile.TileBoosterT2;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BoosterT2Container
extends AbstractContainerMenu {
    private final TileBoosterT2 blockEntity;
    private final Player playerEntity;

    public BoosterT2Container(int windowId, Inventory playerInventory, RegistryFriendlyByteBuf buf) {
        super((MenuType)Registration.BLOCKBOOSTER_T2_CONTAINER.get(), windowId);
        Player player = playerInventory.player;
        BlockPos pos = buf.readBlockPos();
        this.blockEntity = (TileBoosterT2)player.getCommandSenderWorld().getBlockEntity(pos);
        this.playerEntity = player;
    }

    public BoosterT2Container(int windowId, BlockPos pos, Inventory playerInventory) {
        super((MenuType)Registration.BLOCKBOOSTER_T2_CONTAINER.get(), windowId);
        Player player = playerInventory.player;
        this.blockEntity = (TileBoosterT2)player.getCommandSenderWorld().getBlockEntity(pos);
        this.playerEntity = player;
    }

    public BoosterT2Container(int windowId, Inventory playerInventory, BlockPos pos) {
        super((MenuType)Registration.BLOCKBOOSTER_T2_CONTAINER.get(), windowId);
        this.blockEntity = (TileBoosterT2)playerInventory.player.getCommandSenderWorld().getBlockEntity(pos);
        this.playerEntity = playerInventory.player;
    }

    public int getEnergyScaled(int scale) {
        return (int)((float)scale * ((float)this.blockEntity.getEnergy() / (float)this.blockEntity.getMaxEnergy()));
    }

    public boolean isDisabled() {
        return this.blockEntity.isDisabled;
    }

    public boolean isLagging() {
        return this.blockEntity.isLagging();
    }

    public double getCurrentTPS() {
        return this.blockEntity.getCurrentTPS();
    }

    public int getEnergy() {
        return this.blockEntity != null ? this.blockEntity.getEnergy() : 0;
    }

    public int getMaxEnergy() {
        return this.blockEntity.getMaxEnergy();
    }

    public ItemStack quickMoveStack(Player p_38941_, int p_38942_) {
        return null;
    }

    public boolean stillValid(Player playerIn) {
        return BoosterT2Container.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.blockEntity.getLevel(), (BlockPos)this.blockEntity.getBlockPos()), (Player)this.playerEntity, (Block)((Block)Registration.BLOCKBOOSTER_T2.get()));
    }

    public HashMap<Long, BlockEntity> getAttachedBlocks() {
        return this.blockEntity.getAttachedBlocks();
    }

    public boolean isChecked(int i) {
        return this.blockEntity.isIndexEnabled(i);
    }

    public void checkboxClicked(long id, boolean val) {
        Messages.sendToServer(new BoosterPacket(this.blockEntity.getBlockPos(), id, val));
    }

    public HashMap<Long, Boolean> getBoostFlags() {
        return this.blockEntity.getBoostFlags();
    }
}

