/*
 * Decompiled with CFR 0.152.
 */
package igentuman.blockbooster.datagen;

import igentuman.blockbooster.datagen.BbLanguageProvider;
import igentuman.blockbooster.datagen.BbRecipes;
import igentuman.blockbooster.datagen.BlockTags;
import igentuman.blockbooster.datagen.BoosterLootTable;
import java.util.Collections;
import java.util.List;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="blockbooster")
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        if (event.includeServer()) {
            generator.addProvider(true, (DataProvider)new BbRecipes(generator, event.getLookupProvider()));
            generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(generator.getPackOutput(), Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(paramSet -> new BoosterLootTable(), LootContextParamSets.BLOCK)), event.getLookupProvider()));
            BlockTags blockTags = new BlockTags(generator, event.getLookupProvider(), event.getExistingFileHelper());
            event.getGenerator().addProvider(event.includeServer(), (DataProvider)blockTags);
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new BbLanguageProvider(generator, "en_us"));
        }
    }
}

