/*
 * Decompiled with CFR 0.152.
 */
package igentuman.blockbooster.event;

import igentuman.blockbooster.util.BlockEntityLookTracker;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="blockbooster")
public class PlayerTickHandler {
    private static int lookCheckCounter = 0;
    private static final int LOOK_CHECK_INTERVAL = 10;

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        if (event.getEntity().level().isClientSide) {
            return;
        }
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (++lookCheckCounter >= 10) {
                lookCheckCounter = 0;
                BlockEntityLookTracker.updatePlayerLook(serverPlayer);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        BlockEntityLookTracker.removePlayer(event.getEntity().getUUID());
    }
}

