/*
 * Decompiled with CFR 0.152.
 */
package igentuman.blockbooster.event;

import igentuman.blockbooster.block.IBoosterBlock;
import igentuman.blockbooster.config.CommonConfig;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber(modid="blockbooster")
public class WorldEvents {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        boolean placed = true;
        BlockState state = event.getState();
        if (state == null) {
            return;
        }
        Block block = state.getBlock();
        if (block instanceof IBoosterBlock) {
            IBoosterBlock booster = (IBoosterBlock)block;
            placed = IBoosterBlock.processBlockPlace(event.getLevel(), event.getPos(), event.getPlacedBlock(), state, event.getPlacedAgainst());
        }
        if (!placed) {
            event.setCanceled(true);
            event.getEntity().sendSystemMessage((Component)Component.translatable((String)"booster.limit_message", (Object[])new Object[]{CommonConfig.GENERAL.boosters_per_chunk.get()}));
        }
    }
}

